/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.metaborg.util.collection.ImmutableCollection;
import org.metaborg.util.collection.Sets;

@Deprecated
public abstract class Bag<E>
implements Collection<E> {
    protected abstract Map<E, Integer> backingMap();

    @Override
    public boolean isEmpty() {
        return this.backingMap().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.backingMap().containsKey(o);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        Object[] result = a.length < size ? (Object[])Array.newInstance(a.getClass().getComponentType(), size) : a;
        int i = 0;
        for (E e : this) {
            result[i] = e;
            ++i;
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof Bag) {
            Bag other = (Bag)c;
            this.containsAll(other.backingMap().keySet());
        }
        return c.stream().allMatch(this::contains);
    }

    @Override
    public Iterator<E> iterator() {
        return this.backingMap().entrySet().stream().flatMap(entry -> {
            Object e = entry.getKey();
            return Stream.generate(() -> e).limit(((Integer)entry.getValue()).intValue());
        }).iterator();
    }

    public int count(E i) {
        return this.backingMap().getOrDefault(i, 0);
    }

    public Set<E> elementSet() {
        return Collections.unmodifiableSet(this.backingMap().keySet());
    }

    @Deprecated
    public static final class Immutable<E>
    extends Bag<E>
    implements ImmutableCollection<E> {
        private Map<E, Integer> backingMap;
        private int size;

        private Immutable(Map<E, Integer> backingMap, int size) {
            this.backingMap = backingMap;
            this.size = size;
        }

        public static <E> Immutable<E> of() {
            return new Immutable(Collections.emptyMap(), 0);
        }

        @Override
        protected Map<E, Integer> backingMap() {
            return this.backingMap;
        }

        @Override
        public int size() {
            return this.size;
        }

        public Transient<E> asTransient() {
            return new Transient(new HashMap<E, Integer>(this.backingMap), this.size);
        }
    }

    @Deprecated
    public static final class Transient<E>
    extends Bag<E> {
        private Map<E, Integer> backingMap;
        private int size = 0;
        private Immutable<E> frozen;

        private Transient(Map<E, Integer> backingMap, int size) {
            this.backingMap = backingMap;
        }

        public static <E> Transient<E> of() {
            return new Transient(new HashMap(), 0);
        }

        public static <E> Transient<E> withSizeEstimate(int initialCapacity) {
            return new Transient(new HashMap(Sets.hashCapacity(initialCapacity)), 0);
        }

        @Override
        public Map<E, Integer> backingMap() {
            return this.backingMap;
        }

        @Override
        public boolean add(E e) {
            if (this.frozen != null) {
                throw new IllegalStateException();
            }
            this.backingMap.compute(e, (k, v) -> v == null ? 1 : v + 1);
            ++this.size;
            return true;
        }

        @Override
        public boolean remove(Object o) {
            if (this.frozen != null) {
                throw new IllegalStateException();
            }
            if (!this.backingMap.containsKey(o)) {
                return false;
            }
            this.backingMap.computeIfPresent(o, (k, v) -> v == 1 ? null : Integer.valueOf(v - 1));
            --this.size;
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            if (this.frozen != null) {
                throw new IllegalStateException();
            }
            if (c instanceof Bag) {
                Bag other = (Bag)c;
                for (Map.Entry e : other.backingMap().entrySet()) {
                    Object key = e.getKey();
                    this.backingMap.put(key, this.backingMap.getOrDefault(key, 0) + e.getValue());
                }
            }
            return c.stream().map(this::add).reduce(false, (a, b) -> a != false || b != false);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (this.frozen != null) {
                throw new IllegalStateException();
            }
            if (c instanceof Bag) {
                Bag other = (Bag)c;
                for (Map.Entry e : other.backingMap().entrySet()) {
                    Object key = e.getKey();
                    int newDuplicates = this.backingMap.getOrDefault(key, 0) - e.getValue();
                    if (newDuplicates <= 0) {
                        this.backingMap.remove(key);
                        continue;
                    }
                    this.backingMap.put(key, newDuplicates);
                }
            }
            return c.stream().map(this::remove).reduce(false, (a, b) -> a != false || b != false);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            if (this.frozen != null) {
                throw new IllegalStateException();
            }
            if (c instanceof Bag) {
                Bag other = (Bag)c;
                boolean changed = false;
                for (Map.Entry<Object, Integer> entry : this.backingMap.entrySet()) {
                    Object key = entry.getKey();
                    int newDuplicates = other.backingMap().getOrDefault(key, 0);
                    if (newDuplicates <= 0) {
                        this.backingMap.remove(key);
                        changed = true;
                        continue;
                    }
                    changed |= this.backingMap.put(key, newDuplicates) == newDuplicates;
                }
            }
            HashMap<E, Integer> newBackingMap = new HashMap<E, Integer>(Sets.hashCapacity(c.size()));
            int newSize = 0;
            for (Map.Entry<Object, Integer> entry : c) {
                if (!this.contains(entry)) continue;
                Map.Entry<Object, Integer> e = entry;
                Integer duplicates = this.backingMap.get(e);
                newBackingMap.put(e, duplicates);
                newSize += duplicates.intValue();
            }
            if (newSize < this.size()) {
                this.backingMap = newBackingMap;
                this.size = newSize;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            if (this.frozen != null) {
                throw new IllegalStateException();
            }
            this.backingMap.clear();
        }

        @Override
        public int size() {
            return this.size;
        }

        public Immutable<E> freeze() {
            if (this.frozen == null) {
                this.frozen = new Immutable(Collections.unmodifiableMap(this.backingMap), this.size);
            }
            return this.frozen;
        }

        public int setCount(E elem, int count) {
            if (count < 0) {
                throw new IllegalArgumentException("Count cannot be negative");
            }
            int oldCount = this.backingMap.getOrDefault(elem, 0);
            if (count == 0) {
                this.backingMap.remove(elem);
            } else {
                this.backingMap.put(elem, count);
            }
            this.size += count - oldCount;
            return oldCount;
        }

        public int add(E elem, int count) {
            if (count < 0) {
                throw new IllegalArgumentException("Count cannot be negative");
            }
            if (count == 0) {
                return this.count(elem);
            }
            int oldCount = this.backingMap.getOrDefault(elem, 0);
            this.backingMap.put(elem, oldCount + count);
            this.size += count;
            return oldCount;
        }

        public int remove(E elem, int count) {
            if (count < 0) {
                throw new IllegalArgumentException("Count cannot be negative");
            }
            if (count == 0) {
                return this.count(elem);
            }
            int oldCount = this.backingMap.getOrDefault(elem, 0);
            if (count > oldCount) {
                this.backingMap.remove(elem);
                this.size -= oldCount;
            } else {
                this.backingMap.put(elem, oldCount - count);
                this.size -= count;
            }
            return oldCount;
        }
    }
}

