/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.tracing;

import jakarta.annotation.Nullable;
import org.metaborg.spoofax.core.esv.ESVReader;
import org.metaborg.spoofax.core.tracing.HoverFacet;
import org.metaborg.spoofax.core.tracing.ResolverFacet;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.terms.IStrategoAppl;

public class ResolverFacetFromESV {
    private static final ILogger logger = LoggerUtils.logger(ResolverFacetFromESV.class);

    @Nullable
    public static ResolverFacet createResolver(IStrategoAppl esv) {
        IStrategoAppl resolver = ESVReader.findTerm(esv, "ReferenceRule");
        if (resolver == null) {
            return null;
        }
        String strategyName = ESVReader.termContents(resolver.getSubterm(1));
        if (strategyName == null) {
            logger.error("Could not get contents of ESV ReferenceRule {}, cannot create resolver facet", resolver);
            return null;
        }
        return new ResolverFacet(strategyName);
    }

    @Nullable
    public static HoverFacet createHover(IStrategoAppl esv) {
        IStrategoAppl hover = ESVReader.findTerm(esv, "HoverRule");
        if (hover == null) {
            return null;
        }
        String strategyName = ESVReader.termContents(hover.getSubterm(1));
        if (strategyName == null) {
            logger.error("Could not get contents of ESV HoverRule {}, cannot create hover facet", hover);
            return null;
        }
        return new HoverFacet(strategyName);
    }
}

