/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.syntax;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import mb.jsglr.shared.ImploderAttachment;
import mb.jsglr.shared.NullTokenizer;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.MessageFactory;
import org.metaborg.core.messages.MessageSeverity;
import org.metaborg.core.messages.MessageUtils;
import org.metaborg.core.source.ISourceRegion;
import org.metaborg.spoofax.core.syntax.IParserConfig;
import org.metaborg.spoofax.core.syntax.ImploderImplementation;
import org.metaborg.spoofax.core.syntax.JSGLRI;
import org.metaborg.spoofax.core.syntax.JSGLRParseErrorHandler;
import org.metaborg.spoofax.core.syntax.JSGLRParserConfiguration;
import org.metaborg.spoofax.core.syntax.JSGLRSourceRegionFactory;
import org.metaborg.spoofax.core.syntax.SourceAttachment;
import org.metaborg.spoofax.core.unit.ParseContrib;
import org.metaborg.util.collection.SetMultimap;
import org.metaborg.util.time.Timer;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.Asfix2TreeBuilder;
import org.spoofax.jsglr.client.Disambiguator;
import org.spoofax.jsglr.client.FilterException;
import org.spoofax.jsglr.client.NullTreeBuilder;
import org.spoofax.jsglr.client.ParseException;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.jsglr.client.SGLRParseResult;
import org.spoofax.jsglr.client.StartSymbolException;
import org.spoofax.jsglr.client.imploder.TermTreeFactory;
import org.spoofax.jsglr.client.imploder.TreeBuilder;
import org.spoofax.jsglr.io.SGLR;
import org.spoofax.jsglr.shared.BadTokenException;
import org.spoofax.jsglr.shared.SGLRException;
import org.spoofax.jsglr.shared.TokenExpectedException;
import org.spoofax.terms.attachments.ParentTermFactory;
import org.spoofax.terms.util.TermUtils;
import org.strategoxt.lang.Context;
import org.strategoxt.stratego_sglr.Main;
import org.strategoxt.stratego_sglr.implode_asfix_0_0;

public class JSGLR1I
extends JSGLRI<ParseTable> {
    private final SGLR parser;
    private final Context context;

    public JSGLR1I(IParserConfig config, ITermFactory termFactory, Context context, ILanguageImpl language, ILanguageImpl dialect) throws IOException {
        super(config, termFactory, language, dialect);
        TermTreeFactory factory = new TermTreeFactory(new ParentTermFactory(termFactory));
        this.parseTable = (ParseTable)this.getParseTable(config.getParseTableProvider());
        this.parser = new SGLR(new TreeBuilder(factory), (ParseTable)this.parseTable);
        this.context = context;
    }

    @Override
    public ParseContrib parse(@Nullable JSGLRParserConfiguration parserConfig, @Nullable FileObject resource, String input) {
        IStrategoTerm ast;
        SGLRParseResult result;
        if (parserConfig == null) {
            parserConfig = new JSGLRParserConfiguration();
        }
        String fileName = resource != null ? resource.getName().getURI() : null;
        JSGLRParseErrorHandler errorHandler = new JSGLRParseErrorHandler(this, resource, ((ParseTable)this.parseTable).hasRecovers());
        Timer timer = new Timer(true);
        try {
            result = this.actuallyParse(input, fileName, parserConfig);
            assert (result != null);
        }
        catch (InterruptedException | SGLRException e) {
            result = null;
            errorHandler.setRecoveryFailed(parserConfig.recovery);
            errorHandler.processFatalException(new NullTokenizer(input, fileName), e);
        }
        long duration = timer.stop();
        if (result != null) {
            ast = (IStrategoTerm)result.output;
            if (ast == null) {
                assert (this.parser.getTreeBuilder() instanceof NullTreeBuilder);
            } else {
                errorHandler.setRecoveryFailed(false);
                errorHandler.gatherNonFatalErrors(ast);
                if (resource != null) {
                    SourceAttachment.putSource(ast, resource);
                }
            }
        } else {
            ast = null;
        }
        boolean hasAst = ast != null;
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        for (IMessage message : errorHandler.messages()) {
            messages.add(message);
        }
        messages.addAll(this.addNonAssocErrorMessages(ast, resource));
        if (this.config.getImploderSetting() == ImploderImplementation.stratego) {
            for (BadTokenException badTokenException : this.parser.getCollectedErrors()) {
                String message = badTokenException.getMessage();
                messages.add(MessageFactory.newParseErrorAtTop(resource, message, null));
            }
        }
        boolean hasErrors = MessageUtils.containsSeverity(messages, MessageSeverity.ERROR);
        boolean isAmbiguous = hasAst && this.isAmbiguous(ast);
        return new ParseContrib(hasAst, hasAst && !hasErrors, isAmbiguous, ast, messages, duration);
    }

    private boolean isAmbiguous(IStrategoTerm ast) {
        LinkedList<IStrategoTerm> worklist = new LinkedList<IStrategoTerm>();
        worklist.add(ast);
        while (!worklist.isEmpty()) {
            IStrategoTerm term = (IStrategoTerm)worklist.pop();
            if (TermUtils.isAppl(term, "amb")) {
                return true;
            }
            worklist.addAll(term.getSubterms());
        }
        return false;
    }

    public SGLRParseResult actuallyParse(String text, @Nullable String filename, @Nullable JSGLRParserConfiguration parserConfig) throws SGLRException, InterruptedException {
        if (!parserConfig.implode || this.config.getImploderSetting() == ImploderImplementation.stratego) {
            this.parser.setTreeBuilder(new Asfix2TreeBuilder(this.termFactory));
        }
        this.parser.setUseStructureRecovery(parserConfig.recovery);
        if (parserConfig.cursorPosition == Integer.MAX_VALUE) {
            this.parser.setCompletionParse(false, Integer.MAX_VALUE);
        } else {
            this.parser.setCompletionParse(parserConfig.completion, parserConfig.cursorPosition);
        }
        this.parser.setTimeout(parserConfig.timeout);
        Disambiguator disambiguator = this.parser.getDisambiguator();
        if (this.dialect != null) {
            disambiguator.setHeuristicFilters(true);
        } else {
            disambiguator.setHeuristicFilters(false);
        }
        SGLRParseResult parseResult = this.parseAndRecover(text, filename, disambiguator, this.getOrDefaultStartSymbol(parserConfig));
        if (this.config.getImploderSetting() == ImploderImplementation.stratego) {
            Main.init(this.context);
            implode_asfix_0_0 imploder = implode_asfix_0_0.instance;
            IStrategoTerm syntaxTree = (IStrategoTerm)parseResult.output;
            return new SGLRParseResult(imploder.invoke(this.context, syntaxTree));
        }
        return parseResult;
    }

    public SGLRParseResult parseAndRecover(String text, String filename, Disambiguator disambiguator, String startSymbol) throws BadTokenException, TokenExpectedException, ParseException, SGLRException, InterruptedException, FilterException, StartSymbolException {
        try {
            return this.parser.parse(text, filename, startSymbol);
        }
        catch (FilterException e) {
            if ((e.getCause() == null || e.getCause() instanceof UnsupportedOperationException) && disambiguator.getFilterPriorities()) {
                disambiguator.setFilterPriorities(false);
                disambiguator.setFilterAssociativity(false);
                try {
                    SGLRParseResult sGLRParseResult = this.parser.parse(text, filename, startSymbol);
                    return sGLRParseResult;
                }
                finally {
                    disambiguator.setFilterPriorities(true);
                }
            }
            throw e;
        }
        catch (StartSymbolException e) {
            if (this.dialect != null) {
                return this.parser.parse(text, filename, null);
            }
            throw e;
        }
    }

    @Override
    public Set<BadTokenException> getCollectedErrors() {
        return this.parser.getCollectedErrors();
    }

    protected Collection<? extends IMessage> addNonAssocErrorMessages(IStrategoTerm ast, @Nullable FileObject resource) {
        ArrayList<? extends IMessage> result = new ArrayList<IMessage>();
        boolean addedMessage = false;
        if (TermUtils.isAppl(ast) && ast.getAllSubterms().length >= 1) {
            ISourceRegion region;
            String sortConsChild;
            SetMultimap<String, String> nonAssocProductions = ((ParseTable)this.parseTable).getNonAssocProductions();
            SetMultimap<String, String> nonNestedProductions = ((ParseTable)this.parseTable).getNonNestedProductions();
            String sortConsParent = String.valueOf(ImploderAttachment.getSort(ast)) + "." + ((IStrategoAppl)ast).getConstructor().getName();
            IStrategoTerm firstChild = ast.getSubterm(0);
            IStrategoTerm lastChild = ast.getSubterm(ast.getSubtermCount() - 1);
            if (TermUtils.isAppl(firstChild)) {
                IStrategoAppl leftMostChild = (IStrategoAppl)firstChild;
                ImploderAttachment leftMostChildAttachment = ImploderAttachment.get(leftMostChild);
                sortConsChild = String.valueOf(ImploderAttachment.getSort(ast)) + "." + leftMostChild.getConstructor().getName();
                if (leftMostChildAttachment != null && !leftMostChildAttachment.isBracket() && this.parseTable instanceof ParseTable && nonAssocProductions.containsEntry(sortConsParent, sortConsChild)) {
                    region = JSGLRSourceRegionFactory.fromTokens(ImploderAttachment.getLeftToken(ast), ImploderAttachment.getRightToken(ast));
                    result.add(MessageFactory.newParseError(resource, region, "Operator is non-associative", null));
                    addedMessage = true;
                }
            }
            if (TermUtils.isAppl(lastChild)) {
                IStrategoAppl rightMostChild = (IStrategoAppl)lastChild;
                ImploderAttachment rightMostChildAttachment = ImploderAttachment.get(rightMostChild);
                sortConsChild = String.valueOf(ImploderAttachment.getSort(ast)) + "." + rightMostChild.getConstructor().getName();
                if (rightMostChildAttachment != null && !rightMostChildAttachment.isBracket() && this.parseTable instanceof ParseTable && nonNestedProductions.containsEntry(sortConsParent, sortConsChild)) {
                    region = JSGLRSourceRegionFactory.fromTokens(ImploderAttachment.getLeftToken(ast), ImploderAttachment.getRightToken(ast));
                    result.add(MessageFactory.newParseError(resource, region, "Operator is non-nested", null));
                    addedMessage = true;
                }
            }
        }
        if (ast != null && !addedMessage) {
            IStrategoTerm[] iStrategoTermArray = ast.getAllSubterms();
            int n = iStrategoTermArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStrategoTerm child = iStrategoTermArray[n2];
                result.addAll(this.addNonAssocErrorMessages(child, resource));
                ++n2;
            }
        }
        return result;
    }
}

