/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.style;

import jakarta.annotation.Nullable;
import java.util.LinkedList;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.style.ICategory;
import org.metaborg.core.style.IRegionCategory;
import org.metaborg.core.style.IRegionStyle;
import org.metaborg.core.style.IStyle;
import org.metaborg.core.style.RegionStyle;
import org.metaborg.spoofax.core.style.ConsCategory;
import org.metaborg.spoofax.core.style.ISpoofaxStylerService;
import org.metaborg.spoofax.core.style.SortCategory;
import org.metaborg.spoofax.core.style.SortConsCategory;
import org.metaborg.spoofax.core.style.StylerFacet;
import org.metaborg.spoofax.core.style.TokenCategory;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.terms.IStrategoTerm;

public class StylerService
implements ISpoofaxStylerService {
    private static final ILogger logger = LoggerUtils.logger(StylerService.class);

    @Override
    public Iterable<IRegionStyle<IStrategoTerm>> styleParsed(ILanguageImpl language, Iterable<IRegionCategory<IStrategoTerm>> categorization) {
        StylerFacet facet = language.facet(StylerFacet.class);
        if (facet == null) {
            logger.error("Cannot style input of {}, it does not have a styler facet", language);
            return Iterables2.empty();
        }
        LinkedList<IRegionStyle<IStrategoTerm>> regionStyles = new LinkedList<IRegionStyle<IStrategoTerm>>();
        for (IRegionCategory<IStrategoTerm> regionCategory : categorization) {
            IRegionStyle<IStrategoTerm> regionStyle = this.style(facet, regionCategory);
            if (regionStyle == null) continue;
            regionStyles.add(regionStyle);
        }
        return regionStyles;
    }

    @Override
    public Iterable<IRegionStyle<IStrategoTerm>> styleAnalyzed(ILanguageImpl language, Iterable<IRegionCategory<IStrategoTerm>> categorization) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    private IRegionStyle<IStrategoTerm> style(StylerFacet facet, IRegionCategory<IStrategoTerm> regionCategory) {
        IStyle style;
        if (regionCategory.region().length() == 0) {
            return null;
        }
        ICategory category = regionCategory.category();
        if (category instanceof SortConsCategory) {
            SortConsCategory cat = (SortConsCategory)category;
            style = facet.sortConsStyle(cat.sort, cat.cons);
        } else if (category instanceof ConsCategory) {
            ConsCategory cat = (ConsCategory)category;
            style = facet.consStyle(cat.cons);
        } else if (category instanceof SortCategory) {
            SortCategory cat = (SortCategory)category;
            style = facet.sortStyle(cat.sort);
        } else if (category instanceof TokenCategory) {
            TokenCategory cat = (TokenCategory)category;
            style = facet.tokenStyle(cat.token);
        } else {
            style = null;
        }
        if (style == null) {
            logger.warn("Cannot determine style for category " + category.name());
            return null;
        }
        return new RegionStyle<IStrategoTerm>(regionCategory.region(), style, regionCategory.fragment());
    }
}

