/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.shell;

import java.io.IOException;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.action.CompileGoal;
import org.metaborg.core.action.EndNamedGoal;
import org.metaborg.core.action.ITransformGoal;
import org.metaborg.core.action.TransformActionContrib;
import org.metaborg.core.context.IContext;
import org.metaborg.core.language.ILanguage;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.WithLocationStreamMessagePrinter;
import org.metaborg.core.project.IProject;
import org.metaborg.core.project.ISimpleProjectService;
import org.metaborg.core.transform.ITransformConfig;
import org.metaborg.core.transform.TransformConfig;
import org.metaborg.spoofax.core.Spoofax;
import org.metaborg.spoofax.core.unit.ISpoofaxAnalyzeUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxInputUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxTransformUnit;
import org.metaborg.util.concurrent.IClosableLock;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.terms.IStrategoTerm;

public class CLIUtils {
    private static final ILogger logger = LoggerUtils.logger(CLIUtils.class);
    public static final String SPOOFAXPATH = "SPOOFAXPATH";
    private final Spoofax spoofax;

    public CLIUtils(Spoofax spoofax) {
        this.spoofax = spoofax;
    }

    public void loadLanguagesFromPath() throws MetaborgException {
        String spoofaxPath = System.getenv(SPOOFAXPATH);
        if (spoofaxPath != null) {
            String[] stringArray = spoofaxPath.split(":");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    String spoofaxPathComponentName = stringArray[n2];
                    if (!spoofaxPathComponentName.isEmpty()) {
                        FileObject spoofaxPathComponent;
                        try {
                            spoofaxPathComponent = this.spoofax.resourceService.resolve(spoofaxPathComponentName);
                        }
                        catch (MetaborgRuntimeException ex) {
                            String message = logger.format("Invalid path {} in SPOOFAXPATH", spoofaxPathComponentName);
                            logger.warn(message, ex);
                            break block11;
                        }
                        try {
                            if (spoofaxPathComponent.isFolder()) {
                                this.spoofax.languageDiscoveryService.languagesFromDirectory(spoofaxPathComponent);
                            } else if (spoofaxPathComponent.isFile()) {
                                this.spoofax.languageDiscoveryService.languagesFromArchive(spoofaxPathComponent);
                            }
                        }
                        catch (FileSystemException fileSystemException) {
                        }
                        catch (MetaborgException metaborgException) {
                            // empty catch block
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public ILanguageImpl loadLanguage(FileObject location) throws MetaborgException {
        try {
            if (location.isFolder()) {
                return this.spoofax.languageDiscoveryService.languageFromDirectory(location);
            }
            if (location.isFile()) {
                return this.spoofax.languageDiscoveryService.languageFromArchive(location);
            }
            throw new MetaborgException("Cannot load language from location with type " + location.getType());
        }
        catch (FileSystemException ex) {
            throw new MetaborgException(ex);
        }
    }

    public ILanguageImpl getLanguage(String languageName) throws MetaborgException {
        ILanguage lang = this.spoofax.languageService.getLanguage(languageName);
        if (lang == null) {
            throw new MetaborgException("Cannot find language " + languageName);
        }
        ILanguageImpl langImpl = lang.activeImpl();
        if (langImpl == null) {
            throw new MetaborgException("Language " + languageName + " has no active implementation");
        }
        return langImpl;
    }

    public FileObject getCWD() {
        String cwdPath = System.getProperty("user.dir");
        return this.spoofax.resolve(cwdPath != null ? cwdPath : ".");
    }

    public IProject getOrCreateCWDProject() throws MetaborgException {
        String cwdPath = System.getProperty("user.dir");
        FileObject cwd = this.spoofax.resolve(cwdPath != null ? cwdPath : ".");
        return this.getOrCreateProject(cwd);
    }

    public IProject getOrCreateProject(FileObject location) throws MetaborgException {
        ISimpleProjectService projectService = (ISimpleProjectService)this.spoofax.injector.getInstance(ISimpleProjectService.class);
        IProject project = projectService.get(location);
        if (project == null) {
            return projectService.create(location);
        }
        return project;
    }

    public IProject getProject(FileObject location) throws MetaborgException {
        IProject project = this.spoofax.projectService.get(location);
        if (project == null) {
            throw new MetaborgException("File " + location + " is not part of a project. Missing " + "metaborg.yaml" + "?");
        }
        return project;
    }

    public ISpoofaxInputUnit read(FileObject resource, ILanguageImpl lang) throws MetaborgException {
        String text;
        if (!this.spoofax.languageIdentifierService.identify(resource, lang)) {
            throw new MetaborgException(resource + " is not a file of " + lang.belongsTo().name());
        }
        try {
            text = this.spoofax.sourceTextService.text(resource);
        }
        catch (IOException e) {
            throw new MetaborgException("Cannot read " + resource, e);
        }
        ISpoofaxInputUnit inputUnit = (ISpoofaxInputUnit)this.spoofax.unitService.inputUnit(resource, text, lang, null);
        return inputUnit;
    }

    public ISpoofaxParseUnit parse(ISpoofaxInputUnit inputUnit, ILanguageImpl lang) throws MetaborgException {
        if (!this.spoofax.syntaxService.available(lang)) {
            throw new MetaborgException("Parsing not available.");
        }
        ISpoofaxParseUnit parseUnit = (ISpoofaxParseUnit)this.spoofax.syntaxService.parse(inputUnit);
        if (!parseUnit.valid()) {
            throw new MetaborgException("Parsing failed.");
        }
        return parseUnit;
    }

    public ISpoofaxAnalyzeUnit analyze(ISpoofaxParseUnit parseUnit, IContext context) throws MetaborgException {
        ISpoofaxAnalyzeUnit analysisUnit;
        ILanguageImpl lang = context.language();
        if (!this.spoofax.analysisService.available(lang)) {
            throw new MetaborgException("Analysis not available.");
        }
        Throwable throwable = null;
        Object var6_6 = null;
        try (IClosableLock lock = context.write();){
            analysisUnit = (ISpoofaxAnalyzeUnit)this.spoofax.analysisService.analyze(parseUnit, context).result();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!analysisUnit.valid()) {
            throw new MetaborgException("Analysis failed.");
        }
        return analysisUnit;
    }

    public TransformActionContrib getCompileAction(ILanguageImpl lang) throws MetaborgException {
        return this.getTransformAction(new CompileGoal(), lang);
    }

    public TransformActionContrib getNamedTransformAction(String name, ILanguageImpl lang) throws MetaborgException {
        return this.getTransformAction(new EndNamedGoal(name), lang);
    }

    public TransformActionContrib getTransformAction(ITransformGoal goal, ILanguageImpl lang) throws MetaborgException {
        TransformActionContrib action;
        if (!this.spoofax.actionService.available(lang, goal)) {
            throw new MetaborgException("Cannot find transformation " + goal);
        }
        try {
            action = Iterables2.getOnlyElement(this.spoofax.actionService.actionContributions(lang, goal));
        }
        catch (NoSuchElementException ex) {
            throw new MetaborgException("Transformation " + goal + " not a singleton.");
        }
        return action;
    }

    public IStrategoTerm transform(ISpoofaxAnalyzeUnit analysisUnit, TransformActionContrib action, IContext context) throws MetaborgException {
        TransformConfig config = new TransformConfig(true);
        ISpoofaxTransformUnit transformUnit = (ISpoofaxTransformUnit)this.spoofax.transformService.transform(analysisUnit, context, action, (ITransformConfig)config);
        if (!transformUnit.valid()) {
            throw new MetaborgException("Failed to transform " + transformUnit.source());
        }
        return transformUnit.ast();
    }

    public void printMessages(OutputStream os, Iterable<IMessage> messages) {
        WithLocationStreamMessagePrinter printer = new WithLocationStreamMessagePrinter(this.spoofax.sourceTextService, this.spoofax.projectService, os);
        for (IMessage message : messages) {
            printer.print(message, false);
        }
    }
}

