/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.dynamicclassloading;

import jakarta.annotation.Nullable;
import mb.util.vfs2.resource.ResourceUtils;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.spoofax.core.dynamicclassloading.IBuilderInput;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.StrategoString;
import org.spoofax.terms.StrategoTuple;

public class BuilderInput
extends StrategoTuple
implements IBuilderInput<IStrategoTerm, IStrategoTerm> {
    private final IStrategoTerm selection;
    private final IStrategoTerm position;
    private final IStrategoTerm ast;
    @Nullable
    private final FileObject resource;
    @Nullable
    private final FileObject location;

    public BuilderInput(ITermFactory termFactory, IStrategoTerm selection, IStrategoTerm position, IStrategoTerm ast, @Nullable FileObject resource, @Nullable FileObject location) {
        super(new IStrategoTerm[]{selection, position, ast, new StrategoString(BuilderInput.resourceString(resource, location), termFactory.makeList()), new StrategoString(BuilderInput.locationString(location), termFactory.makeList())}, termFactory.makeList());
        this.selection = selection;
        this.position = position;
        this.ast = ast;
        this.resource = resource;
        this.location = location;
    }

    private static String resourceString(@Nullable FileObject resource, @Nullable FileObject location) {
        if (resource != null && location != null) {
            return ResourceUtils.relativeName(resource.getName(), location.getName(), false);
        }
        if (resource != null) {
            return resource.getName().getURI();
        }
        return "";
    }

    private static String locationString(@Nullable FileObject location) {
        return location == null ? "" : location.getName().getURI();
    }

    @Override
    public IStrategoTerm getSelection() {
        return this.selection;
    }

    @Override
    public IStrategoTerm getPosition() {
        return this.position;
    }

    @Override
    public IStrategoTerm getAst() {
        return this.ast;
    }

    @Override
    @Nullable
    public FileObject getResource() {
        return this.resource;
    }

    @Override
    @Nullable
    public FileObject getLocation() {
        return this.location;
    }
}

