/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.analysis.taskengine;

import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.analysis.AnalysisException;
import org.metaborg.core.analysis.IAnalyzeResults;
import org.metaborg.core.context.IContext;
import org.metaborg.core.language.FacetContribution;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.MessageSeverity;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.spoofax.core.analysis.AnalysisCommon;
import org.metaborg.spoofax.core.analysis.AnalysisFacet;
import org.metaborg.spoofax.core.analysis.ISpoofaxAnalyzeResult;
import org.metaborg.spoofax.core.analysis.ISpoofaxAnalyzeResults;
import org.metaborg.spoofax.core.analysis.ISpoofaxAnalyzer;
import org.metaborg.spoofax.core.analysis.SpoofaxAnalyzeResult;
import org.metaborg.spoofax.core.analysis.SpoofaxAnalyzeResults;
import org.metaborg.spoofax.core.stratego.IStrategoCommon;
import org.metaborg.spoofax.core.stratego.IStrategoRuntimeService;
import org.metaborg.spoofax.core.unit.AnalyzeContrib;
import org.metaborg.spoofax.core.unit.AnalyzeUpdateData;
import org.metaborg.spoofax.core.unit.ISpoofaxAnalyzeUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxAnalyzeUnitUpdate;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxUnitService;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;
import org.strategoxt.HybridInterpreter;

public class TaskEngineAnalyzer
implements ISpoofaxAnalyzer {
    public static final String name = "taskengine";
    private static final ILogger logger = LoggerUtils.logger(TaskEngineAnalyzer.class);
    private final IResourceService resourceService;
    private final ISpoofaxUnitService unitService;
    private final ITermFactory termFactory;
    private final IStrategoRuntimeService runtimeService;
    private final IStrategoCommon strategoCommon;
    private final AnalysisCommon analysisCommon;
    private final IStrategoConstructor fileCons;

    @Inject
    public TaskEngineAnalyzer(IResourceService resourceService, ISpoofaxUnitService unitService, ITermFactory termFactory, IStrategoRuntimeService runtimeService, IStrategoCommon strategoCommon, AnalysisCommon analysisCommon) {
        this.resourceService = resourceService;
        this.unitService = unitService;
        this.termFactory = termFactory;
        this.runtimeService = runtimeService;
        this.strategoCommon = strategoCommon;
        this.analysisCommon = analysisCommon;
        this.fileCons = termFactory.makeConstructor("File", 3);
    }

    @Override
    public ISpoofaxAnalyzeResult analyze(ISpoofaxParseUnit input, IContext context, IProgress progress, ICancel cancel) throws AnalysisException, InterruptedException {
        if (!input.valid()) {
            String message = logger.format("Parse input for {} is invalid, cannot analyze", input.source());
            throw new AnalysisException(context, message);
        }
        IAnalyzeResults results = this.analyzeAll((Iterable)Iterables2.singleton(input), context, progress, cancel);
        return new SpoofaxAnalyzeResult((ISpoofaxAnalyzeUnit)results.results().iterator().next(), results.updates(), context);
    }

    @Override
    public ISpoofaxAnalyzeResults analyzeAll(Iterable<ISpoofaxParseUnit> inputs, IContext context, IProgress progress, ICancel cancel) throws AnalysisException, InterruptedException {
        HybridInterpreter runtime;
        cancel.throwIfCancelled();
        ILanguageImpl langImpl = context.language();
        FacetContribution<AnalysisFacet> facetContribution = langImpl.facetContribution(AnalysisFacet.class);
        if (facetContribution == null) {
            logger.debug("No analysis required for {}", langImpl);
            return new SpoofaxAnalyzeResults(context);
        }
        AnalysisFacet facet = (AnalysisFacet)facetContribution.facet;
        cancel.throwIfCancelled();
        try {
            runtime = this.runtimeService.runtime(facetContribution.contributor, context);
        }
        catch (MetaborgException e) {
            throw new AnalysisException(context, "Failed to get Stratego runtime", e);
        }
        cancel.throwIfCancelled();
        return this.analyzeAll(inputs, context, runtime, facet.strategyName, this.termFactory);
    }

    private ISpoofaxAnalyzeResults analyzeAll(Iterable<ISpoofaxParseUnit> inputs, IContext context, HybridInterpreter runtime, String strategy, ITermFactory termFactory) throws AnalysisException {
        String message;
        IStrategoTerm resultTerm;
        HashMap<String, ISpoofaxParseUnit> inputsPerSource = new HashMap<String, ISpoofaxParseUnit>();
        int detachedCounter = 0;
        ArrayList<IStrategoAppl> analysisInputs = new ArrayList<IStrategoAppl>();
        for (ISpoofaxParseUnit input : inputs) {
            String pathString;
            if (!input.valid()) {
                logger.warn("Parse result for {} is invalid, cannot analyze", input.source());
                continue;
            }
            if (input.detached()) {
                pathString = "detached-source-" + detachedCounter++;
                logger.debug("Parse input is detached, using '{}' as path", pathString);
            } else {
                pathString = input.source().getName().getURI();
            }
            inputsPerSource.put(pathString, input);
            IStrategoString pathTerm = termFactory.makeString(pathString);
            IStrategoReal durationTerm = termFactory.makeReal(input.duration());
            analysisInputs.add(termFactory.makeAppl(this.fileCons, pathTerm, input.ast(), durationTerm));
        }
        IStrategoList inputTerm = termFactory.makeList(analysisInputs);
        logger.trace("Invoking {} strategy", strategy);
        try {
            resultTerm = this.strategoCommon.invoke(runtime, inputTerm, strategy);
        }
        catch (MetaborgException e) {
            String message2 = this.analysisCommon.analysisFailedMessage(runtime);
            throw new AnalysisException(context, message2, e);
        }
        if (resultTerm == null) {
            message = this.analysisCommon.analysisFailedMessage(runtime);
            throw new AnalysisException(context, message);
        }
        if (!TermUtils.isAppl(resultTerm) || resultTerm.getSubtermCount() != 5) {
            message = logger.format("Unexpected results from analysis {}, expected 5-tuple", resultTerm);
            throw new AnalysisException(context, message);
        }
        IStrategoTerm resultsTerm = resultTerm.getSubterm(0);
        IStrategoTerm updateResultsTerm = resultTerm.getSubterm(1);
        ArrayList<ISpoofaxAnalyzeUnit> fileResults = new ArrayList<ISpoofaxAnalyzeUnit>(resultsTerm.getSubtermCount());
        for (IStrategoTerm result : resultsTerm) {
            ISpoofaxAnalyzeUnit fileResult = this.result(result, inputsPerSource, context, -1L);
            if (fileResult == null) continue;
            fileResults.add(fileResult);
        }
        ArrayList<ISpoofaxAnalyzeUnitUpdate> updateResults = new ArrayList<ISpoofaxAnalyzeUnitUpdate>(updateResultsTerm.getSubtermCount());
        for (IStrategoTerm result : updateResultsTerm) {
            ISpoofaxAnalyzeUnitUpdate updateResult = this.updateResult(result, context);
            if (updateResult == null) continue;
            updateResults.add(updateResult);
        }
        return new SpoofaxAnalyzeResults((Collection<ISpoofaxAnalyzeUnit>)fileResults, (Collection<ISpoofaxAnalyzeUnitUpdate>)updateResults, context);
    }

    @Nullable
    private ISpoofaxAnalyzeUnit result(IStrategoTerm result, Map<String, ISpoofaxParseUnit> inputsPerSource, IContext context, long duration) {
        FileObject source;
        String sourceString = TermUtils.toJavaStringAt(result, 0);
        try {
            source = this.resourceService.resolve(sourceString);
        }
        catch (MetaborgRuntimeException e) {
            logger.error("Cannot find original source for {}, skipping result", e, sourceString);
            return null;
        }
        ISpoofaxParseUnit input = inputsPerSource.get(sourceString);
        if (input == null) {
            logger.error("Cannot find input parse result for {}, skipping result", sourceString);
            return null;
        }
        IStrategoTerm ast = result.getSubterm(2);
        Collection<IMessage> errors = this.analysisCommon.messages(source, MessageSeverity.ERROR, result.getSubterm(3));
        Collection<IMessage> warnings = this.analysisCommon.messages(source, MessageSeverity.WARNING, result.getSubterm(4));
        Collection<IMessage> notes = this.analysisCommon.messages(source, MessageSeverity.NOTE, result.getSubterm(5));
        Collection<IMessage> ambiguities = this.analysisCommon.ambiguityMessages(source, ast);
        ArrayList<IMessage> messages = new ArrayList<IMessage>(errors.size() + warnings.size() + notes.size() + ambiguities.size());
        messages.addAll(errors);
        messages.addAll(warnings);
        messages.addAll(notes);
        messages.addAll(ambiguities);
        return this.unitService.analyzeUnit(input, new AnalyzeContrib(true, errors.isEmpty(), true, ast, messages, duration), context);
    }

    private ISpoofaxAnalyzeUnitUpdate updateResult(IStrategoTerm result, IContext context) {
        FileObject source;
        String sourceString = TermUtils.toJavaStringAt(result, 0);
        try {
            source = this.resourceService.resolve(sourceString);
        }
        catch (MetaborgRuntimeException e) {
            logger.debug("Cannot find original source for {}, skipping update result", e, sourceString);
            return null;
        }
        Collection<IMessage> errors = this.analysisCommon.messages(source, MessageSeverity.ERROR, result.getSubterm(1));
        Collection<IMessage> warnings = this.analysisCommon.messages(source, MessageSeverity.WARNING, result.getSubterm(2));
        Collection<IMessage> notes = this.analysisCommon.messages(source, MessageSeverity.NOTE, result.getSubterm(3));
        ArrayList<IMessage> messages = new ArrayList<IMessage>(errors.size() + warnings.size() + notes.size());
        messages.addAll(errors);
        messages.addAll(warnings);
        messages.addAll(notes);
        return this.unitService.analyzeUnitUpdate(source, new AnalyzeUpdateData(messages), context);
    }
}

