/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.parsetable;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import org.metaborg.parsetable.IParseTable;
import org.metaborg.parsetable.productions.IProduction;
import org.metaborg.parsetable.states.IState;
import org.metaborg.sdf2table.deepconflicts.Context;
import org.metaborg.sdf2table.deepconflicts.ContextPosition;
import org.metaborg.sdf2table.deepconflicts.ContextType;
import org.metaborg.sdf2table.deepconflicts.ContextualFactory;
import org.metaborg.sdf2table.deepconflicts.ContextualProduction;
import org.metaborg.sdf2table.deepconflicts.ContextualSymbol;
import org.metaborg.sdf2table.deepconflicts.DeepConflictsAnalyzer;
import org.metaborg.sdf2table.grammar.CharacterClassSymbol;
import org.metaborg.sdf2table.grammar.ContextFreeSymbol;
import org.metaborg.sdf2table.grammar.GeneralAttribute;
import org.metaborg.sdf2table.grammar.IAttribute;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.IterSepSymbol;
import org.metaborg.sdf2table.grammar.IterStarSepSymbol;
import org.metaborg.sdf2table.grammar.IterStarSymbol;
import org.metaborg.sdf2table.grammar.IterSymbol;
import org.metaborg.sdf2table.grammar.Layout;
import org.metaborg.sdf2table.grammar.LexicalSymbol;
import org.metaborg.sdf2table.grammar.NormGrammar;
import org.metaborg.sdf2table.grammar.OptionalSymbol;
import org.metaborg.sdf2table.grammar.Priority;
import org.metaborg.sdf2table.grammar.Production;
import org.metaborg.sdf2table.grammar.Sort;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.parsetable.LRItem;
import org.metaborg.sdf2table.parsetable.LabelFactory;
import org.metaborg.sdf2table.parsetable.ParseTableConfiguration;
import org.metaborg.sdf2table.parsetable.ParseTableProduction;
import org.metaborg.sdf2table.parsetable.State;
import org.metaborg.sdf2table.parsetable.StateStatus;
import org.metaborg.sdf2table.parsetable.SymbolStatesMapping;
import org.metaborg.sdf2table.util.CheckOverlap;
import org.metaborg.sdf2table.util.Graph;
import org.metaborg.sdf2table.util.SCCNodes;
import org.metaborg.util.collection.BiMap2;
import org.metaborg.util.collection.SetMultimap;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class ParseTable
implements IParseTable,
Serializable {
    private static final long serialVersionUID = -1845408435423897026L;
    private static final ILogger logger = LoggerUtils.logger(ParseTable.class);
    public static final int FIRST_PRODUCTION_LABEL = 257;
    public static final int INITIAL_STATE_NUMBER = 0;
    public static final int VERSION_NUMBER = 7;
    private final NormGrammar grammar;
    private final ContextualFactory cf;
    private final int initialStateNumber = 0;
    private int processedStates = 0;
    private int totalStates = 0;
    private org.metaborg.sdf2table.grammar.IProduction initialProduction;
    private BiMap2<org.metaborg.sdf2table.grammar.IProduction, Integer> productionLabels;
    private LabelFactory prodLabelFactory = new LabelFactory(257);
    private Queue<State> stateQueue = new ArrayDeque<State>();
    private Map<Integer, State> stateLabels = new LinkedHashMap<Integer, State>();
    private final Set<org.metaborg.sdf2table.grammar.IProduction> danglingSuffix = new HashSet<org.metaborg.sdf2table.grammar.IProduction>();
    private final Set<org.metaborg.sdf2table.grammar.IProduction> danglingPrefix = new HashSet<org.metaborg.sdf2table.grammar.IProduction>();
    private SymbolStatesMapping symbolStatesMapping = new SymbolStatesMapping();
    private Map<Set<LRItem>, State> kernelStatesMapping = new LinkedHashMap<Set<LRItem>, State>();
    private Map<LRItem, Set<LRItem>> itemDerivedItemsCache = new LinkedHashMap<LRItem, Set<LRItem>>();
    private List<IProduction> productions = new ArrayList<IProduction>();
    Map<org.metaborg.sdf2table.grammar.IProduction, ParseTableProduction> productionsMapping = new LinkedHashMap<org.metaborg.sdf2table.grammar.IProduction, ParseTableProduction>();
    private final ParseTableConfiguration config;
    private Map<Set<Context>, Integer> ctxUniqueInt = new HashMap<Set<Context>, Integer>();
    private final Map<Integer, Integer> leftmostContextsMapping = new LinkedHashMap<Integer, Integer>();
    private final Map<Integer, Integer> rightmostContextsMapping = new LinkedHashMap<Integer, Integer>();

    public ParseTable(NormGrammar grammar, ParseTableConfiguration config) {
        this.grammar = grammar;
        this.cf = new ContextualFactory();
        this.config = config;
        SCCNodes<ISymbol> scc = null;
        if (config.isCheckOverlap()) {
            scc = new SCCNodes<ISymbol>(this.createGraphFromProductions());
            scc.calculateSCCNodes();
            this.extractExpressionGrammars(scc);
        }
        this.calculateNullable();
        this.calculateRecursion();
        this.normalizePriorities();
        this.createLabels();
        if (config.isCheckPriorities()) {
            this.checkMissingPriorities();
        }
        if (config.isCheckOverlap()) {
            this.checkHarmfulOverlap(scc);
        }
        if (config.isSolveDeepConflicts()) {
            DeepConflictsAnalyzer analysis = DeepConflictsAnalyzer.fromParseTable(this);
            analysis.patchParseTable();
            this.updateLabelsContextualProductions();
        }
        this.createJSGLRParseTableProductions(this.productionLabels);
        this.initialProduction = grammar.getInitialProduction();
        if (!config.isDynamic()) {
            State s0 = new State(this.initialProduction, this);
            this.stateQueue.add(s0);
            this.processStateQueue();
            this.cleanupTable();
        }
    }

    private void cleanupTable() {
        this.danglingPrefix.clear();
        this.danglingSuffix.clear();
        this.symbolStatesMapping.itemStates.clear();
        this.symbolStatesMapping.symbolItems.clear();
        this.itemDerivedItemsCache.clear();
        this.kernelStatesMapping.clear();
        this.leftmostContextsMapping.clear();
        this.cachedItems().clear();
        this.productionsMapping.clear();
        this.rightmostContextsMapping.clear();
        this.grammar.cleanupGrammar();
    }

    private void calculateNullable() {
        boolean markedNullable = false;
        do {
            markedNullable = false;
            for (Production p : this.grammar.getUniqueProductionMapping().values()) {
                if (((Set)this.grammar.getProductionAttributesMapping().get(p)).contains(this.normalizedGrammar().getGrammarFactory().createGeneralAttribute("recover")) || ((Set)this.grammar.getProductionAttributesMapping().get(p)).contains(this.normalizedGrammar().getGrammarFactory().createGeneralAttribute("placeholder-insertion")) || ((Set)this.grammar.getProductionAttributesMapping().get(p)).contains(this.normalizedGrammar().getGrammarFactory().createGeneralAttribute("literal-completion"))) continue;
                if (p.getRhs().isEmpty() && !p.leftHand().isNullable()) {
                    p.leftHand().setNullable(true);
                    markedNullable = true;
                    continue;
                }
                boolean nullable = true;
                for (ISymbol iSymbol : p.getRhs()) {
                    if (((Symbol)iSymbol).isNullable()) continue;
                    nullable = false;
                    break;
                }
                if (!nullable || p.leftHand().isNullable()) continue;
                p.leftHand().setNullable(nullable);
                markedNullable = true;
            }
        } while (markedNullable);
    }

    private void calculateRecursion() {
        ArrayList prodsVisited = new ArrayList();
        for (Production p : this.grammar.getUniqueProductionMapping().values()) {
            this.leftRecursive(p, new ArrayList<Symbol>(), new ArrayList<org.metaborg.sdf2table.grammar.IProduction>());
        }
        prodsVisited.clear();
        for (Production p : this.grammar.getUniqueProductionMapping().values()) {
            this.rightRecursive(p, new ArrayList<ISymbol>(), new ArrayList<org.metaborg.sdf2table.grammar.IProduction>());
        }
        for (Production p : this.grammar.getUniqueProductionMapping().values()) {
            p.calculateRecursion(this.grammar);
        }
        this.calculateDerivations();
    }

    private void calculateDerivations() {
        ArrayList<ISymbol> processedSymbols = new ArrayList<ISymbol>();
        for (ISymbol s : this.grammar.getSymbolProductionsMapping().keySet()) {
            this.calculateDerivations(s, processedSymbols);
        }
    }

    private void calculateDerivations(ISymbol s, List<ISymbol> processedSymbols) {
        if (processedSymbols.contains(s)) {
            return;
        }
        this.grammar.getLeftDerivable().put(s, s);
        this.grammar.getRightDerivable().put(s, s);
        for (org.metaborg.sdf2table.grammar.IProduction p : (Set)this.grammar.getSymbolProductionsMapping().get(s)) {
            if (p.rightHand().isEmpty()) continue;
            ISymbol leftmost = p.rightHand().get(0);
            ISymbol rightmost = p.rightHand().get(p.arity() - 1);
            if (!(leftmost instanceof Sort && ((Sort)leftmost).getType() != null || leftmost instanceof CharacterClassSymbol)) {
                this.grammar.getLeftDerivable().put(s, leftmost);
                this.putLeftDerivables(s, leftmost, processedSymbols);
            }
            if (rightmost instanceof Sort && ((Sort)rightmost).getType() != null || rightmost instanceof CharacterClassSymbol) continue;
            this.grammar.getRightDerivable().put(s, rightmost);
            this.putRightDerivables(s, rightmost, processedSymbols);
        }
        processedSymbols.add(s);
    }

    private void putRightDerivables(ISymbol s, ISymbol rightmost, List<ISymbol> processedSymbols) {
        if (processedSymbols.contains(rightmost)) {
            this.grammar.getRightDerivable().putAll(s, (Collection<ISymbol>)this.grammar.getRightDerivable().get(rightmost));
        }
        for (org.metaborg.sdf2table.grammar.IProduction p : (Set)this.grammar.getSymbolProductionsMapping().get(rightmost)) {
            ISymbol right;
            if (p.rightHand().isEmpty() || (right = p.rightHand().get(p.arity() - 1)) instanceof Sort && ((Sort)right).getType() != null || ((Set)this.grammar.getRightDerivable().get(s)).contains(right) || right instanceof CharacterClassSymbol) continue;
            this.grammar.getRightDerivable().put(s, right);
            this.putRightDerivables(s, right, processedSymbols);
        }
    }

    private void putLeftDerivables(ISymbol s, ISymbol leftmost, List<ISymbol> processedSymbols) {
        if (processedSymbols.contains(leftmost)) {
            this.grammar.getLeftDerivable().putAll(s, (Collection<ISymbol>)this.grammar.getLeftDerivable().get(leftmost));
        }
        for (org.metaborg.sdf2table.grammar.IProduction p : (Set)this.grammar.getSymbolProductionsMapping().get(leftmost)) {
            ISymbol left;
            if (p.rightHand().isEmpty() || (left = p.rightHand().get(0)) instanceof Sort && ((Sort)left).getType() != null || ((Set)this.grammar.getLeftDerivable().get(s)).contains(left) || left instanceof CharacterClassSymbol) continue;
            this.grammar.getLeftDerivable().put(s, left);
            this.putLeftDerivables(s, left, processedSymbols);
        }
    }

    private void leftRecursive(org.metaborg.sdf2table.grammar.IProduction prod, List<Symbol> seen, List<org.metaborg.sdf2table.grammar.IProduction> prodsVisited) {
        if (prodsVisited.contains(prod)) {
            return;
        }
        prodsVisited.add(prod);
        ArrayList<Symbol> just_seen = new ArrayList<Symbol>(seen);
        just_seen.add((Symbol)prod.leftHand());
        for (ISymbol s : prod.rightHand()) {
            if (just_seen.contains(s)) {
                HashSet<ISymbol> cycle = new HashSet<ISymbol>();
                int pos = just_seen.size() - 1;
                while (pos != just_seen.indexOf(s)) {
                    cycle.add((ISymbol)just_seen.get(pos));
                    --pos;
                }
                cycle.add((ISymbol)just_seen.get(pos));
                for (ISymbol symbol : cycle) {
                    this.grammar.getLeftRecursiveSymbolsMapping().putAll(symbol, cycle);
                }
            } else {
                for (org.metaborg.sdf2table.grammar.IProduction p : (Set)this.grammar.getSymbolProductionsMapping().get((Symbol)s)) {
                    this.leftRecursive(p, just_seen, prodsVisited);
                }
            }
            if (!s.isNullable()) break;
        }
    }

    private void rightRecursive(org.metaborg.sdf2table.grammar.IProduction prod, List<ISymbol> seen, List<org.metaborg.sdf2table.grammar.IProduction> prodsVisited) {
        if (prodsVisited.contains(prod)) {
            return;
        }
        prodsVisited.add(prod);
        ArrayList<ISymbol> just_seen = new ArrayList<ISymbol>(seen);
        just_seen.add(prod.leftHand());
        int i = prod.arity() - 1;
        while (i >= 0) {
            ISymbol s = prod.rightHand().get(i);
            if (just_seen.contains(s)) {
                HashSet<ISymbol> cycle = new HashSet<ISymbol>();
                int pos = just_seen.size() - 1;
                while (pos != just_seen.indexOf(s)) {
                    cycle.add((ISymbol)just_seen.get(pos));
                    --pos;
                }
                cycle.add((ISymbol)just_seen.get(pos));
                for (ISymbol symbol : cycle) {
                    this.grammar.getRightRecursiveSymbolsMapping().putAll(symbol, cycle);
                }
            } else {
                for (org.metaborg.sdf2table.grammar.IProduction p : (Set)this.grammar.getSymbolProductionsMapping().get(s)) {
                    this.rightRecursive(p, just_seen, prodsVisited);
                }
            }
            if (!s.isNullable()) break;
            --i;
        }
    }

    private void normalizePriorities() {
        this.normalizeAssociativePriorities();
        for (Priority p : this.grammar.priorities().keySet()) {
            if (!((Set)this.grammar.priorities().get(p)).contains(-1) || !this.mutuallyRecursive(p)) continue;
            HashSet<Integer> new_values = new HashSet<Integer>();
            if (p.lower().leftRecursivePosition() != -1 && p.lower().rightRecursivePosition() == -1) {
                new_values.add(p.higher().rightRecursivePosition());
            }
            if (p.lower().rightRecursivePosition() != -1 && p.lower().leftRecursivePosition() == -1) {
                new_values.add(p.higher().leftRecursivePosition());
            }
            if (p.lower().rightRecursivePosition() != -1 && p.lower().leftRecursivePosition() != -1) {
                new_values.add(p.higher().rightRecursivePosition());
                new_values.add(p.higher().leftRecursivePosition());
            }
            if (p.lower().arity() == 1 || p.lower().arity() == 0) {
                new_values.add(p.higher().rightRecursivePosition());
                new_values.add(p.higher().leftRecursivePosition());
            }
            boolean matchPrefix = false;
            int i = 0;
            int j = 0;
            while (i < p.higher().arity() && j < p.lower().arity()) {
                if (!p.higher().rightHand().get(i).equals(p.lower().rightHand().get(j))) {
                    matchPrefix = false;
                    break;
                }
                matchPrefix = true;
                ++i;
                ++j;
            }
            if (matchPrefix && (p.higher().rightRecursivePosition() == i - 1 || p.lower().rightRecursivePosition() == j - 1)) {
                new_values.add(i - 1);
                this.danglingSuffix.add(p.higher());
                this.danglingSuffix.add(p.lower());
            }
            boolean matchSuffix = false;
            i = p.higher().arity() - 1;
            j = p.lower().arity() - 1;
            while (i >= 0 && j >= 0) {
                if (!p.higher().rightHand().get(i).equals(p.lower().rightHand().get(j))) {
                    matchSuffix = false;
                    break;
                }
                matchSuffix = true;
                --i;
                --j;
            }
            if (matchSuffix && (p.higher().leftRecursivePosition() == i + 1 || p.lower().leftRecursivePosition() == j + 1)) {
                new_values.add(i + 1);
                this.danglingPrefix.add(p.higher());
                this.danglingPrefix.add(p.lower());
            }
            new_values.addAll((Collection<Integer>)this.grammar.priorities().get(p));
            this.grammar.priorities().replaceValues(p, new_values);
        }
        for (Priority p : this.grammar.priorities().keySet()) {
            this.grammar.getHigherPriorityProductions().put(p.higher(), p);
        }
        for (Priority p : this.grammar.getIndexedPriorities().keySet()) {
            this.grammar.getHigherPriorityProductions().put(p.higher(), p);
        }
    }

    private void normalizeAssociativePriorities() {
        SetMultimap<Priority, Integer> new_priorities = new SetMultimap<Priority, Integer>();
        for (Priority p : this.grammar.priorities().keySet()) {
            if (((Set)this.grammar.priorities().get(p)).contains(Integer.MIN_VALUE)) {
                if (p.higher().leftRecursivePosition() == -1) continue;
                Symbol leftRecursive = p.higher().getRhs().get(p.higher().leftRecursivePosition());
                if (p.higher().equals(p.lower()) && !leftRecursive.equals(p.higher().leftHand())) {
                    for (org.metaborg.sdf2table.grammar.IProduction prod : (Set)this.grammar.getSymbolProductionsMapping().get(leftRecursive)) {
                        if (((Production)prod).leftRecursivePosition() != -1 || ((Production)prod).rightRecursivePosition() == -1) continue;
                        new_priorities.put(this.normalizedGrammar().getGrammarFactory().createPriority(p.higher(), (Production)prod, false), p.higher().leftRecursivePosition());
                    }
                }
                if (p.higher().leftRecursivePosition() != -1) {
                    this.grammar.priorities().put(p, p.higher().leftRecursivePosition());
                }
            }
            if (!((Set)this.grammar.priorities().get(p)).contains(Integer.MAX_VALUE) || p.higher().rightRecursivePosition() == -1) continue;
            Symbol rightRecursive = p.higher().getRhs().get(p.higher().rightRecursivePosition());
            if (p.higher().equals(p.lower()) && !rightRecursive.equals(p.higher().leftHand())) {
                for (org.metaborg.sdf2table.grammar.IProduction prod : (Set)this.grammar.getSymbolProductionsMapping().get(rightRecursive)) {
                    if (((Production)prod).leftRecursivePosition() == -1 || ((Production)prod).rightRecursivePosition() != -1) continue;
                    new_priorities.put(this.normalizedGrammar().getGrammarFactory().createPriority(p.higher(), (Production)prod, false), p.higher().rightRecursivePosition());
                }
            }
            if (p.higher().rightRecursivePosition() == -1) continue;
            this.grammar.priorities().put(p, p.higher().rightRecursivePosition());
        }
        this.grammar.priorities().putAll(new_priorities);
    }

    private boolean mutuallyRecursive(Priority p) {
        return ((Set)this.grammar.getLeftRecursiveSymbolsMapping().get(p.higher().getLhs())).contains(p.lower().leftHand()) || ((Set)this.grammar.getRightRecursiveSymbolsMapping().get(p.higher().getLhs())).contains(p.lower().leftHand());
    }

    private void extractExpressionGrammars(SCCNodes<ISymbol> scc) {
        for (ISymbol s : this.grammar.getSymbols()) {
            if (this.isListSymbol(s) || this.isLayoutSymbol(s)) continue;
            for (org.metaborg.sdf2table.grammar.IProduction p : (Set)this.grammar.getSymbolProductionsMapping().get(s)) {
                for (ISymbol rhs_symb : p.rightHand()) {
                    if (rhs_symb.equals(s)) {
                        this.grammar.getExpressionGrammars().put(s, p);
                        continue;
                    }
                    if (scc.getNodesMapping().get(s) == null || !scc.getNodesMapping().get(s).contains(rhs_symb)) continue;
                    this.grammar.getExpressionGrammars().put(s, p);
                }
            }
        }
        for (ISymbol nonTerminalExpGrammar : this.grammar.getExpressionGrammars().keySet()) {
            HashSet<ISymbol> symbs = new HashSet<ISymbol>(Arrays.asList(nonTerminalExpGrammar));
            if (scc.getNodesMapping().get(nonTerminalExpGrammar) != null) {
                symbs.addAll((Collection<ISymbol>)scc.getNodesMapping().get(nonTerminalExpGrammar));
            }
            HashSet combinedGrammars = new HashSet();
            for (ISymbol recursive : symbs) {
                combinedGrammars.addAll(this.grammar.getExpressionGrammars().get(recursive));
            }
            this.grammar.getCombinedExpressionGrammars().add(combinedGrammars);
        }
    }

    private Graph<ISymbol> createGraphFromProductions() {
        Graph<ISymbol> result = new Graph<ISymbol>(this.grammar.getSymbols());
        for (ISymbol s : this.grammar.getSymbols()) {
            for (org.metaborg.sdf2table.grammar.IProduction p : (Set)this.grammar.getSymbolProductionsMapping().get(s)) {
                for (ISymbol rhs_symb : p.rightHand()) {
                    result.addEdge(s, rhs_symb);
                }
            }
        }
        return result;
    }

    public boolean isLayoutSymbol(ISymbol s) {
        boolean isLayout = false;
        if (s instanceof ContextFreeSymbol) {
            s = ((ContextFreeSymbol)s).getSymbol();
        }
        if (s instanceof OptionalSymbol) {
            s = ((OptionalSymbol)s).getSymbol();
        }
        if (s instanceof LexicalSymbol) {
            s = ((LexicalSymbol)s).getSymbol();
        }
        if (s instanceof Layout) {
            isLayout = true;
        }
        return isLayout;
    }

    private boolean isListSymbol(ISymbol s) {
        if (s instanceof OptionalSymbol) {
            s = ((OptionalSymbol)s).getSymbol();
        }
        if (s instanceof ContextFreeSymbol) {
            s = ((ContextFreeSymbol)s).getSymbol();
        }
        if (s instanceof LexicalSymbol) {
            s = ((LexicalSymbol)s).getSymbol();
        }
        return s instanceof IterSymbol || s instanceof IterStarSymbol || s instanceof IterStarSepSymbol || s instanceof IterSepSymbol;
    }

    private void createLabels() {
        BiMap2<org.metaborg.sdf2table.grammar.IProduction, Integer> labels = new BiMap2<org.metaborg.sdf2table.grammar.IProduction, Integer>();
        for (org.metaborg.sdf2table.grammar.IProduction iProduction : this.grammar.getUniqueProductionMapping().values()) {
            labels.put(iProduction, this.prodLabelFactory.getNextLabel());
        }
        this.productionLabels = labels;
    }

    private void checkMissingPriorities() {
        SetMultimap<ISymbol, Production> leftRecursive = new SetMultimap<ISymbol, Production>();
        SetMultimap<ISymbol, Production> rightRecursive = new SetMultimap<ISymbol, Production>();
        HashSet<ISymbol> recursiveSymbols = new HashSet<ISymbol>();
        for (Production p : this.grammar.getUniqueProductionMapping().values()) {
            if (p.leftRecursivePosition() != -1) {
                leftRecursive.put(p.leftHand(), p);
                recursiveSymbols.add(p.leftHand());
            }
            if (p.rightRecursivePosition() == -1) continue;
            rightRecursive.put(p.leftHand(), p);
            recursiveSymbols.add(p.leftHand());
        }
        SetMultimap<Production, Production> conflicts = new SetMultimap<Production, Production>();
        for (ISymbol s : recursiveSymbols) {
            for (Production p1 : (Set)leftRecursive.get(s)) {
                for (Production p2 : (Set)rightRecursive.get(s)) {
                    if (p1.equals(p2)) {
                        if (Symbol.isListNonTerminal(p1.leftHand()) || this.grammar.priorities().containsKey(this.normalizedGrammar().getGrammarFactory().createPriority(p1, p2, false)) || this.grammar.priorities().containsKey(this.normalizedGrammar().getGrammarFactory().createPriority(p2, p1, false)) || ((Set)conflicts.get(p2)).contains(p1)) continue;
                        conflicts.put(p1, p2);
                        logger.warn("GRAMMAR MAY CONTAIN AMBIGUITIES: No associativity declaration for production " + this.printWithConstructor(p1));
                        continue;
                    }
                    if (Symbol.isListNonTerminal(p1.leftHand()) || Symbol.isListNonTerminal(p2.leftHand()) || p2.arity() == 1 || p1.arity() == 1 || this.grammar.priorities().containsKey(this.normalizedGrammar().getGrammarFactory().createPriority(p1, p2, false)) || this.grammar.priorities().containsKey(this.normalizedGrammar().getGrammarFactory().createPriority(p2, p1, false)) || ((Set)conflicts.get(p2)).contains(p1)) continue;
                    conflicts.put(p1, p2);
                    logger.warn("GRAMMAR MAY CONTAIN AMBIGUITIES: No priority or associativity declaration between productions " + this.printWithConstructor(p1) + " and " + this.printWithConstructor(p2));
                }
            }
        }
        for (ISymbol s : recursiveSymbols) {
            for (Production p1 : (Set)leftRecursive.get(s)) {
                if (this.isNonAnnotatedLongestMatchList(p1, p1.leftRecursivePosition())) {
                    logger.warn("GRAMMAR MAY CONTAIN AMBIGUITIES: No longest match annotation on production " + this.printWithConstructor(p1));
                }
                for (Production p2 : (Set)leftRecursive.get(s)) {
                    if (p1 == p2 || !this.matchSuffix(p1, p2) || p1.getRhs().size() > p2.getRhs().size() && this.grammar.priorities().containsKey(this.normalizedGrammar().getGrammarFactory().createPriority(p1, p2, false)) || p2.getRhs().size() > p1.getRhs().size() && this.grammar.priorities().containsKey(this.normalizedGrammar().getGrammarFactory().createPriority(p2, p1, false)) || ((Set)conflicts.get(p2)).contains(p1)) continue;
                    conflicts.put(p1, p2);
                    if (p1.getRhs().size() > p2.getRhs().size() && !Symbol.isListNonTerminal(p1.leftHand())) {
                        logger.warn("GRAMMAR MAY CONTAIN AMBIGUITIES: No priority declaration " + this.printWithConstructor(p1) + " > " + this.printWithConstructor(p2));
                        continue;
                    }
                    if (Symbol.isListNonTerminal(p2.leftHand())) continue;
                    logger.warn("GRAMMAR MAY CONTAIN AMBIGUITIES: No priority declaration " + this.printWithConstructor(p2) + " > " + this.printWithConstructor(p1));
                }
            }
            for (Production p1 : (Set)rightRecursive.get(s)) {
                if (this.isNonAnnotatedLongestMatchList(p1, p1.rightRecursivePosition())) {
                    logger.warn("GRAMMAR MAY CONTAIN AMBIGUITIES: No longest match annotation on production " + this.printWithConstructor(p1));
                }
                for (Production p2 : (Set)rightRecursive.get(s)) {
                    if (p1 == p2 || !this.matchPrefix(p1, p2) || this.grammar.priorities().containsKey(this.normalizedGrammar().getGrammarFactory().createPriority(p1, p2, false)) || this.grammar.priorities().containsKey(this.normalizedGrammar().getGrammarFactory().createPriority(p2, p1, false)) || ((Set)conflicts.get(p2)).contains(p1)) continue;
                    conflicts.put(p1, p2);
                    if (p1.arity() > p2.arity() && !Symbol.isListNonTerminal(p1.leftHand())) {
                        logger.warn("GRAMMAR MAY CONTAIN AMBIGUITIES: No priority declaration " + this.printWithConstructor(p1) + " > " + this.printWithConstructor(p2));
                        continue;
                    }
                    if (Symbol.isListNonTerminal(p2.leftHand())) continue;
                    logger.warn("GRAMMAR MAY CONTAIN AMBIGUITIES: No priority declaration " + this.printWithConstructor(p2) + " > " + this.printWithConstructor(p1));
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void checkHarmfulOverlap(SCCNodes<ISymbol> scc) {
        for (Set<org.metaborg.sdf2table.grammar.IProduction> expProds : this.grammar.getCombinedExpressionGrammars()) {
            HashSet<org.metaborg.sdf2table.grammar.IProduction> emptyOperatorOverlappingProds = new HashSet<org.metaborg.sdf2table.grammar.IProduction>();
            HashSet<ISymbol> literals = new HashSet<ISymbol>();
            for (org.metaborg.sdf2table.grammar.IProduction p : expProds) {
                boolean emptyOperatorOverlap = false;
                for (ISymbol s : p.rightHand()) {
                    if (s instanceof Sort && ((Sort)s).getType() != null) {
                        literals.add(s);
                    }
                    if (s.equals(p.leftHand()) || scc.getNodesMapping().get(p.leftHand()) != null && scc.getNodesMapping().get(p.leftHand()).contains(s)) {
                        if (emptyOperatorOverlap) {
                            emptyOperatorOverlappingProds.add(p);
                            continue;
                        }
                        emptyOperatorOverlap = true;
                        continue;
                    }
                    if (s.isNullable()) continue;
                    emptyOperatorOverlap = false;
                }
            }
            HashSet<ISymbol> literalsConsidered = new HashSet<ISymbol>();
            for (ISymbol lit : literals) {
                boolean detectedHarmfulOverlap = false;
                if (literalsConsidered.contains(lit)) continue;
                literalsConsidered.add(lit);
                HashSet<org.metaborg.sdf2table.grammar.IProduction> overlappingProds = new HashSet<org.metaborg.sdf2table.grammar.IProduction>(emptyOperatorOverlappingProds);
                if (((Set)this.grammar.getLiteralProductionsMapping().get(lit)).size() > 1) {
                    for (org.metaborg.sdf2table.grammar.IProduction overlappingProd : (Set)this.grammar.getLiteralProductionsMapping().get(lit)) {
                        if (!expProds.contains(overlappingProd)) continue;
                        overlappingProds.add(overlappingProd);
                    }
                    ArrayDeque<Object> otherLits = new ArrayDeque<Object>();
                    for (org.metaborg.sdf2table.grammar.IProduction p : overlappingProds) {
                        for (Object symb_rhs : p.rightHand()) {
                            if (!(symb_rhs instanceof Sort) || ((Sort)symb_rhs).getType() == null || literalsConsidered.contains(symb_rhs)) continue;
                            otherLits.add(symb_rhs);
                        }
                    }
                    while (!otherLits.isEmpty()) {
                        Object symb_rhs;
                        ISymbol otherLit = (ISymbol)otherLits.remove();
                        if (literalsConsidered.contains(otherLit)) continue;
                        literalsConsidered.add(otherLit);
                        symb_rhs = ((Set)this.grammar.getLiteralProductionsMapping().get(otherLit)).iterator();
                        while (symb_rhs.hasNext()) {
                            org.metaborg.sdf2table.grammar.IProduction p = (org.metaborg.sdf2table.grammar.IProduction)symb_rhs.next();
                            if (!expProds.contains(p)) continue;
                            overlappingProds.add(p);
                            for (ISymbol symb_rhs2 : p.rightHand()) {
                                if (!(symb_rhs2 instanceof Sort) || ((Sort)symb_rhs2).getType() == null || literalsConsidered.contains(symb_rhs2)) continue;
                                otherLits.add(symb_rhs2);
                            }
                        }
                    }
                }
                if (overlappingProds.size() > 1) {
                    List<Set<org.metaborg.sdf2table.grammar.IProduction>> subsets = this.powerSet(overlappingProds);
                    int i = 0;
                    while (i < subsets.size()) {
                        Set<org.metaborg.sdf2table.grammar.IProduction> P2 = subsets.get(i);
                        int j = i;
                        while (j < subsets.size()) {
                            CheckOverlap checkOverlap;
                            String sentence;
                            Set<org.metaborg.sdf2table.grammar.IProduction> Q2 = subsets.get(j);
                            HashSet<org.metaborg.sdf2table.grammar.IProduction> intersection = new HashSet<org.metaborg.sdf2table.grammar.IProduction>(P2);
                            intersection.retainAll(Q2);
                            if (!P2.equals(Q2) && !intersection.equals(P2) && !intersection.equals(Q2) && this.containsSameOperators(P2, Q2) && (sentence = (checkOverlap = new CheckOverlap(P2, Q2, 5, scc)).checkHarmfulOverlap()) != null) {
                                String prods = "";
                                for (org.metaborg.sdf2table.grammar.IProduction p : overlappingProds) {
                                    prods = String.valueOf(prods) + this.printWithConstructor(p) + " ";
                                }
                                detectedHarmfulOverlap = true;
                                logger.warn("GRAMMAR MAY CONTAIN AMBIGUITIES: Harmful overlap with the sentence " + sentence + " between the productions: " + prods);
                                break;
                            }
                            ++j;
                        }
                        if (detectedHarmfulOverlap) break;
                        ++i;
                    }
                }
                if (!detectedHarmfulOverlap) continue;
            }
        }
    }

    private boolean containsSameOperators(Set<org.metaborg.sdf2table.grammar.IProduction> p, Set<org.metaborg.sdf2table.grammar.IProduction> q) {
        HashSet<ISymbol> operatorsP = new HashSet<ISymbol>();
        HashSet<ISymbol> operatorsQ = new HashSet<ISymbol>();
        for (org.metaborg.sdf2table.grammar.IProduction prods : p) {
            for (ISymbol symb_rhs : prods.rightHand()) {
                if (!(symb_rhs instanceof Sort) || ((Sort)symb_rhs).getType() == null) continue;
                operatorsP.add(symb_rhs);
            }
        }
        for (org.metaborg.sdf2table.grammar.IProduction prods : q) {
            for (ISymbol symb_rhs : prods.rightHand()) {
                if (!(symb_rhs instanceof Sort) || ((Sort)symb_rhs).getType() == null) continue;
                operatorsQ.add(symb_rhs);
            }
        }
        return operatorsP.equals(operatorsQ);
    }

    private List<Set<org.metaborg.sdf2table.grammar.IProduction>> powerSet(Set<org.metaborg.sdf2table.grammar.IProduction> set) {
        org.metaborg.sdf2table.grammar.IProduction[] element = new org.metaborg.sdf2table.grammar.IProduction[set.size()];
        set.toArray(element);
        int SET_LENGTH = 1 << element.length;
        ArrayList<Set<org.metaborg.sdf2table.grammar.IProduction>> powerSet = new ArrayList<Set<org.metaborg.sdf2table.grammar.IProduction>>();
        int binarySet = 0;
        while (binarySet < SET_LENGTH) {
            HashSet<org.metaborg.sdf2table.grammar.IProduction> subset = new HashSet<org.metaborg.sdf2table.grammar.IProduction>();
            int bit = 0;
            while (bit < element.length) {
                int mask = 1 << bit;
                if ((binarySet & mask) != 0) {
                    subset.add(element[bit]);
                }
                ++bit;
            }
            if (subset.size() > 0) {
                powerSet.add(subset);
            }
            ++binarySet;
        }
        return powerSet;
    }

    private boolean isNonAnnotatedLongestMatchList(org.metaborg.sdf2table.grammar.IProduction p, int pos) {
        ISymbol recSymbol;
        if (pos == -1) {
            return false;
        }
        if (!Symbol.isListNonTerminal(p.leftHand()) && Symbol.isListNonTerminal(recSymbol = p.rightHand().get(pos))) {
            Set attrs = (Set)this.grammar.getProductionAttributesMapping().get(p);
            for (IAttribute attr : attrs) {
                if (!(attr instanceof GeneralAttribute) || !((GeneralAttribute)attr).getName().equals("longest-match")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean matchSuffix(org.metaborg.sdf2table.grammar.IProduction p1, org.metaborg.sdf2table.grammar.IProduction p2) {
        int index = -1;
        if (p1.arity() > p2.arity()) {
            index = Collections.indexOfSubList(p1.rightHand(), p2.rightHand());
            return index > 0 && index == p1.arity() - p2.arity();
        }
        index = Collections.indexOfSubList(p2.rightHand(), p1.rightHand());
        return index > 0 && index == p2.arity() - p1.arity();
    }

    private boolean matchPrefix(org.metaborg.sdf2table.grammar.IProduction p1, org.metaborg.sdf2table.grammar.IProduction p2) {
        int index = Collections.indexOfSubList(p1.rightHand(), p2.rightHand());
        return index == 0;
    }

    private String printWithConstructor(org.metaborg.sdf2table.grammar.IProduction p) {
        ISymbol s = p.leftHand();
        String symbolName = s instanceof ContextFreeSymbol ? ((ContextFreeSymbol)s).getSymbol().name() : (s instanceof LexicalSymbol ? ((LexicalSymbol)s).getSymbol().name() : s.name());
        if (this.grammar.getConstructors().containsKey(p)) {
            return String.valueOf(symbolName) + "." + this.grammar.getConstructors().get(p).getConstructor();
        }
        return p.toString();
    }

    private void updateLabelsContextualProductions() {
        BiMap2<org.metaborg.sdf2table.grammar.IProduction, Integer> labels = this.productionLabels;
        if (!this.getConfig().isDataDependent()) {
            this.deriveContextualProductions();
            for (org.metaborg.sdf2table.grammar.IProduction iProduction : this.grammar.getUniqueProductionMapping().values()) {
                if (!this.grammar.getProdContextualProdMapping().containsKey(iProduction)) continue;
                labels.inverse().put(labels.get(iProduction), this.grammar.getProdContextualProdMapping().get(iProduction));
            }
            for (ContextualProduction contextualProduction : this.grammar.getDerivedContextualProds()) {
                labels.put(contextualProduction, this.prodLabelFactory.getNextLabel());
            }
        } else {
            for (ContextualProduction contextualProduction : this.grammar.getProdContextualProdMapping().values()) {
                for (ISymbol s : contextualProduction.rightHand()) {
                    if (!(s instanceof ContextualSymbol)) continue;
                    this.grammar.getContextualSymbols().add((ContextualSymbol)s);
                    Set productions = (Set)this.grammar.getSymbolProductionsMapping().get(((ContextualSymbol)s).getOrigSymbol());
                    this.grammar.getSymbolProductionsMapping().putAll(s, productions);
                }
            }
            for (org.metaborg.sdf2table.grammar.IProduction iProduction : this.grammar.getUniqueProductionMapping().values()) {
                if (!this.grammar.getProdContextualProdMapping().containsKey(iProduction)) continue;
                labels.inverse().put(labels.get(iProduction), this.grammar.getProdContextualProdMapping().get(iProduction));
            }
        }
    }

    private void createJSGLRParseTableProductions(BiMap2<org.metaborg.sdf2table.grammar.IProduction, Integer> labels) {
        int i = 0;
        while (i < labels.size()) {
            org.metaborg.sdf2table.grammar.IProduction p = labels.inverse().get(i + 257);
            Production orig_p = p instanceof ContextualProduction ? ((ContextualProduction)p).getOrigProduction() : (Production)p;
            ParseTableProduction prod = new ParseTableProduction(i + 257, p, (Set)this.grammar.getProductionAttributesMapping().get(orig_p), this.leftmostContextsMapping, this.rightmostContextsMapping, labels);
            this.productions.add(prod);
            this.productionsMapping.put(p, prod);
            ++i;
        }
    }

    private void deriveContextualProductions() {
        for (ContextualProduction p : this.grammar.getProdContextualProdMapping().values()) {
            for (ISymbol s : p.rightHand()) {
                if (!(s instanceof ContextualSymbol)) continue;
                this.grammar.getContextualSymbols().add((ContextualSymbol)s);
            }
        }
        ArrayDeque<ContextualSymbol> contextual_symbols = new ArrayDeque<ContextualSymbol>(this.grammar.getContextualSymbols());
        HashSet<ContextualSymbol> processed_symbols = new HashSet<ContextualSymbol>();
        while (!contextual_symbols.isEmpty()) {
            ContextualSymbol ctx_s = (ContextualSymbol)contextual_symbols.poll();
            if (processed_symbols.contains(ctx_s)) continue;
            processed_symbols.add(ctx_s);
            if (!this.getCtxUniqueInt().containsKey(ctx_s.getContexts())) {
                this.getCtxUniqueInt().put(ctx_s.getContexts(), this.getCtxUniqueInt().size());
            }
            for (org.metaborg.sdf2table.grammar.IProduction p : (Set)this.grammar.getSymbolProductionsMapping().get(ctx_s.getOrigSymbol())) {
                ContextualProduction new_prod;
                int labelP = this.productionLabels.get(p);
                Context deepLeft_ctx = this.cf.createContext(labelP, ContextType.DEEP, ContextPosition.LEFTMOST, this.leftmostContextsMapping, this.rightmostContextsMapping);
                Context deepRight_ctx = this.cf.createContext(labelP, ContextType.DEEP, ContextPosition.RIGHTMOST, this.leftmostContextsMapping, this.rightmostContextsMapping);
                Context danglingLeft_ctx = this.cf.createContext(labelP, ContextType.DANGLING, ContextPosition.LEFTMOST, this.leftmostContextsMapping, this.rightmostContextsMapping);
                Context danglingRight_ctx = this.cf.createContext(labelP, ContextType.DANGLING, ContextPosition.RIGHTMOST, this.leftmostContextsMapping, this.rightmostContextsMapping);
                if (ctx_s.containsProduction(labelP) || ctx_s.getContexts().contains(deepLeft_ctx) || ctx_s.getContexts().contains(deepRight_ctx) || ctx_s.getContexts().contains(danglingLeft_ctx) || ctx_s.getContexts().contains(danglingRight_ctx)) continue;
                ContextualProduction ctx_p = null;
                if (this.grammar.getProdContextualProdMapping().get(p) != null) {
                    ctx_p = this.grammar.getProdContextualProdMapping().get(p);
                }
                if (ctx_p != null) {
                    new_prod = ctx_p.mergeContext(ctx_s.getContexts(), contextual_symbols, processed_symbols, this);
                    this.grammar.getDerivedContextualProds().add(new_prod);
                    this.grammar.getSymbolProductionsMapping().put(ctx_s, new_prod);
                    continue;
                }
                if (ctx_s.getContexts().contains(deepLeft_ctx) || ctx_s.getContexts().contains(deepRight_ctx) || ctx_s.getContexts().contains(danglingRight_ctx) || ctx_s.getContexts().contains(danglingLeft_ctx)) continue;
                new_prod = this.cf.createContextualProduction((Production)p, ctx_s.getContexts(), contextual_symbols, processed_symbols, this.productionLabels.get(p), this);
                this.grammar.getDerivedContextualProds().add(new_prod);
                this.grammar.getSymbolProductionsMapping().put(ctx_s, new_prod);
            }
        }
    }

    private void processStateQueue() {
        while (!this.stateQueue.isEmpty()) {
            State state = this.stateQueue.poll();
            if (state.status() == StateStatus.PROCESSED) continue;
            this.processState(state);
        }
    }

    private void processState(State state) {
        state.closure();
        state.doShift();
        state.doReduces();
        state.calculateActionsForCharacter();
        state.setStatus(StateStatus.PROCESSED);
    }

    public IState startState() {
        State s0;
        if (this.totalStates == 0) {
            s0 = new State(this.initialProduction(), this);
            s0.closure();
            s0.doShift();
            s0.doReduces();
            s0.calculateActionsForCharacter();
            s0.setStatus(StateStatus.PROCESSED);
            this.setProcessedStates(this.getProcessedStates() + 1);
        } else if (this.stateLabels.get(0).status() != StateStatus.PROCESSED) {
            s0 = this.stateLabels.get(0);
            if (s0.status() == StateStatus.DIRTY) {
                s0.gotos().clear();
            }
            s0.closure();
            s0.doShift();
            s0.doReduces();
            s0.calculateActionsForCharacter();
            s0.setStatus(StateStatus.PROCESSED);
        } else {
            return this.stateLabels.get(0);
        }
        return s0;
    }

    @Override
    public IState getState(int index) {
        State s = this.stateLabels.get(index);
        if (s.status() != StateStatus.PROCESSED) {
            if (s.status() == StateStatus.DIRTY) {
                s.gotos().clear();
            }
            s.closure();
            s.doShift();
            s.doReduces();
            s.calculateActionsForCharacter();
            s.setStatus(StateStatus.PROCESSED);
            this.setProcessedStates(this.getProcessedStates() + 1);
        }
        return s;
    }

    @Override
    public int totalStates() {
        return this.totalStates;
    }

    public int getProcessedStates() {
        return this.processedStates;
    }

    public void setProcessedStates(int processedStates) {
        this.processedStates = processedStates;
    }

    public void incTotalStates() {
        ++this.totalStates;
    }

    public Map<Set<LRItem>, State> kernelMap() {
        return this.kernelStatesMapping;
    }

    public org.metaborg.sdf2table.grammar.IProduction initialProduction() {
        return this.initialProduction;
    }

    public NormGrammar normalizedGrammar() {
        return this.grammar;
    }

    public BiMap2<org.metaborg.sdf2table.grammar.IProduction, Integer> productionLabels() {
        return this.productionLabels;
    }

    public LabelFactory getProdLabelFactory() {
        return this.prodLabelFactory;
    }

    public Map<LRItem, Set<LRItem>> cachedItems() {
        return this.itemDerivedItemsCache;
    }

    public Queue<State> stateQueue() {
        return this.stateQueue;
    }

    public Map<Integer, State> stateLabels() {
        return this.stateLabels;
    }

    public int getVersionNumber() {
        return 7;
    }

    public int getInitialStateNumber() {
        return 0;
    }

    public Map<Set<Context>, Integer> getCtxUniqueInt() {
        return this.ctxUniqueInt;
    }

    public void setCtxUniqueInt(Map<Set<Context>, Integer> ctx_vals) {
        this.ctxUniqueInt = ctx_vals;
    }

    public SymbolStatesMapping getSymbolStatesMapping() {
        return this.symbolStatesMapping;
    }

    public void setSymbolStatesMapping(SymbolStatesMapping symbolStatesMapping) {
        this.symbolStatesMapping = symbolStatesMapping;
    }

    @Override
    public List<IProduction> productions() {
        return this.productions;
    }

    public Map<org.metaborg.sdf2table.grammar.IProduction, ParseTableProduction> productionsMapping() {
        return this.productionsMapping;
    }

    public Map<Integer, Integer> getLeftmostContextsMapping() {
        return this.leftmostContextsMapping;
    }

    public Map<Integer, Integer> getRightmostContextsMapping() {
        return this.rightmostContextsMapping;
    }

    @Override
    public IState getStartState() {
        return this.startState();
    }

    public ParseTableConfiguration getConfig() {
        return this.config;
    }

    public Set<org.metaborg.sdf2table.grammar.IProduction> getDanglingSuffix() {
        return this.danglingSuffix;
    }

    public Set<org.metaborg.sdf2table.grammar.IProduction> getDanglingPrefix() {
        return this.danglingPrefix;
    }

    public ContextualFactory getContextualFactory() {
        return this.cf;
    }

    @Override
    public boolean isLayoutSensitive() {
        return this.config.isLayoutSensitive();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParseTable that = (ParseTable)o;
        return this.processedStates == that.processedStates && this.totalStates == that.totalStates && Objects.equals(this.grammar, that.grammar) && Objects.equals(this.cf, that.cf) && Objects.equals(this.initialProduction, that.initialProduction) && Objects.equals(this.productionLabels, that.productionLabels) && Objects.equals(this.prodLabelFactory, that.prodLabelFactory) && Arrays.equals(this.stateQueue.toArray(), that.stateQueue.toArray()) && Objects.equals(this.stateLabels, that.stateLabels) && Objects.equals(this.danglingSuffix, that.danglingSuffix) && Objects.equals(this.danglingPrefix, that.danglingPrefix) && Objects.equals(this.symbolStatesMapping, that.symbolStatesMapping) && Objects.equals(this.kernelStatesMapping, that.kernelStatesMapping) && Objects.equals(this.itemDerivedItemsCache, that.itemDerivedItemsCache) && Objects.equals(this.productions, that.productions) && Objects.equals(this.productionsMapping, that.productionsMapping) && Objects.equals(this.config, that.config) && Objects.equals(this.ctxUniqueInt, that.ctxUniqueInt) && Objects.equals(this.leftmostContextsMapping, that.leftmostContextsMapping) && Objects.equals(this.rightmostContextsMapping, that.rightmostContextsMapping);
    }

    public int hashCode() {
        return Objects.hash(this.grammar, this.cf, this.processedStates, this.totalStates, this.initialProduction, this.productionLabels, this.prodLabelFactory, this.stateQueue, this.stateLabels, this.danglingSuffix, this.danglingPrefix, this.symbolStatesMapping, this.kernelStatesMapping, this.itemDerivedItemsCache, this.productions, this.productionsMapping, this.config, this.ctxUniqueInt, this.leftmostContextsMapping, this.rightmostContextsMapping);
    }
}

