/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.deepconflicts;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.metaborg.parsetable.symbols.ISymbol;
import org.metaborg.parsetable.symbols.SortCardinality;
import org.metaborg.parsetable.symbols.SyntaxContext;
import org.metaborg.sdf2table.deepconflicts.Context;
import org.metaborg.sdf2table.deepconflicts.ContextPosition;
import org.metaborg.sdf2table.deepconflicts.ContextType;
import org.metaborg.sdf2table.deepconflicts.ContextualFactory;
import org.metaborg.sdf2table.grammar.Symbol;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public final class ContextualSymbol
extends Symbol {
    private static final long serialVersionUID = -2886358954796970390L;
    private final Symbol s;
    private final Set<Context> contexts;
    private final ContextualFactory cf;
    private long deepContextBitmap = 0L;

    public ContextualSymbol(Symbol s, Set<Context> contexts, long deepContextBitmap, ContextualFactory cf) {
        this.s = s;
        this.contexts = contexts;
        this.deepContextBitmap = deepContextBitmap;
        this.cf = cf;
    }

    public ContextualSymbol(Symbol s, Set<Context> contexts, ContextualFactory cf) {
        this.s = s;
        this.contexts = contexts;
        this.cf = cf;
        for (Context context : contexts) {
            if (context.getType() != ContextType.DEEP && context.getType() != ContextType.DANGLING) continue;
            this.deepContextBitmap |= context.getContextBitmap();
        }
    }

    public ContextualSymbol(Symbol s, Context context, ContextualFactory cf) {
        this.s = s;
        this.contexts = new HashSet<Context>(Arrays.asList(context));
        this.cf = cf;
        if (context.getType() == ContextType.DEEP || context.getType() == ContextType.DANGLING) {
            this.deepContextBitmap |= context.getContextBitmap();
        }
    }

    @Override
    public String name() {
        String buf = "";
        if (!this.getContexts().isEmpty()) {
            boolean hasLeftContext = false;
            for (Context p : this.getContexts()) {
                if (p.getPosition() != ContextPosition.LEFTMOST) continue;
                hasLeftContext = true;
                break;
            }
            if (hasLeftContext) {
                int i = 0;
                buf = String.valueOf(buf) + "{";
                for (Context context : this.getContexts()) {
                    if (context.getPosition() == ContextPosition.RIGHTMOST) continue;
                    if (i != 0) {
                        buf = String.valueOf(buf) + ", ";
                    }
                    buf = String.valueOf(buf) + context;
                    ++i;
                }
                buf = String.valueOf(buf) + "}";
            }
        }
        buf = String.valueOf(buf) + this.getOrigSymbol().name();
        if (!this.getContexts().isEmpty()) {
            boolean hasRightContext = false;
            for (Context p : this.getContexts()) {
                if (p.getPosition() != ContextPosition.RIGHTMOST) continue;
                hasRightContext = true;
                break;
            }
            if (hasRightContext) {
                int i = 0;
                buf = String.valueOf(buf) + "{";
                for (Context context : this.getContexts()) {
                    if (context.getPosition() == ContextPosition.LEFTMOST) continue;
                    if (i != 0) {
                        buf = String.valueOf(buf) + ", ";
                    }
                    buf = String.valueOf(buf) + context;
                    ++i;
                }
                buf = String.valueOf(buf) + "}";
            }
        }
        return buf;
    }

    @Override
    public ICharacterClass followRestriction() {
        return this.getOrigSymbol().followRestriction();
    }

    @Override
    public List<ICharacterClass[]> followRestrictionLookahead() {
        return this.getOrigSymbol().followRestrictionLookahead();
    }

    public void setDeepContextBitmap(long deepContextBitmap) {
        this.deepContextBitmap = deepContextBitmap;
    }

    public Set<Context> getContexts() {
        return this.contexts;
    }

    public long deepContexts() {
        return this.deepContextBitmap;
    }

    public Symbol getOrigSymbol() {
        return this.s;
    }

    public ContextualSymbol addContext(Context context) {
        HashSet<Context> newContexts = new HashSet<Context>();
        newContexts.addAll(this.getContexts());
        newContexts.add(context);
        if (context.getType() == ContextType.DEEP || context.getType() == ContextType.DANGLING) {
            return this.cf.createContextualSymbol(this.getOrigSymbol(), newContexts, this.deepContextBitmap | context.getContextBitmap(), this.cf);
        }
        return this.cf.createContextualSymbol(this.getOrigSymbol(), newContexts, this.deepContextBitmap, this.cf);
    }

    public ContextualSymbol addContexts(Set<Context> contexts) {
        HashSet<Context> newContexts = new HashSet<Context>();
        newContexts.addAll(this.getContexts());
        newContexts.addAll(contexts);
        long updatedDeepContextBitmap = this.deepContextBitmap;
        for (Context context : contexts) {
            if (context.getType() != ContextType.DEEP && context.getType() != ContextType.DANGLING) continue;
            updatedDeepContextBitmap |= context.getContextBitmap();
        }
        return this.cf.createContextualSymbol(this.getOrigSymbol(), newContexts, updatedDeepContextBitmap, this.cf);
    }

    @Override
    public IStrategoTerm toAterm(ITermFactory tf) {
        return this.getOrigSymbol().toAterm(tf);
    }

    @Override
    public IStrategoTerm toSDF3Aterm(ITermFactory tf, Map<Set<Context>, Integer> ctx_vals, Integer ctx_val) {
        return this.getOrigSymbol().toSDF3Aterm(tf, ctx_vals, ctx_vals.get(this.getContexts()));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contexts == null ? 0 : this.contexts.hashCode());
        result = 31 * result + (this.s == null ? 0 : this.s.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContextualSymbol other = (ContextualSymbol)obj;
        if (this.contexts == null ? other.contexts != null : !this.contexts.equals(other.contexts)) {
            return false;
        }
        return !(this.s == null ? other.s != null : !this.s.equals(other.s));
    }

    @Override
    public ISymbol toParseTableSymbol(SyntaxContext syntaxContext, SortCardinality cardinality) {
        return this.s.toParseTableSymbol(syntaxContext, cardinality);
    }

    public boolean containsProduction(int label) {
        for (Context c : this.contexts) {
            if (c.getContext() != label) continue;
            return true;
        }
        return false;
    }
}

