/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.runtime.task.specific;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.metaborg.runtime.task.ITask;
import org.metaborg.runtime.task.ITaskFactory;
import org.metaborg.runtime.task.ListTaskResults;
import org.metaborg.runtime.task.Task;
import org.metaborg.runtime.task.TaskStatus;
import org.metaborg.runtime.task.TaskStorageType;
import org.metaborg.runtime.task.TaskType;
import org.metaborg.runtime.task.engine.ITaskEngine;
import org.metaborg.runtime.task.evaluation.ITaskEvaluationFrontend;
import org.metaborg.runtime.task.evaluation.ITaskEvaluationQueue;
import org.metaborg.runtime.task.evaluation.ITaskEvaluator;
import org.metaborg.runtime.task.evaluation.ITaskQueuer;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;

public class ChoiceTask
implements ITaskFactory,
ITaskQueuer,
ITaskEvaluator {
    private final ITermFactory factory;
    private final Map<IStrategoTerm, Iterator<IStrategoTerm>> iterators = new HashMap<IStrategoTerm, Iterator<IStrategoTerm>>();
    private final Map<IStrategoTerm, IStrategoTerm> subtaskIDs = new HashMap<IStrategoTerm, IStrategoTerm>();

    public ChoiceTask(ITermFactory factory) {
        this.factory = factory;
    }

    @Override
    public IStrategoList adjustDependencies(IStrategoList dependencies) {
        return this.factory.makeList();
    }

    @Override
    public ITask create(IStrategoAppl instruction, IStrategoList dependencies, TaskType type, TaskStorageType storageType, TaskStorageType actualStorageType, boolean shortCircuit) {
        return new Task(instruction, dependencies, type, TaskStorageType.List, shortCircuit, new ListTaskResults());
    }

    @Override
    public ITask clone(ITask task) {
        return new Task((Task)task);
    }

    @Override
    public void queue(ITaskEngine taskEngine, ITaskEvaluationQueue evaluationQueue, Set<IStrategoTerm> scheduled) {
        for (IStrategoTerm taskID : scheduled) {
            ITask task = taskEngine.getTask(taskID);
            if (!ChoiceTask.isChoice(task.instruction())) continue;
            evaluationQueue.queue(taskID);
        }
    }

    @Override
    public void evaluate(IStrategoTerm taskID, ITask task, ITaskEngine taskEngine, ITaskEvaluationQueue evaluationQueue, IContext context, Strategy collect, Strategy insert, Strategy perform, boolean cycle) {
        Iterator<IStrategoTerm> iter;
        IStrategoTerm subtaskID = this.subtaskIDs.get(taskID);
        if (subtaskID != null) {
            evaluationQueue.removeRuntimeDependency(taskID, subtaskID);
            ITask subtask = taskEngine.getTask(subtaskID);
            if (!subtask.failed() && !subtask.results().empty()) {
                this.choiceSucceeds(task, taskID, subtask, taskEngine, evaluationQueue);
                return;
            }
        }
        if ((iter = this.iterators.get(taskID)) == null) {
            iter = task.instruction().getSubterm(0).iterator();
            this.iterators.put(taskID, iter);
        }
        if (!iter.hasNext()) {
            this.choiceFails(task, taskID, taskEngine, evaluationQueue);
            return;
        }
        IStrategoTerm subtaskResult = iter.next();
        IStrategoTerm subtaskID2 = this.getTaskID(subtaskResult);
        if (subtaskID2 == null) {
            evaluationQueue.queue(taskID);
            return;
        }
        this.subtaskIDs.put(taskID, subtaskID2);
        ITask subtask = taskEngine.getTask(subtaskID2);
        taskEngine.addDependency(taskID, subtaskID2);
        if (subtask.solved()) {
            if (subtask.failed()) {
                evaluationQueue.queue(taskID);
                return;
            }
            this.choiceSucceeds(task, taskID, subtask, taskEngine, evaluationQueue);
            return;
        }
        this.queueTransitive(subtaskID2, taskEngine, evaluationQueue);
        evaluationQueue.addRuntimeDependency(taskID, subtaskID2);
    }

    @Override
    public void reset() {
        this.iterators.clear();
        this.subtaskIDs.clear();
    }

    private IStrategoTerm getTaskID(IStrategoTerm resultTerm) {
        if (TermUtils.isAppl(resultTerm) && TermUtils.isAppl((IStrategoAppl)resultTerm, "Result", 1)) {
            return resultTerm.getSubterm(0);
        }
        return null;
    }

    private void choiceFails(ITask task, IStrategoTerm taskID, ITaskEngine taskEngine, ITaskEvaluationQueue evaluationQueue) {
        task.setFailed();
        evaluationQueue.solved(taskID);
        this.cleanupChoice(taskID, taskEngine, evaluationQueue);
    }

    private void choiceSucceeds(ITask task, IStrategoTerm taskID, ITask subtask, ITaskEngine taskEngine, ITaskEvaluationQueue evaluationQueue) {
        task.results().set(subtask.results());
        task.setStatus(TaskStatus.Success);
        evaluationQueue.solved(taskID);
        this.cleanupChoice(taskID, taskEngine, evaluationQueue);
    }

    private void cleanupChoice(IStrategoTerm taskID, ITaskEngine taskEngine, ITaskEvaluationQueue evaluationQueue) {
        Iterator<IStrategoTerm> iter = this.iterators.get(taskID);
        if (iter != null) {
            while (iter.hasNext()) {
                IStrategoTerm subtaskResult = iter.next();
                IStrategoTerm subtaskID = this.getTaskID(subtaskResult);
                if (subtaskID == null) continue;
                evaluationQueue.skipped(subtaskID);
                for (IStrategoTerm dependencyTaskID : this.transitiveDependenciesNoChoice(subtaskID, taskEngine)) {
                    evaluationQueue.skipped(dependencyTaskID);
                }
            }
        }
        this.iterators.remove(taskID);
        this.subtaskIDs.remove(taskID);
    }

    private void queueTransitive(IStrategoTerm taskID, ITaskEngine taskEngine, ITaskEvaluationQueue evaluationQueue) {
        evaluationQueue.queueOrDefer(taskID);
        for (IStrategoTerm dependencyTaskID : this.transitiveDependenciesNoChoice(taskID, taskEngine)) {
            evaluationQueue.queueOrDefer(dependencyTaskID);
        }
    }

    private Set<IStrategoTerm> transitiveDependenciesNoChoice(IStrategoTerm taskID, ITaskEngine taskEngine) {
        IStrategoTerm queueTaskID;
        HashSet<IStrategoTerm> seen = new HashSet<IStrategoTerm>();
        ArrayDeque<IStrategoTerm> queue = new ArrayDeque<IStrategoTerm>();
        queue.add(taskID);
        seen.add(taskID);
        while ((queueTaskID = (IStrategoTerm)queue.poll()) != null) {
            ITask task = taskEngine.getTask(queueTaskID);
            if (ChoiceTask.isChoice(task.instruction())) continue;
            for (IStrategoTerm dependency : taskEngine.getDependencies(queueTaskID, false)) {
                if (!seen.add(dependency)) continue;
                queue.add(dependency);
            }
        }
        seen.remove(taskID);
        return seen;
    }

    private static boolean isChoice(IStrategoTerm instruction) {
        return TermUtils.isAppl(instruction) && TermUtils.isAppl((IStrategoAppl)instruction, "Choice", 1);
    }

    public static ChoiceTask register(ITaskEngine taskEngine, ITaskEvaluationFrontend evaluationFrontend, ITermFactory factory) {
        ChoiceTask evaluator = new ChoiceTask(factory);
        IStrategoConstructor constructor = factory.makeConstructor("Choice", 1);
        taskEngine.registerTaskFactory(constructor, evaluator);
        evaluationFrontend.registerTaskEvaluator(constructor, evaluator);
        return evaluator;
    }
}

