/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.runtime.task.digest;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.metaborg.runtime.task.digest.ITermDigester;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.io.binary.SAFWriter;

public class SHA1TermDigester
implements ITermDigester {
    private final MessageDigest digest;
    private final ByteBuffer intBuffer = ByteBuffer.allocate(4);
    private final ByteBuffer doubleBuffer = ByteBuffer.allocate(8);

    public SHA1TermDigester() throws NoSuchAlgorithmException {
        this.digest = MessageDigest.getInstance("SHA-1");
    }

    @Override
    public IStrategoTerm digest(ITermFactory factory, IStrategoTerm ... terms) {
        this.digest.reset();
        IStrategoTerm[] iStrategoTermArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            IStrategoTerm term = iStrategoTermArray[n2];
            this.digestTopSerializer(term);
            ++n2;
        }
        byte[] data = this.digest.digest();
        return factory.makeTuple(factory.makeInt(this.toInt(data, 0)), factory.makeInt(this.toInt(data, 4)));
    }

    @Override
    public IStrategoTerm state(ITermFactory factory) {
        return factory.makeInt(0);
    }

    @Override
    public void setState(IStrategoTerm state) {
    }

    @Override
    public void reset() {
    }

    private void digestTopSerializer(IStrategoTerm term) {
        this.digest.update(SAFWriter.writeTermToSAFString(term));
    }

    private void digestTop(IStrategoTerm term) {
        this.digestTerm(term);
        this.digestTerm(term.getAnnotations());
    }

    private void digestTerm(IStrategoTerm term) {
        switch (term.getTermType()) {
            case 1: {
                IStrategoAppl t = (IStrategoAppl)term;
                this.digest.update(t.getConstructor().getName().getBytes());
                this.intBuffer.position(0);
                this.digest.update(this.intBuffer.putInt(t.getConstructor().getArity()).array());
                for (IStrategoTerm subterm : t) {
                    this.digestTop(subterm);
                }
                break;
            }
            case 7: {
                IStrategoTuple t = (IStrategoTuple)term;
                for (IStrategoTerm subterm : t) {
                    this.digestTop(subterm);
                }
                break;
            }
            case 2: {
                IStrategoList t = (IStrategoList)term;
                for (IStrategoTerm subterm : t) {
                    this.digestTop(subterm);
                }
                break;
            }
            case 3: {
                IStrategoInt t = (IStrategoInt)term;
                this.intBuffer.position(0);
                this.digest.update(this.intBuffer.putInt(t.intValue()).array());
                break;
            }
            case 4: {
                IStrategoReal t = (IStrategoReal)term;
                this.doubleBuffer.position(0);
                this.digest.update(this.doubleBuffer.putDouble(t.realValue()).array());
                break;
            }
            case 5: {
                IStrategoString t = (IStrategoString)term;
                this.digest.update(t.stringValue().getBytes());
            }
        }
    }

    private int toInt(byte[] digest, int offset) {
        return (digest[offset + 0] & 0xFF) << 24 | (digest[offset + 1] & 0xFF) << 16 | (digest[offset + 2] & 0xFF) << 8 | digest[offset + 3] & 0xFF;
    }
}

