/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.runtime.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.metaborg.runtime.task.ITask;
import org.metaborg.runtime.task.engine.ITaskEngine;
import org.metaborg.runtime.task.util.InvokeStrategy;
import org.metaborg.runtime.task.util.TermTools;
import org.metaborg.util.Ref;
import org.metaborg.util.collection.ListMultimap;
import org.metaborg.util.iterators.Iterables2;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.library.ssl.StrategoHashMap;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public final class TaskInsertion {
    public static PermsOrDeps taskCombinations(ITermFactory factory, ITaskEngine taskEngine, IContext context, Strategy collect, Strategy insert, IStrategoTerm taskID, ITask task, boolean singleLevel) {
        IStrategoAppl instruction = task.instruction();
        Iterable<IStrategoTerm> actualDependencies = TaskInsertion.getResultIDs(context, collect, instruction);
        switch (task.type()) {
            case Regular: {
                Iterable<IStrategoTerm> allDependencies = taskEngine.getDependencies(taskID, false);
                if (TaskInsertion.dependencyFailure(taskEngine, allDependencies)) {
                    return null;
                }
                if (Iterables2.isEmpty(actualDependencies)) {
                    return new PermsOrDeps(Iterables2.singleton(instruction), false);
                }
                return TaskInsertion.insertResultCombinations(taskEngine, context, collect, insert, instruction, actualDependencies, Iterables2.singleton(taskID), singleLevel);
            }
            case Combinator: {
                return new PermsOrDeps(Iterables2.singleton(TaskInsertion.insertResultLists(factory, taskEngine, context, insert, instruction, actualDependencies)), false);
            }
            case Raw: {
                return new PermsOrDeps(Iterables2.singleton(instruction), false);
            }
        }
        throw new RuntimeException("Task of type " + (Object)((Object)task.type()) + " not handled.");
    }

    public static PermsOrDeps insertResultCombinations(ITaskEngine taskEngine, IContext context, Strategy collect, Strategy insert, IStrategoTerm term, Iterable<IStrategoTerm> dependencies, Iterable<IStrategoTerm> initialSeen, boolean singleLevel) {
        HashSet<IStrategoTerm> seen = Iterables2.toHashSet(initialSeen);
        ResultMapOrDeps result = TaskInsertion.createResultMapping(taskEngine, context, collect, insert, dependencies, seen, singleLevel);
        if (result == null) {
            return null;
        }
        if (result.hasDeps()) {
            return new PermsOrDeps(result.deps, true);
        }
        return new PermsOrDeps(TaskInsertion.insertCarthesianProduct(context, insert, term, result.resultMap), false);
    }

    private static ResultMapOrDeps createResultMapping(ITaskEngine taskEngine, IContext context, Strategy collect, Strategy insert, Iterable<IStrategoTerm> resultIDs, Set<IStrategoTerm> seen, boolean singleLevel) {
        ListMultimap<IStrategoTerm, IStrategoTerm> resultsMap = new ListMultimap<IStrategoTerm, IStrategoTerm>();
        ArrayList<IStrategoTerm> dynamicDependencies = new ArrayList<IStrategoTerm>();
        for (IStrategoTerm resultID : resultIDs) {
            if (seen.contains(resultID)) {
                resultsMap.put(resultID, TaskInsertion.createCycleTerm(context.getFactory(), resultID));
                continue;
            }
            ResultsOrDeps results = TaskInsertion.getResultsOf(taskEngine, context, collect, insert, resultID, new HashSet<IStrategoTerm>(seen), singleLevel);
            if (results == null) {
                return null;
            }
            if (results.hasDeps()) {
                Iterables2.addAll(dynamicDependencies, results.deps);
                continue;
            }
            results.results.forEach(r -> {
                boolean bl = resultsMap.put(resultID, (IStrategoTerm)r);
            });
        }
        if (dynamicDependencies.isEmpty()) {
            return ResultMapOrDeps.resultMap(resultsMap);
        }
        return ResultMapOrDeps.deps(dynamicDependencies);
    }

    private static ResultsOrDeps getResultsOf(ITaskEngine taskEngine, IContext context, Strategy collect, Strategy insert, IStrategoTerm taskID, Set<IStrategoTerm> seen, boolean singleLevel) {
        seen.add(taskID);
        ITask task = taskEngine.getTask(taskID);
        if (!task.solved()) {
            return ResultsOrDeps.deps(Iterables2.singleton(taskID));
        }
        if (task.failed() || task.results().empty()) {
            return null;
        }
        ArrayList<IStrategoTerm> results = new ArrayList<IStrategoTerm>();
        ArrayList<IStrategoTerm> dynamicDependencies = new ArrayList<IStrategoTerm>();
        for (IStrategoTerm result : task.results()) {
            Iterable<IStrategoTerm> nestedResultIDs = TaskInsertion.getResultIDs(context, collect, result);
            if (singleLevel || Iterables2.isEmpty(nestedResultIDs)) {
                results.add(result);
                continue;
            }
            ResultMapOrDeps resultMapping = TaskInsertion.createResultMapping(taskEngine, context, collect, insert, nestedResultIDs, seen, singleLevel);
            if (resultMapping == null) {
                return null;
            }
            if (resultMapping.hasDeps()) {
                Iterables2.addAll(dynamicDependencies, resultMapping.deps);
                continue;
            }
            Collection<IStrategoTerm> insertedResults = TaskInsertion.insertCarthesianProduct(context, insert, result, resultMapping.resultMap);
            results.addAll(insertedResults);
        }
        if (dynamicDependencies.isEmpty()) {
            return ResultsOrDeps.results(results);
        }
        return ResultsOrDeps.deps(dynamicDependencies);
    }

    private static Collection<IStrategoTerm> insertCarthesianProduct(IContext context, Strategy insert, IStrategoTerm term, ListMultimap<IStrategoTerm, IStrategoTerm> resultMapping) {
        Collection<StrategoHashMap> resultCombinations = TaskInsertion.cartesianProduct(resultMapping);
        ArrayList<IStrategoTerm> instructions = new ArrayList<IStrategoTerm>();
        for (StrategoHashMap mapping : resultCombinations) {
            instructions.add(TaskInsertion.insertResults(context, insert, term, mapping));
        }
        return instructions;
    }

    private static IStrategoTerm insertResultLists(ITermFactory factory, ITaskEngine taskEngine, IContext context, Strategy insert, IStrategoTerm term, Iterable<IStrategoTerm> resultIDs) {
        StrategoHashMap mapping = new StrategoHashMap();
        for (IStrategoTerm resultID : resultIDs) {
            ITask task = taskEngine.getTask(resultID);
            mapping.put(resultID, TermTools.makeList(factory, task.results()));
        }
        return TaskInsertion.insertResults(context, insert, term, mapping);
    }

    public static Collection<StrategoHashMap> cartesianProduct(ListMultimap<IStrategoTerm, IStrategoTerm> results) {
        Ref result = new Ref(new ArrayList());
        if (results.size() > 0) {
            ((Collection)result.get()).add(new StrategoHashMap());
        }
        results.forEach((k, v) -> {
            ArrayList<StrategoHashMap> newResults = new ArrayList<StrategoHashMap>();
            for (StrategoHashMap map : (Collection)result.get()) {
                for (IStrategoTerm val : v) {
                    StrategoHashMap mapping = new StrategoHashMap();
                    mapping.putAll(map);
                    mapping.put(k, val);
                    newResults.add(mapping);
                }
            }
            result.set(newResults);
        });
        return result.get();
    }

    private static boolean dependencyFailure(ITaskEngine taskEngine, Iterable<IStrategoTerm> taskIDs) {
        for (IStrategoTerm taskID : taskIDs) {
            ITask task = taskEngine.getTask(taskID);
            if (!task.failed() && !task.results().empty()) continue;
            return true;
        }
        return false;
    }

    private static Iterable<IStrategoTerm> getResultIDs(IContext context, Strategy collect, IStrategoTerm term) {
        return InvokeStrategy.invoke(context, collect, term);
    }

    private static IStrategoTerm insertResults(IContext context, Strategy insertResults, IStrategoTerm instruction, StrategoHashMap resultCombinations) {
        return InvokeStrategy.invoke(context, insertResults, instruction, TaskInsertion.createHashtableTerm(context.getFactory(), resultCombinations));
    }

    private static IStrategoAppl createHashtableTerm(ITermFactory factory, StrategoHashMap hashMap) {
        return factory.makeAppl(factory.makeConstructor("Hashtable", 1), hashMap);
    }

    private static IStrategoAppl createCycleTerm(ITermFactory factory, IStrategoTerm taskID) {
        return factory.makeAppl(factory.makeConstructor("Result", 1), taskID);
    }

    public static class PermsOrDeps {
        public final Iterable<IStrategoTerm> permsOrDeps;
        public final boolean hasDeps;

        public PermsOrDeps(Iterable<IStrategoTerm> permsOrDeps, boolean hasDeps) {
            this.permsOrDeps = permsOrDeps;
            this.hasDeps = hasDeps;
        }
    }

    private static class ResultMapOrDeps {
        public final ListMultimap<IStrategoTerm, IStrategoTerm> resultMap;
        public final Iterable<IStrategoTerm> deps;

        public ResultMapOrDeps(ListMultimap<IStrategoTerm, IStrategoTerm> resultMap) {
            this.resultMap = resultMap;
            this.deps = null;
        }

        public ResultMapOrDeps(Iterable<IStrategoTerm> deps) {
            this.resultMap = null;
            this.deps = deps;
        }

        public static ResultMapOrDeps resultMap(ListMultimap<IStrategoTerm, IStrategoTerm> resultMap) {
            return new ResultMapOrDeps(resultMap);
        }

        public static ResultMapOrDeps deps(Iterable<IStrategoTerm> deps) {
            return new ResultMapOrDeps(deps);
        }

        public boolean hasDeps() {
            return this.deps != null;
        }
    }

    private static class ResultsOrDeps {
        public final Collection<IStrategoTerm> results;
        public final Iterable<IStrategoTerm> deps;

        public ResultsOrDeps(Collection<IStrategoTerm> results) {
            this.results = results;
            this.deps = null;
        }

        public ResultsOrDeps(Iterable<IStrategoTerm> deps) {
            this.results = null;
            this.deps = deps;
        }

        public static ResultsOrDeps results(Collection<IStrategoTerm> results) {
            return new ResultsOrDeps(results);
        }

        public static ResultsOrDeps deps(Iterable<IStrategoTerm> deps) {
            return new ResultsOrDeps(deps);
        }

        public boolean hasDeps() {
            return this.deps != null;
        }
    }
}

