/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.testing;

import jakarta.annotation.Nullable;
import java.io.PrintStream;
import org.metaborg.core.testing.TestReporterServiceBase;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public final class LoggingTestReporterService
extends TestReporterServiceBase {
    private static final ILogger logger = LoggerUtils.logger(LoggingTestReporterService.class);
    private int testPassedCounter = 0;
    private int testFailedCounter = 0;
    private int testIgnoredCounter = 0;
    private int totalTestPassedCounter = 0;
    private int totalTestFailedCounter = 0;
    private int totalTestIgnoredCounter = 0;

    @Override
    protected void onSessionStarted() {
        logger.info("running tests");
        this.totalTestPassedCounter = 0;
        this.totalTestFailedCounter = 0;
        this.totalTestIgnoredCounter = 0;
    }

    @Override
    protected void onSessionFinished() {
        TestResult result = this.totalTestFailedCounter > 0 ? TestResult.FAILED : TestResult.OK;
        logger.info("test result: {}. {} passed; {} failed; {} ignored", new Object[]{result, this.totalTestPassedCounter, this.totalTestFailedCounter, this.totalTestIgnoredCounter});
    }

    @Override
    protected void onTestSuiteStarted(String name) {
        logger.info("running test suite {}", name.trim());
        this.testPassedCounter = 0;
        this.testFailedCounter = 0;
        this.testIgnoredCounter = 0;
    }

    @Override
    protected void onTestSuiteFinished(String name) {
        TestResult result = this.testFailedCounter > 0 ? TestResult.FAILED : TestResult.OK;
        logger.info("test suite result: {}. {} passed; {} failed; {} ignored", new Object[]{result, this.testPassedCounter, this.testFailedCounter, this.testIgnoredCounter});
    }

    @Override
    protected void onTestStarted(String name) {
        logger.debug("test {} ...", name.trim());
    }

    @Override
    protected void onTestFailed(String name, @Nullable String reason, @Nullable String details) {
        ++this.testFailedCounter;
        ++this.totalTestFailedCounter;
        logger.info("test {} ... {}", name.trim(), TestResult.FAILED.toString());
    }

    @Override
    protected void onTestPassed(String name) {
        ++this.testPassedCounter;
        ++this.totalTestPassedCounter;
        logger.info("test {} ... {}", name.trim(), TestResult.OK.toString());
    }

    @Override
    protected void onTestIgnored(String name, @Nullable String reason) {
        ++this.testIgnoredCounter;
        ++this.totalTestIgnoredCounter;
        logger.info("test {} ... {}", name.trim(), TestResult.IGNORED.toString());
    }

    @Override
    public ILogger getLogger() {
        return logger;
    }

    @Override
    public PrintStream getOut() {
        return System.out;
    }

    @Override
    public PrintStream getErr() {
        return System.err;
    }

    private static enum TestResult {
        OK,
        FAILED,
        IGNORED;


        public String toString() {
            switch (this) {
                case OK: {
                    return "ok";
                }
                case FAILED: {
                    return "FAILED";
                }
                case IGNORED: {
                    return "ignored";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

