/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.source;

import jakarta.annotation.Nullable;
import org.metaborg.core.source.ISourceRegion;
import org.metaborg.util.Strings;

public class AffectedSourceHelper {
    @Nullable
    public static String affectedSourceText(ISourceRegion region, String sourceText, String indentation) {
        int startOffset = region.startOffset();
        int endOffset = region.endOffset();
        int startRow = -1;
        int endRow = -1;
        int startExtend = Integer.MAX_VALUE;
        int endExtend = 0;
        int pos = 0;
        String[] lines = sourceText.split("\\r?\\n");
        int i = 0;
        while (i < lines.length) {
            int endDist;
            String line = lines[i];
            int length = line.length();
            int startDist = startOffset - pos;
            if (startDist >= 0 && startDist <= length) {
                startExtend = Math.min(startExtend, startDist);
            }
            if ((endDist = endOffset - pos) >= 0 && endDist <= length) {
                endExtend = Math.max(endExtend, endDist + 1);
            }
            if (startRow == -1 && (pos += length + 1) >= startOffset) {
                startRow = i;
            }
            if (startRow != -1) {
                if (pos >= endOffset) {
                    endRow = i;
                    break;
                }
                startExtend = 0;
                endExtend = Math.max(endExtend, length);
            }
            ++i;
        }
        if (endRow == -1 || startExtend == Integer.MAX_VALUE) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i2 = startRow;
        while (i2 <= endRow) {
            builder.append(indentation);
            builder.append(lines[i2].replace('\t', ' '));
            builder.append('\n');
            ++i2;
        }
        if (startExtend <= endExtend) {
            builder.append(indentation);
            builder.append(Strings.repeat(" ", startExtend));
            builder.append(Strings.repeat("^", endExtend - startExtend));
            builder.append('\n');
        }
        return builder.toString();
    }
}

