/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.resource;

import com.google.inject.Provider;
import java.io.File;
import java.util.Random;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.cache.DefaultFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileReplicator;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.TemporaryFileStore;
import org.apache.commons.vfs2.provider.bzip2.Bzip2FileProvider;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.provider.ftps.FtpsFileProvider;
import org.apache.commons.vfs2.provider.gzip.GzipFileProvider;
import org.apache.commons.vfs2.provider.http.HttpFileProvider;
import org.apache.commons.vfs2.provider.https.HttpsFileProvider;
import org.apache.commons.vfs2.provider.jar.JarFileProvider;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.ram.RamFileProvider;
import org.apache.commons.vfs2.provider.res.ResourceFileProvider;
import org.apache.commons.vfs2.provider.tar.TarFileProvider;
import org.apache.commons.vfs2.provider.tar.Tbz2FileProvider;
import org.apache.commons.vfs2.provider.tar.TgzFileProvider;
import org.apache.commons.vfs2.provider.temp.TemporaryFileProvider;
import org.apache.commons.vfs2.provider.zip.ZipFileProvider;

public class DefaultFileSystemManagerProvider
implements Provider<FileSystemManager> {
    public FileSystemManager get() {
        try {
            DefaultFileSystemManager manager = new DefaultFileSystemManager();
            manager.setFilesCache((FilesCache)new DefaultFilesCache());
            manager.setCacheStrategy(CacheStrategy.ON_RESOLVE);
            String baseTmpDir = System.getProperty("java.io.tmpdir");
            File tempDir = new File(baseTmpDir, "vfs_cache" + new Random().nextLong()).getAbsoluteFile();
            DefaultFileReplicator replicator = new DefaultFileReplicator(tempDir);
            manager.setTemporaryFileStore((TemporaryFileStore)replicator);
            manager.setReplicator((FileReplicator)replicator);
            this.addDefaultProvider(manager);
            this.addProviders(manager);
            this.setBaseFile(manager);
            manager.init();
            return manager;
        }
        catch (FileSystemException e) {
            throw new RuntimeException("Cannot initialize resource service: " + e.getMessage(), e);
        }
    }

    protected void addDefaultProvider(DefaultFileSystemManager manager) throws FileSystemException {
        DefaultLocalFileProvider provider = new DefaultLocalFileProvider();
        manager.addProvider("file", (FileProvider)provider);
        manager.setDefaultProvider((FileProvider)provider);
    }

    protected void setBaseFile(DefaultFileSystemManager manager) throws FileSystemException {
        manager.setBaseFile(manager.resolveFile(System.getProperty("user.dir")));
    }

    protected void addProviders(DefaultFileSystemManager manager) throws FileSystemException {
        manager.addProvider("tmp", (FileProvider)new TemporaryFileProvider());
        manager.addProvider("res", (FileProvider)new ResourceFileProvider());
        manager.addProvider("ram", (FileProvider)new RamFileProvider());
        manager.addProvider("zip", (FileProvider)new ZipFileProvider());
        manager.addProvider("jar", (FileProvider)new JarFileProvider());
        manager.addProvider("tar", (FileProvider)new TarFileProvider());
        manager.addProvider("tgz", (FileProvider)new TgzFileProvider());
        manager.addProvider("tbz2", (FileProvider)new Tbz2FileProvider());
        manager.addProvider("gz", (FileProvider)new GzipFileProvider());
        manager.addProvider("bz2", (FileProvider)new Bzip2FileProvider());
        manager.addProvider("http", (FileProvider)new HttpFileProvider());
        manager.addProvider("https", (FileProvider)new HttpsFileProvider());
        manager.addProvider("ftp", (FileProvider)new FtpFileProvider());
        manager.addProvider("ftps", (FileProvider)new FtpsFileProvider());
    }
}

