/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.language;

import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.build.dependency.IDependencyService;
import org.metaborg.core.language.ILanguage;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageIdentifierService;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.ILanguageService;
import org.metaborg.core.language.IdentificationFacet;
import org.metaborg.core.language.IdentifiedResource;
import org.metaborg.core.language.LanguageUtils;
import org.metaborg.core.language.dialect.IDialectIdentifier;
import org.metaborg.core.language.dialect.IdentifiedDialect;
import org.metaborg.core.project.IProject;
import org.metaborg.core.project.IProjectService;
import org.metaborg.util.Strings;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class LanguageIdentifierService
implements ILanguageIdentifierService {
    private static final ILogger logger = LoggerUtils.logger(LanguageIdentifierService.class);
    private final ILanguageService languageService;
    private final IDialectIdentifier dialectIdentifier;
    private final IProjectService projectService;
    private final IDependencyService dependencyService;

    @Inject
    public LanguageIdentifierService(ILanguageService languageService, IDialectIdentifier dialectIdentifier, IProjectService projectService, IDependencyService dependencyService) {
        this.languageService = languageService;
        this.dialectIdentifier = dialectIdentifier;
        this.projectService = projectService;
        this.dependencyService = dependencyService;
    }

    @Override
    public boolean identify(FileObject resource, ILanguageImpl language) {
        Iterable<IdentificationFacet> facets = language.facets(IdentificationFacet.class);
        if (Iterables2.isEmpty(facets)) {
            logger.trace("Cannot identify if {} is of {}, language does not have an identification facet", resource, language);
            return false;
        }
        boolean identified = false;
        for (IdentificationFacet facet : facets) {
            boolean bl = identified = identified || facet.identify(resource);
        }
        return identified;
    }

    @Override
    @Nullable
    public ILanguageImpl identify(FileObject resource) {
        return this.identify(resource, this.projectService.get(resource));
    }

    @Override
    @Nullable
    public ILanguageImpl identify(FileObject resource, @Nullable IProject project) {
        if (project != null) {
            try {
                Collection<ILanguageComponent> dependencies = this.dependencyService.compileDeps(project);
                Set<ILanguageImpl> impls = LanguageUtils.toImpls(dependencies);
                ILanguageImpl impl = this.identify(resource, impls);
                if (impl == null) {
                    impl = this.identify(resource, LanguageUtils.allActiveImpls(this.languageService));
                }
                return impl;
            }
            catch (MetaborgException e) {
                return this.identify(resource, LanguageUtils.allActiveImpls(this.languageService));
            }
        }
        return this.identify(resource, LanguageUtils.allActiveImpls(this.languageService));
    }

    @Override
    @Nullable
    public IdentifiedResource identifyToResource(FileObject resource) {
        return this.identifyToResource(resource, this.projectService.get(resource));
    }

    @Override
    @Nullable
    public IdentifiedResource identifyToResource(FileObject resource, @Nullable IProject project) {
        if (project != null) {
            try {
                Collection<ILanguageComponent> dependencies = this.dependencyService.compileDeps(project);
                Set<ILanguageImpl> impls = LanguageUtils.toImpls(dependencies);
                IdentifiedResource identified = this.identifyToResource(resource, impls);
                if (identified == null) {
                    identified = this.identifyToResource(resource, LanguageUtils.allActiveImpls(this.languageService));
                }
                return identified;
            }
            catch (MetaborgException e) {
                return this.identifyToResource(resource, LanguageUtils.allActiveImpls(this.languageService));
            }
        }
        return this.identifyToResource(resource, LanguageUtils.allActiveImpls(this.languageService));
    }

    @Override
    @Nullable
    public ILanguageImpl identify(FileObject resource, Iterable<? extends ILanguageImpl> languages) {
        IdentifiedResource identified = this.identifyToResource(resource, languages);
        if (identified == null) {
            return null;
        }
        return identified.dialectOrLanguage();
    }

    @Override
    @Nullable
    public IdentifiedResource identifyToResource(FileObject resource, Iterable<? extends ILanguageImpl> impls) {
        try {
            if (resource.getType() == FileType.FOLDER) {
                return null;
            }
        }
        catch (FileSystemException e) {
            logger.error("Cannot identify {}, cannot determine its file type", e, resource);
            return null;
        }
        try {
            IdentifiedDialect dialect = this.dialectIdentifier.identify(resource);
            if (dialect != null) {
                return new IdentifiedResource(resource, dialect);
            }
        }
        catch (MetaborgException e) {
            logger.error("Cannot identify dialect of {}", e, resource);
            return null;
        }
        catch (MetaborgRuntimeException e) {
            // empty catch block
        }
        LinkedHashSet<ILanguage> identifiedLanguages = new LinkedHashSet<ILanguage>();
        ILanguageImpl identifiedImpl = null;
        for (ILanguageImpl iLanguageImpl : impls) {
            if (!this.identify(resource, iLanguageImpl)) continue;
            identifiedLanguages.add(iLanguageImpl.belongsTo());
            identifiedImpl = iLanguageImpl;
        }
        if (identifiedLanguages.size() > 1) {
            throw new IllegalStateException("Resource " + resource + " identifies to multiple languages: " + Strings.tsJoin(identifiedLanguages, ", "));
        }
        if (identifiedImpl == null) {
            return null;
        }
        return new IdentifiedResource(resource, null, identifiedImpl);
    }

    @Override
    public boolean available(ILanguageImpl impl) {
        Iterable<IdentificationFacet> facets = impl.facets(IdentificationFacet.class);
        return !Iterables2.isEmpty(facets);
    }
}

