/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.build;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;

class FilesBuildState {
    public final Set<FileName> files = new HashSet<FileName>();
    public final Map<FileName, Long> modification = new HashMap<FileName, Long>();

    FilesBuildState() {
    }

    public long add(FileObject resource) {
        long newModification;
        FileName name = resource.getName();
        this.files.add(name);
        try {
            newModification = resource.getContent().getLastModifiedTime();
            this.modification.put(name, newModification);
        }
        catch (FileSystemException e) {
            newModification = Long.MAX_VALUE;
            this.modification.put(name, Long.MIN_VALUE);
        }
        return newModification;
    }

    public void add(FilesBuildState state) {
        this.files.addAll(state.files);
        this.modification.putAll(state.modification);
    }

    public void remove(FileName name) {
        this.files.remove(name);
        this.modification.remove(name);
    }
}

