/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.build;

import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.vfs2.FileSelector;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.build.CleanInput;
import org.metaborg.core.build.dependency.IDependencyService;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.LanguageUtils;
import org.metaborg.core.project.IProject;
import org.metaborg.util.iterators.Iterables2;

public class CleanInputBuilder {
    private final IProject project;
    private Set<ILanguageImpl> languages;
    private boolean addDependencyLanguages;
    @Nullable
    private FileSelector selector;

    public CleanInputBuilder(IProject project) {
        this.project = project;
        this.reset();
    }

    public void reset() {
        this.languages = new HashSet<ILanguageImpl>();
        this.addDependencyLanguages = true;
        this.selector = null;
    }

    public CleanInputBuilder withLanguages(Set<ILanguageImpl> languages) {
        this.languages = languages;
        return this;
    }

    public CleanInputBuilder addLanguages(Iterable<? extends ILanguageImpl> languages) {
        Iterables2.addAll(this.languages, languages);
        return this;
    }

    public CleanInputBuilder addLanguage(ILanguageImpl language) {
        this.languages.add(language);
        return this;
    }

    public CleanInputBuilder withComponents(Iterable<ILanguageComponent> components) {
        this.withLanguages(LanguageUtils.toImpls(components));
        return this;
    }

    public CleanInputBuilder addComponents(Iterable<? extends ILanguageComponent> components) {
        this.addLanguages(LanguageUtils.toImpls(components));
        return this;
    }

    public CleanInputBuilder addComponent(ILanguageComponent component) {
        this.addLanguages(component.contributesTo());
        return this;
    }

    public CleanInputBuilder withCompileDependencyLanguages(boolean addDependencyLanguages) {
        this.addDependencyLanguages = addDependencyLanguages;
        return this;
    }

    public CleanInputBuilder withSelector(FileSelector selector) {
        this.selector = selector;
        return this;
    }

    public CleanInput build(IDependencyService dependencyService) throws MetaborgException {
        if (this.addDependencyLanguages) {
            Collection<ILanguageComponent> compileComponents = dependencyService.compileDeps(this.project);
            Set<ILanguageImpl> compileImpls = LanguageUtils.toImpls(compileComponents);
            this.addLanguages(compileImpls);
        }
        return new CleanInput(this.project, this.languages, this.selector);
    }
}

