/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import jakarta.inject.Inject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import mb.scopegraph.regexp.IAlphabet;
import mb.scopegraph.regexp.IRegExp;
import mb.scopegraph.regexp.IRegExpBuilder;
import mb.scopegraph.regexp.IRegExpMatcher;
import mb.scopegraph.regexp.IState;
import mb.scopegraph.regexp.RegExpMatcher;
import mb.scopegraph.regexp.impl.FiniteAlphabet;
import mb.scopegraph.regexp.impl.RegExpNormalizingBuilder;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.terms.util.TermUtils;

public class STX_labelre_to_states
extends AbstractPrimitive {
    private static final String STATEMACHINE_OP = "StateMachine";
    private static final String STATE_OP = "State";
    private static final String INITIAL_STATE_NAME = "state_initial";
    private static final String EMPTY_OP = "Empty";
    private static final String EPSILON_OP = "Epsilon";
    private static final String CLOSURE_OP = "Closure";
    private static final String NEG_OP = "Neg";
    private static final String CONCAT_OP = "Concat";
    private static final String AND_OP = "And";
    private static final String OR_OP = "Or";
    private static final String EOP_LBL_OP = "EOP";

    @Inject
    public STX_labelre_to_states(String name) {
        super(STX_labelre_to_states.class.getSimpleName(), 0, 2);
    }

    @Override
    public boolean call(IContext context, Strategy[] svars, IStrategoTerm[] tvars) {
        IStrategoTerm regexpTerm = context.current();
        IStrategoTerm relationTerm = tvars[0];
        IStrategoTerm alphabetTerm = tvars[1];
        IAlphabet<IStrategoTerm> alphabet = this.parseAlphabet(alphabetTerm);
        IRegExp<IStrategoTerm> regexp = STX_labelre_to_states.parseRegexp(regexpTerm, alphabet, relationTerm);
        IRegExpMatcher<IStrategoTerm> matcher = RegExpMatcher.create(regexp);
        IState<IStrategoTerm> initial = matcher.state();
        HashMap<IState, String> stateNames = new HashMap<IState, String>();
        ArrayList<IStrategoAppl> stateList = new ArrayList<IStrategoAppl>();
        AtomicInteger counter = new AtomicInteger();
        ArrayDeque<IState<IStrategoTerm>> worklist = new ArrayDeque<IState<IStrategoTerm>>();
        worklist.add(matcher.state());
        stateNames.put(initial, INITIAL_STATE_NAME);
        ITermFactory TF = context.getFactory();
        IStrategoAppl ACCEPT = TF.makeAppl("Accept", new IStrategoTerm[0]);
        IStrategoAppl REJECT = TF.makeAppl("Reject", new IStrategoTerm[0]);
        while (!worklist.isEmpty()) {
            IState state = (IState)worklist.remove();
            String name = (String)stateNames.get(state);
            ArrayList<IStrategoTuple> transitions = new ArrayList<IStrategoTuple>();
            for (IStrategoTerm lbl : alphabet) {
                IState<IStrategoTerm> tgt = state.transition(lbl);
                if (tgt.isOblivion()) continue;
                String tgtName = stateNames.computeIfAbsent(tgt, st -> {
                    String n = "state_" + counter.incrementAndGet();
                    worklist.add((IState<IStrategoTerm>)st);
                    return n;
                });
                transitions.add(TF.makeTuple(lbl, TF.makeString(tgtName)));
            }
            IStrategoAppl acceptance = state.isAccepting() ? ACCEPT : REJECT;
            stateList.add(TF.makeAppl(STATE_OP, TF.makeString(name), acceptance, TF.makeList(transitions)));
        }
        IStrategoAppl result = TF.makeAppl(STATEMACHINE_OP, TF.makeList(stateList), TF.makeString(INITIAL_STATE_NAME));
        context.setCurrent(result);
        return true;
    }

    private static IRegExp<IStrategoTerm> parseRegexp(IStrategoTerm regexpTerm, IAlphabet<IStrategoTerm> alphabet, IStrategoTerm relationTerm) {
        RegExpNormalizingBuilder<IStrategoTerm> rb = new RegExpNormalizingBuilder<IStrategoTerm>(alphabet);
        IRegExp<IStrategoTerm> re = STX_labelre_to_states.parseRegexp(regexpTerm, alphabet, rb);
        if (TermUtils.isAppl(relationTerm, EOP_LBL_OP, 0)) {
            return re;
        }
        return (IRegExp)rb.concat(re, (IRegExp)rb.symbol(relationTerm));
    }

    private static IRegExp<IStrategoTerm> parseRegexp(IStrategoTerm regexpTerm, IAlphabet<IStrategoTerm> alphabet, IRegExpBuilder<IStrategoTerm> rb) {
        if (TermUtils.isAppl(regexpTerm, EMPTY_OP, 0)) {
            return (IRegExp)rb.emptySet();
        }
        if (TermUtils.isAppl(regexpTerm, EPSILON_OP, 0)) {
            return (IRegExp)rb.emptyString();
        }
        if (TermUtils.isAppl(regexpTerm, CLOSURE_OP, 1)) {
            IRegExp<IStrategoTerm> subExp = STX_labelre_to_states.parseRegexp(regexpTerm.getSubterm(0), alphabet, rb);
            return (IRegExp)rb.closure(subExp);
        }
        if (TermUtils.isAppl(regexpTerm, NEG_OP, 1)) {
            IRegExp<IStrategoTerm> subExp = STX_labelre_to_states.parseRegexp(regexpTerm.getSubterm(0), alphabet, rb);
            return (IRegExp)rb.complement(subExp);
        }
        if (TermUtils.isAppl(regexpTerm, CONCAT_OP, 2)) {
            IRegExp<IStrategoTerm> left = STX_labelre_to_states.parseRegexp(regexpTerm.getSubterm(0), alphabet, rb);
            IRegExp<IStrategoTerm> right = STX_labelre_to_states.parseRegexp(regexpTerm.getSubterm(1), alphabet, rb);
            return (IRegExp)rb.concat(left, right);
        }
        if (TermUtils.isAppl(regexpTerm, AND_OP, 2)) {
            IRegExp<IStrategoTerm> left = STX_labelre_to_states.parseRegexp(regexpTerm.getSubterm(0), alphabet, rb);
            IRegExp<IStrategoTerm> right = STX_labelre_to_states.parseRegexp(regexpTerm.getSubterm(1), alphabet, rb);
            return (IRegExp)rb.and(left, right);
        }
        if (TermUtils.isAppl(regexpTerm, OR_OP, 2)) {
            IRegExp<IStrategoTerm> left = STX_labelre_to_states.parseRegexp(regexpTerm.getSubterm(0), alphabet, rb);
            IRegExp<IStrategoTerm> right = STX_labelre_to_states.parseRegexp(regexpTerm.getSubterm(1), alphabet, rb);
            return (IRegExp)rb.or(left, right);
        }
        return (IRegExp)rb.symbol(regexpTerm);
    }

    private IAlphabet<IStrategoTerm> parseAlphabet(IStrategoTerm alphabetTerm) {
        if (alphabetTerm.getType() != TermType.LIST) {
            throw new IllegalArgumentException("Expected list of labels as second term argument");
        }
        return new FiniteAlphabet<IStrategoTerm>(alphabetTerm.getAllSubterms());
    }
}

