/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.tracer;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import mb.nabl2.terms.ITermVar;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.solver.persistent.step.IStep;
import mb.statix.solver.persistent.step.StepResult;

public abstract class SolverTracer<R extends IResult<R>> {
    public abstract SolverTracer<R> subTracer();

    public abstract R result(IState.Immutable var1);

    public void onTrySolveConstraint(IConstraint constraint, IState.Immutable state) {
    }

    public Optional<StepResult> onStep(IStep step, IState.Immutable oldState) {
        return step.result().match((ns, up, nc, nce, ne) -> this.onConstraintSolved(step.constraint(), ns, (Set.Immutable<ITermVar>)up, nc, nce, (Map.Immutable<ITermVar, ITermVar>)ne), ex -> this.onConstraintFailed(step.constraint(), oldState, (Throwable)ex), dl -> this.onConstraintDelayed(step.constraint(), oldState, (Delay)dl));
    }

    public Optional<StepResult> onConstraintSolved(IConstraint constraint, IState.Immutable newState, Set.Immutable<ITermVar> updatedVars, Collection<IConstraint> newConstraints, ICompleteness.Immutable newCriticalEdges, Map.Immutable<ITermVar, ITermVar> newExistentials) {
        this.onConstraintSolved(constraint, newState);
        return Optional.empty();
    }

    public void onConstraintSolved(IConstraint constraint, IState.Immutable newState) {
    }

    public Optional<StepResult> onConstraintFailed(IConstraint constraint, IState.Immutable newState, @Nullable Throwable exception) {
        this.onConstraintFailed(constraint, newState);
        return Optional.empty();
    }

    public void onConstraintFailed(IConstraint constraint, IState.Immutable state) {
    }

    public Optional<StepResult> onConstraintDelayed(IConstraint constraint, IState.Immutable newState, Delay delay) {
        this.onConstraintDelayed(constraint, newState);
        return Optional.empty();
    }

    public void onConstraintDelayed(IConstraint constraint, IState.Immutable state) {
    }

    public static interface IResult<SELF extends IResult<SELF>>
    extends Serializable {
        public SELF combine(SELF var1);
    }

    protected abstract class SubTracer
    extends SolverTracer<R> {
        protected SubTracer() {
        }

        @Override
        public SolverTracer<R> subTracer() {
            return this;
        }

        @Override
        public void onTrySolveConstraint(IConstraint constraint, IState.Immutable state) {
            SolverTracer.this.onTrySolveConstraint(constraint, state);
        }

        @Override
        public void onConstraintSolved(IConstraint constraint, IState.Immutable state) {
            SolverTracer.this.onConstraintSolved(constraint, state);
        }

        @Override
        public void onConstraintDelayed(IConstraint constraint, IState.Immutable state) {
            SolverTracer.this.onTrySolveConstraint(constraint, state);
        }

        @Override
        public void onConstraintFailed(IConstraint constraint, IState.Immutable state) {
            SolverTracer.this.onConstraintFailed(constraint, state);
        }
    }
}

