/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent.step;

import io.usethesource.capsule.Map;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.ITermVar;
import mb.statix.constraints.CExists;
import mb.statix.solver.persistent.step.ACExistsStep;
import mb.statix.solver.persistent.step.IStep;
import mb.statix.solver.persistent.step.StepResult;

public final class CExistsStep
extends ACExistsStep {
    private final CExists constraint;
    private final StepResult result;
    private final Map.Immutable<ITermVar, ITermVar> existentials;
    private transient int hashCode;

    private CExistsStep(CExists constraint, StepResult result, Map.Immutable<ITermVar, ITermVar> existentials) {
        this.constraint = Objects.requireNonNull(constraint, "constraint");
        this.result = Objects.requireNonNull(result, "result");
        this.existentials = Objects.requireNonNull(existentials, "existentials");
    }

    private CExistsStep(CExistsStep original, CExists constraint, StepResult result, Map.Immutable<ITermVar, ITermVar> existentials) {
        this.constraint = constraint;
        this.result = result;
        this.existentials = existentials;
    }

    @Override
    public CExists constraint() {
        return this.constraint;
    }

    @Override
    public StepResult result() {
        return this.result;
    }

    @Override
    public Map.Immutable<ITermVar, ITermVar> existentials() {
        return this.existentials;
    }

    public final CExistsStep withConstraint(CExists value) {
        if (this.constraint == value) {
            return this;
        }
        CExists newValue = Objects.requireNonNull(value, "constraint");
        return new CExistsStep(this, newValue, this.result, this.existentials);
    }

    public final CExistsStep withResult(StepResult value) {
        if (this.result == value) {
            return this;
        }
        StepResult newValue = Objects.requireNonNull(value, "result");
        return new CExistsStep(this, this.constraint, newValue, this.existentials);
    }

    public final CExistsStep withExistentials(Map.Immutable<ITermVar, ITermVar> value) {
        if (this.existentials == value) {
            return this;
        }
        Map.Immutable<ITermVar, ITermVar> newValue = Objects.requireNonNull(value, "existentials");
        return new CExistsStep(this, this.constraint, this.result, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CExistsStep && this.equalTo(0, (CExistsStep)another);
    }

    private boolean equalTo(int synthetic, CExistsStep another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.constraint.equals(another.constraint) && this.result.equals(another.result) && this.existentials.equals(another.existentials);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.constraint.hashCode();
        h += (h << 5) + this.result.hashCode();
        h += (h << 5) + this.existentials.hashCode();
        return h;
    }

    public String toString() {
        return "CExistsStep{constraint=" + this.constraint + ", result=" + this.result + ", existentials=" + this.existentials + "}";
    }

    public static CExistsStep of(CExists constraint, StepResult result, Map.Immutable<ITermVar, ITermVar> existentials) {
        return new CExistsStep(constraint, result, existentials);
    }

    public static CExistsStep copyOf(ACExistsStep instance) {
        if (instance instanceof CExistsStep) {
            return (CExistsStep)instance;
        }
        return CExistsStep.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ CExistsStep(CExistsStep cExistsStep, CExists cExists, StepResult stepResult, Map.Immutable immutable, CExistsStep cExistsStep2) {
        this(cExistsStep, cExists, stepResult, (Map.Immutable<ITermVar, ITermVar>)immutable);
    }

    public static final class Builder {
        private static final long INIT_BIT_CONSTRAINT = 1L;
        private static final long INIT_BIT_RESULT = 2L;
        private static final long INIT_BIT_EXISTENTIALS = 4L;
        private long initBits = 7L;
        private CExists constraint;
        private StepResult result;
        private Map.Immutable<ITermVar, ITermVar> existentials;

        private Builder() {
        }

        public final Builder from(ACExistsStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(IStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            IStep instance;
            if (object instanceof ACExistsStep) {
                instance = (ACExistsStep)object;
                this.constraint(((ACExistsStep)instance).constraint());
                this.existentials(((ACExistsStep)instance).existentials());
            }
            if (object instanceof IStep) {
                instance = (IStep)object;
                this.result(instance.result());
            }
        }

        public final Builder constraint(CExists constraint) {
            this.constraint = Objects.requireNonNull(constraint, "constraint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder result(StepResult result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder existentials(Map.Immutable<ITermVar, ITermVar> existentials) {
            this.existentials = Objects.requireNonNull(existentials, "existentials");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public CExistsStep build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CExistsStep(null, this.constraint, this.result, this.existentials, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("constraint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("result");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("existentials");
            }
            return "Cannot build CExistsStep, some of required attributes are not set " + attributes;
        }
    }
}

