/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent.step;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.stratego.TermIndex;
import mb.statix.constraints.CAstProperty;
import mb.statix.solver.ITermProperty;
import mb.statix.solver.persistent.step.ACAstPropertyStep;
import mb.statix.solver.persistent.step.IStep;
import mb.statix.solver.persistent.step.StepResult;

public final class CAstPropertyStep
extends ACAstPropertyStep {
    private final CAstProperty constraint;
    private final StepResult result;
    @Nullable
    private final TermIndex index;
    @Nullable
    private final ITermProperty property;
    @Nullable
    private final ITerm value;
    private final boolean update;
    private transient int hashCode;

    private CAstPropertyStep(CAstProperty constraint, StepResult result, @Nullable TermIndex index, @Nullable ITermProperty property, @Nullable ITerm value) {
        this.constraint = Objects.requireNonNull(constraint, "constraint");
        this.result = Objects.requireNonNull(result, "result");
        this.index = index;
        this.property = property;
        this.value = value;
        this.update = super.update();
    }

    private CAstPropertyStep(Builder builder) {
        this.constraint = builder.constraint;
        this.result = builder.result;
        this.index = builder.index;
        this.property = builder.property;
        this.value = builder.value;
        this.update = builder.updateIsSet() ? builder.update : super.update();
    }

    private CAstPropertyStep(CAstProperty constraint, StepResult result, @Nullable TermIndex index, @Nullable ITermProperty property, @Nullable ITerm value, boolean update) {
        this.constraint = constraint;
        this.result = result;
        this.index = index;
        this.property = property;
        this.value = value;
        this.update = update;
    }

    @Override
    public CAstProperty constraint() {
        return this.constraint;
    }

    @Override
    public StepResult result() {
        return this.result;
    }

    @Override
    @Nullable
    public TermIndex index() {
        return this.index;
    }

    @Override
    @Nullable
    public ITermProperty property() {
        return this.property;
    }

    @Override
    @Nullable
    public ITerm value() {
        return this.value;
    }

    @Override
    public boolean update() {
        return this.update;
    }

    public final CAstPropertyStep withConstraint(CAstProperty value) {
        if (this.constraint == value) {
            return this;
        }
        CAstProperty newValue = Objects.requireNonNull(value, "constraint");
        return new CAstPropertyStep(newValue, this.result, this.index, this.property, this.value, this.update);
    }

    public final CAstPropertyStep withResult(StepResult value) {
        if (this.result == value) {
            return this;
        }
        StepResult newValue = Objects.requireNonNull(value, "result");
        return new CAstPropertyStep(this.constraint, newValue, this.index, this.property, this.value, this.update);
    }

    public final CAstPropertyStep withIndex(@Nullable TermIndex value) {
        if (this.index == value) {
            return this;
        }
        return new CAstPropertyStep(this.constraint, this.result, value, this.property, this.value, this.update);
    }

    public final CAstPropertyStep withProperty(@Nullable ITermProperty value) {
        if (this.property == value) {
            return this;
        }
        return new CAstPropertyStep(this.constraint, this.result, this.index, value, this.value, this.update);
    }

    public final CAstPropertyStep withValue(@Nullable ITerm value) {
        if (this.value == value) {
            return this;
        }
        return new CAstPropertyStep(this.constraint, this.result, this.index, this.property, value, this.update);
    }

    public final CAstPropertyStep withUpdate(boolean value) {
        if (this.update == value) {
            return this;
        }
        return new CAstPropertyStep(this.constraint, this.result, this.index, this.property, this.value, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CAstPropertyStep && this.equalTo(0, (CAstPropertyStep)another);
    }

    private boolean equalTo(int synthetic, CAstPropertyStep another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.constraint.equals(another.constraint) && this.result.equals(another.result) && Objects.equals(this.index, another.index) && Objects.equals(this.property, another.property) && Objects.equals(this.value, another.value) && this.update == another.update;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.constraint.hashCode();
        h += (h << 5) + this.result.hashCode();
        h += (h << 5) + Objects.hashCode(this.index);
        h += (h << 5) + Objects.hashCode(this.property);
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + Boolean.hashCode(this.update);
        return h;
    }

    public String toString() {
        return "CAstPropertyStep{constraint=" + this.constraint + ", result=" + this.result + ", index=" + this.index + ", property=" + this.property + ", value=" + this.value + ", update=" + this.update + "}";
    }

    public static CAstPropertyStep of(CAstProperty constraint, StepResult result, @Nullable TermIndex index, @Nullable ITermProperty property, @Nullable ITerm value) {
        return new CAstPropertyStep(constraint, result, index, property, value);
    }

    public static CAstPropertyStep copyOf(ACAstPropertyStep instance) {
        if (instance instanceof CAstPropertyStep) {
            return (CAstPropertyStep)instance;
        }
        return CAstPropertyStep.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ CAstPropertyStep(Builder builder, CAstPropertyStep cAstPropertyStep) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_CONSTRAINT = 1L;
        private static final long INIT_BIT_RESULT = 2L;
        private static final long OPT_BIT_UPDATE = 1L;
        private long initBits = 3L;
        private long optBits;
        private CAstProperty constraint;
        private StepResult result;
        private TermIndex index;
        private ITermProperty property;
        private ITerm value;
        private boolean update;

        private Builder() {
        }

        public final Builder from(ACAstPropertyStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(IStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            IStep instance;
            if (object instanceof ACAstPropertyStep) {
                TermIndex indexValue;
                instance = (ACAstPropertyStep)object;
                ITermProperty propertyValue = ((ACAstPropertyStep)instance).property();
                if (propertyValue != null) {
                    this.property(propertyValue);
                }
                if ((indexValue = ((ACAstPropertyStep)instance).index()) != null) {
                    this.index(indexValue);
                }
                this.update(((ACAstPropertyStep)instance).update());
                this.constraint(((ACAstPropertyStep)instance).constraint());
                ITerm valueValue = ((ACAstPropertyStep)instance).value();
                if (valueValue != null) {
                    this.value(valueValue);
                }
            }
            if (object instanceof IStep) {
                instance = (IStep)object;
                this.result(instance.result());
            }
        }

        public final Builder constraint(CAstProperty constraint) {
            this.constraint = Objects.requireNonNull(constraint, "constraint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder result(StepResult result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder index(@Nullable TermIndex index) {
            this.index = index;
            return this;
        }

        public final Builder property(@Nullable ITermProperty property) {
            this.property = property;
            return this;
        }

        public final Builder value(@Nullable ITerm value) {
            this.value = value;
            return this;
        }

        public final Builder update(boolean update) {
            this.update = update;
            this.optBits |= 1L;
            return this;
        }

        public CAstPropertyStep build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CAstPropertyStep(this, null);
        }

        private boolean updateIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("constraint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("result");
            }
            return "Cannot build CAstPropertyStep, some of required attributes are not set " + attributes;
        }
    }
}

