/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent.query;

import java.util.Collections;
import mb.nabl2.terms.ITerm;
import mb.scopegraph.oopsla20.reference.DataWF;
import mb.scopegraph.oopsla20.reference.ResolutionException;
import mb.statix.constraints.Constraints;
import mb.statix.solver.Delay;
import mb.statix.solver.IState;
import mb.statix.solver.completeness.IsComplete;
import mb.statix.solver.log.NullDebugContext;
import mb.statix.solver.persistent.Solver;
import mb.statix.solver.query.ResolutionDelayException;
import mb.statix.spec.ApplyMode;
import mb.statix.spec.ApplyResult;
import mb.statix.spec.Rule;
import mb.statix.spec.RuleUtil;
import mb.statix.spec.Spec;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.task.NullCancel;
import org.metaborg.util.task.NullProgress;

class ConstraintDataWF
implements DataWF<ITerm> {
    private final Spec spec;
    private final Rule constraint;
    private final IState.Immutable state;
    private final IsComplete isComplete;

    public ConstraintDataWF(Spec spec, IState.Immutable state, IsComplete isComplete, Rule constraint) {
        this.spec = spec;
        this.state = state;
        this.isComplete = isComplete;
        this.constraint = constraint;
    }

    @Override
    public boolean wf(ITerm datum) throws ResolutionException, InterruptedException {
        ApplyResult applyResult;
        block3: {
            try {
                applyResult = RuleUtil.apply(this.state.unifier(), this.constraint, ImList.Immutable.of(new ITerm[]{datum}), null, ApplyMode.STRICT, ApplyMode.Safety.UNSAFE, true).orElse(null);
                if (applyResult != null) break block3;
                return false;
            }
            catch (Delay d) {
                throw new ResolutionDelayException("Data well-formedness delayed.", d);
            }
        }
        return Solver.entails(this.spec, this.state, Constraints.disjoin(applyResult.body()), Collections.emptyMap(), applyResult.criticalEdges(), this.isComplete, new NullDebugContext(), new NullProgress().subProgress(1), new NullCancel());
    }

    public String toString() {
        return this.constraint.toString(this.state.unifier()::toString);
    }
}

