/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver;

import java.util.List;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.ud.Diseq;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.statix.constraints.CEqual;
import mb.statix.constraints.CInequal;
import mb.statix.solver.IConstraint;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.functions.Action1;
import org.metaborg.util.unit.Unit;

public class StateUtil {
    public static List<IConstraint> asConstraint(IUniDisunifier unifier) {
        ImList.Mutable<IConstraint> constraints = ImList.Mutable.of(new IConstraint[0]);
        StateUtil.buildEqualities(unifier, constraints::add);
        StateUtil.buildInequalities(unifier.disequalities(), constraints::add);
        return constraints.freeze();
    }

    public static List<CEqual> asEqualities(IUnifier unifier) {
        ImList.Mutable<CEqual> constraints = ImList.Mutable.of(new CEqual[0]);
        StateUtil.buildEqualities(unifier, constraints::add);
        return constraints.freeze();
    }

    public static List<CInequal> asInequalities(IUniDisunifier unifier) {
        ImList.Mutable<CInequal> constraints = ImList.Mutable.of(new CInequal[0]);
        StateUtil.buildInequalities(unifier.disequalities(), constraints::add);
        return constraints.freeze();
    }

    private static void buildEqualities(IUnifier unifier, Action1<CEqual> add2) {
        for (ITermVar var : unifier.domainSet()) {
            add2.apply(new CEqual(var, unifier.findTerm(var)));
        }
    }

    private static void buildInequalities(Iterable<Diseq> diseqs, Action1<CInequal> add2) {
        diseqs.forEach(diseq -> diseq.toTuple().apply((us, left, right) -> {
            add2.apply(new CInequal((Iterable<ITermVar>)us, (ITerm)left, (ITerm)right));
            return Unit.unit;
        }));
    }
}

