/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.FreshVars;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.IConstraint;
import mb.statix.solver.completeness.ICompleteness;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action1;

public final class CExists
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Set.Immutable<ITermVar> vars;
    private final IConstraint constraint;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final CExists origin;
    @Nullable
    private final ICompleteness.Immutable bodyCriticalEdges;
    private volatile Set.Immutable<ITermVar> freeVars;
    private final int hashCode = this.computeHashCode();

    public CExists(Iterable<ITermVar> vars, IConstraint constraint) {
        this(vars, constraint, null, null, null, null);
    }

    public CExists(Iterable<ITermVar> vars, IConstraint constraint, @Nullable IConstraint cause) {
        this(vars, constraint, cause, null, null, null);
    }

    public CExists(Iterable<ITermVar> vars, IConstraint constraint, @Nullable IConstraint cause, ICompleteness.Immutable bodyCriticalEdges) {
        this(vars, constraint, cause, null, bodyCriticalEdges, null);
    }

    private CExists(Iterable<ITermVar> vars, IConstraint constraint, @Nullable IConstraint cause, @Nullable CExists origin, @Nullable ICompleteness.Immutable bodyCriticalEdges, @Nullable Set.Immutable<ITermVar> freeVars) {
        this.vars = CapsuleUtil.toSet(vars);
        this.constraint = constraint;
        this.cause = cause;
        this.origin = origin;
        this.bodyCriticalEdges = bodyCriticalEdges;
        this.freeVars = freeVars;
    }

    public Set.Immutable<ITermVar> vars() {
        return this.vars;
    }

    public IConstraint constraint() {
        return this.constraint;
    }

    public CExists withConstraint(IConstraint constraint) {
        return this.withArguments((Iterable<ITermVar>)this.vars, constraint);
    }

    public CExists withArguments(Iterable<ITermVar> vars, IConstraint constraint) {
        if (this.vars == vars && this.constraint == constraint) {
            return this;
        }
        return new CExists(vars, constraint, this.cause, this.origin, this.bodyCriticalEdges, null);
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CExists withCause(@Nullable IConstraint cause) {
        if (this.cause == cause) {
            return this;
        }
        return new CExists((Iterable<ITermVar>)this.vars, this.constraint, cause, this.origin, this.bodyCriticalEdges, this.freeVars);
    }

    @Override
    @Nullable
    public CExists origin() {
        return this.origin;
    }

    @Override
    public Optional<ICompleteness.Immutable> bodyCriticalEdges() {
        return Optional.ofNullable(this.bodyCriticalEdges);
    }

    @Override
    public CExists withBodyCriticalEdges(@Nullable ICompleteness.Immutable criticalEdges) {
        if (this.bodyCriticalEdges == criticalEdges) {
            return this;
        }
        return new CExists((Iterable<ITermVar>)this.vars, this.constraint, this.cause, this.origin, criticalEdges, this.freeVars);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseExists(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseExists(this);
    }

    @Override
    public Set.Immutable<ITermVar> getVars() {
        return Set.Immutable.union(this.vars, this.constraint.getVars());
    }

    @Override
    public Set.Immutable<ITermVar> freeVars() {
        Set.Immutable result = this.freeVars;
        if (result == null) {
            Set.Transient _freeVars = CapsuleUtil.transientSet();
            this.doVisitFreeVars(arg_0 -> _freeVars.__insert(arg_0));
            this.freeVars = result = _freeVars.freeze();
        }
        return result;
    }

    @Override
    public void visitFreeVars(Action1<ITermVar> onFreeVar) {
        this.freeVars().forEach(onFreeVar::apply);
    }

    private void doVisitFreeVars(Action1<ITermVar> onFreeVar) {
        this.constraint.visitFreeVars(v -> {
            if (!this.vars.contains(v)) {
                onFreeVar.apply((ITermVar)v);
            }
        });
    }

    @Override
    public CExists apply(ISubstitution.Immutable subst) {
        return this.apply(subst, false);
    }

    @Override
    public CExists unsafeApply(ISubstitution.Immutable subst) {
        return this.unsafeApply(subst, false);
    }

    @Override
    public CExists apply(IRenaming subst) {
        return this.apply(subst, false);
    }

    @Override
    public CExists apply(ISubstitution.Immutable subst, boolean trackOrigin) {
        ISubstitution.Immutable localSubst = subst.removeAll((Iterable<ITermVar>)this.vars).retainAll((Iterable<ITermVar>)this.freeVars());
        if (localSubst.isEmpty()) {
            return this;
        }
        IConstraint constraint = this.constraint;
        ICompleteness.Immutable bodyCriticalEdges = this.bodyCriticalEdges;
        Set.Immutable freeVars = this.freeVars;
        if (freeVars != null) {
            freeVars = freeVars.__removeAll(localSubst.domainSet()).__insertAll(localSubst.rangeSet());
        }
        FreshVars fresh = new FreshVars(new Set[]{localSubst.domainSet(), localSubst.rangeSet(), this.freeVars()});
        IRenaming ren = fresh.fresh((Set<ITermVar>)this.vars);
        Set.Immutable<ITermVar> vars = fresh.fix();
        if (!ren.isEmpty()) {
            localSubst = ren.asSubstitution().compose(localSubst);
        }
        constraint = constraint.apply(localSubst, trackOrigin);
        if (bodyCriticalEdges != null) {
            bodyCriticalEdges = bodyCriticalEdges.apply(localSubst);
        }
        return new CExists((Iterable<ITermVar>)vars, constraint, this.cause, this.origin == null && trackOrigin ? this : this.origin, bodyCriticalEdges, (Set.Immutable<ITermVar>)freeVars);
    }

    @Override
    public CExists unsafeApply(ISubstitution.Immutable subst, boolean trackOrigin) {
        ISubstitution.Immutable localSubst = subst.removeAll((Iterable<ITermVar>)this.vars);
        if (localSubst.isEmpty()) {
            return this;
        }
        IConstraint constraint = this.constraint;
        ICompleteness.Immutable bodyCriticalEdges = this.bodyCriticalEdges;
        constraint = constraint.unsafeApply(localSubst, trackOrigin);
        if (bodyCriticalEdges != null) {
            bodyCriticalEdges = bodyCriticalEdges.apply(localSubst);
        }
        return new CExists((Iterable<ITermVar>)this.vars, constraint, this.cause, this.origin == null && trackOrigin ? this : this.origin, bodyCriticalEdges, null);
    }

    @Override
    public CExists apply(IRenaming subst, boolean trackOrigin) {
        Set.Immutable<ITermVar> vars = this.vars;
        IConstraint constraint = this.constraint;
        ICompleteness.Immutable bodyCriticalEdges = this.bodyCriticalEdges;
        vars = CapsuleUtil.toSet(subst.rename((Set<ITermVar>)vars));
        constraint = constraint.apply(subst, trackOrigin);
        if (bodyCriticalEdges != null) {
            bodyCriticalEdges = bodyCriticalEdges.apply(subst);
        }
        return new CExists((Iterable<ITermVar>)vars, constraint, this.cause, this.origin == null && trackOrigin ? this : this.origin, bodyCriticalEdges, null);
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(termToString.format((Iterable<? extends ITerm>)this.vars)).append("} ");
        sb.append(this.constraint.toString(termToString));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CExists that = (CExists)o;
        return this.hashCode == that.hashCode && Objects.equals(this.vars, that.vars) && Objects.equals(this.constraint, that.constraint) && Objects.equals(this.cause, that.cause) && Objects.equals(this.origin, that.origin);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return Objects.hash(this.vars, this.constraint, this.cause, this.origin);
    }
}

