/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent.util;

import io.usethesource.capsule.Set;
import java.util.List;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IBlobTerm;
import mb.nabl2.terms.IConsTerm;
import mb.nabl2.terms.IIntTerm;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.INilTerm;
import mb.nabl2.terms.IStringTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.ApplPattern;
import mb.nabl2.terms.matching.ConsPattern;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.matching.PatternAs;
import mb.nabl2.terms.matching.StringPattern;
import mb.nabl2.terms.matching.TermPattern;
import mb.scopegraph.patching.IPatchCollection;
import mb.statix.constraints.CArith;
import mb.statix.constraints.CAstId;
import mb.statix.constraints.CAstProperty;
import mb.statix.constraints.CCompiledQuery;
import mb.statix.constraints.CConj;
import mb.statix.constraints.CEqual;
import mb.statix.constraints.CExists;
import mb.statix.constraints.CFalse;
import mb.statix.constraints.CInequal;
import mb.statix.constraints.CNew;
import mb.statix.constraints.CResolveQuery;
import mb.statix.constraints.CTellEdge;
import mb.statix.constraints.CTrue;
import mb.statix.constraints.CTry;
import mb.statix.constraints.CUser;
import mb.statix.constraints.IResolveQuery;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.IConstraint;
import mb.statix.solver.query.QueryFilter;
import mb.statix.solver.query.QueryMin;
import mb.statix.solver.query.QueryProject;
import mb.statix.spec.Rule;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.unit.Unit;

public class Patching {
    private static final String SCOPE_OP = "Scope";

    public static Set.Immutable<Scope> ruleScopes(Rule rule) {
        LazyScopeSetSupplier scopes = new LazyScopeSetSupplier();
        Patching.ruleScopes(rule, scopes);
        return scopes.freeze();
    }

    public static Set.Immutable<Scope> constraintScopes(IConstraint constraint) {
        LazyScopeSetSupplier scopes = new LazyScopeSetSupplier();
        Patching.constraintScopes(constraint, scopes);
        return scopes.freeze();
    }

    public static Set.Immutable<Scope> termScopes(ITerm term) {
        LazyScopeSetSupplier scopes = new LazyScopeSetSupplier();
        Patching.termScopes(term, scopes);
        return scopes.freeze();
    }

    public static Set.Immutable<Scope> patternScopes(Pattern pattern) {
        LazyScopeSetSupplier scopes = new LazyScopeSetSupplier();
        Patching.patternScopes(pattern, scopes);
        return scopes.freeze();
    }

    private static void ruleScopes(Rule rule, LazyScopeSetSupplier scopes) {
        for (Pattern pattern : rule.params()) {
            Patching.patternScopes(pattern, scopes);
        }
        Patching.constraintScopes(rule.body(), scopes);
    }

    private static void constraintScopes(IConstraint constraint, final LazyScopeSetSupplier scopes) {
        constraint.match(new IConstraint.Cases<Unit>(){

            @Override
            public Unit caseArith(CArith c) {
                return Unit.unit;
            }

            @Override
            public Unit caseConj(CConj c) {
                Patching.constraintScopes(c.left(), scopes);
                Patching.constraintScopes(c.right(), scopes);
                return Unit.unit;
            }

            @Override
            public Unit caseEqual(CEqual c) {
                Patching.termScopes(c.term1(), scopes);
                Patching.termScopes(c.term2(), scopes);
                return Unit.unit;
            }

            @Override
            public Unit caseExists(CExists c) {
                Patching.constraintScopes(c.constraint(), scopes);
                return Unit.unit;
            }

            @Override
            public Unit caseFalse(CFalse c) {
                return Unit.unit;
            }

            @Override
            public Unit caseInequal(CInequal c) {
                Patching.termScopes(c.term1(), scopes);
                Patching.termScopes(c.term2(), scopes);
                return Unit.unit;
            }

            @Override
            public Unit caseNew(CNew c) {
                Patching.termScopes(c.datumTerm(), scopes);
                return Unit.unit;
            }

            @Override
            public Unit caseResolveQuery(IResolveQuery c) {
                Patching.termScopes(c.scopeTerm(), scopes);
                Patching.termScopes(c.resultTerm(), scopes);
                Patching.ruleScopes(c.filter().getDataWF(), scopes);
                Patching.ruleScopes(c.min().getDataEquiv(), scopes);
                return Unit.unit;
            }

            @Override
            public Unit caseTellEdge(CTellEdge c) {
                Patching.termScopes(c.sourceTerm(), scopes);
                Patching.termScopes(c.targetTerm(), scopes);
                return Unit.unit;
            }

            @Override
            public Unit caseTermId(CAstId c) {
                Patching.termScopes(c.astTerm(), scopes);
                Patching.termScopes(c.idTerm(), scopes);
                return Unit.unit;
            }

            @Override
            public Unit caseTermProperty(CAstProperty c) {
                Patching.termScopes(c.idTerm(), scopes);
                Patching.termScopes(c.value(), scopes);
                return Unit.unit;
            }

            @Override
            public Unit caseTrue(CTrue c) {
                return Unit.unit;
            }

            @Override
            public Unit caseTry(CTry c) {
                Patching.constraintScopes(c.constraint(), scopes);
                return Unit.unit;
            }

            @Override
            public Unit caseUser(CUser c) {
                for (ITerm arg : c.args()) {
                    Patching.termScopes(arg, scopes);
                }
                return Unit.unit;
            }
        });
    }

    private static void termScopes(ITerm term, final LazyScopeSetSupplier scopes) {
        term.match(new ITerm.Cases<Unit>(){

            @Override
            public Unit caseAppl(IApplTerm appl) {
                if (appl instanceof Scope) {
                    scopes.get().__insert((Object)((Scope)appl));
                } else if (appl.getOp().equals(Patching.SCOPE_OP) && appl.getArity() == 2) {
                    ITerm arg1 = appl.getArgs().get(0);
                    ITerm arg2 = appl.getArgs().get(1);
                    if (arg1 instanceof IStringTerm && arg2 instanceof IStringTerm) {
                        String resource = ((IStringTerm)arg1).getValue();
                        String id = ((IStringTerm)arg2).getValue();
                        scopes.get().__insert((Object)Scope.of(resource, id));
                    } else {
                        Patching.termScopes(arg1, scopes);
                        Patching.termScopes(arg2, scopes);
                    }
                } else {
                    for (ITerm arg : appl.getArgs()) {
                        Patching.termScopes(arg, scopes);
                    }
                }
                return Unit.unit;
            }

            @Override
            public Unit caseBlob(IBlobTerm integer) {
                return Unit.unit;
            }

            @Override
            public Unit caseInt(IIntTerm integer) {
                return Unit.unit;
            }

            @Override
            public Unit caseList(IListTerm list) {
                Patching.listTermScopes(list, scopes);
                return Unit.unit;
            }

            @Override
            public Unit caseString(IStringTerm string) {
                return Unit.unit;
            }

            @Override
            public Unit caseVar(ITermVar var) {
                return Unit.unit;
            }
        });
    }

    private static void listTermScopes(IListTerm list, final LazyScopeSetSupplier scopes) {
        list.match(new IListTerm.Cases<Unit>(){

            @Override
            public Unit caseCons(IConsTerm cons) {
                Patching.termScopes(cons.getHead(), scopes);
                Patching.listTermScopes(cons.getTail(), scopes);
                return Unit.unit;
            }

            @Override
            public Unit caseNil(INilTerm nil) {
                return Unit.unit;
            }

            @Override
            public Unit caseVar(ITermVar var) {
                return Unit.unit;
            }
        });
    }

    private static void patternScopes(Pattern pattern, LazyScopeSetSupplier scopes) {
        if (pattern instanceof ApplPattern) {
            ApplPattern appl = (ApplPattern)pattern;
            if (appl.getOp().equals(SCOPE_OP) && appl.getArgs().size() == 2) {
                Pattern arg1 = appl.getArgs().get(0);
                Pattern arg2 = appl.getArgs().get(1);
                if (arg1 instanceof StringPattern && arg2 instanceof StringPattern) {
                    String resource = ((StringPattern)arg1).getValue();
                    String id = ((StringPattern)arg2).getValue();
                    scopes.get().__insert((Object)Scope.of(resource, id));
                }
            } else {
                for (Pattern arg : appl.getArgs()) {
                    Patching.patternScopes(arg, scopes);
                }
            }
        } else if (pattern instanceof ConsPattern) {
            ConsPattern cons = (ConsPattern)pattern;
            Patching.patternScopes(cons.getHead(), scopes);
            Patching.patternScopes(cons.getTail(), scopes);
        } else if (pattern instanceof PatternAs) {
            PatternAs as = (PatternAs)pattern;
            Patching.patternScopes(as.getPattern(), scopes);
        }
    }

    public static Rule patch(Rule rule, IPatchCollection<Scope> patches) {
        ImList.Immutable<Pattern> params = rule.params();
        ImList.Mutable<Pattern> newParamsBuilder = null;
        int i = 0;
        while (i < params.size()) {
            Pattern param = (Pattern)params.get(i);
            Pattern newParam = Patching.patch(param, patches);
            if (newParam != null) {
                if (newParamsBuilder == null) {
                    newParamsBuilder = new ImList.Mutable<Pattern>(params.size());
                    int j = 0;
                    while (j < i) {
                        newParamsBuilder.add((Pattern)params.get(j));
                        ++j;
                    }
                }
                newParamsBuilder.add(newParam);
            } else if (newParamsBuilder != null) {
                newParamsBuilder.add(param);
            }
            ++i;
        }
        IConstraint newBody = Patching.patch(rule.body(), patches);
        if (newParamsBuilder == null && newBody == null) {
            return null;
        }
        Rule result = rule;
        if (newParamsBuilder != null) {
            result = result.withParams(newParamsBuilder.freeze());
        }
        if (newBody != null) {
            result = result.withBody(newBody);
        }
        return result;
    }

    public static IConstraint patch(IConstraint constraint, final IPatchCollection<Scope> patches) {
        return constraint.match(new IConstraint.Cases<IConstraint>(){

            @Override
            public IConstraint caseArith(CArith c) {
                return null;
            }

            @Override
            public IConstraint caseConj(CConj c) {
                IConstraint newLeft = Patching.patch(c.left(), (IPatchCollection<Scope>)patches);
                IConstraint newRight = Patching.patch(c.right(), (IPatchCollection<Scope>)patches);
                if (newLeft == null && newRight == null) {
                    return null;
                }
                newLeft = newLeft == null ? c.left() : newLeft;
                newRight = newRight == null ? c.right() : newRight;
                return c.withArguments(newLeft, newRight);
            }

            @Override
            public IConstraint caseEqual(CEqual c) {
                ITerm newTerm1 = Patching.patch(c.term1(), (IPatchCollection<Scope>)patches);
                ITerm newTerm2 = Patching.patch(c.term2(), (IPatchCollection<Scope>)patches);
                if (newTerm1 == null && newTerm2 == null) {
                    return null;
                }
                newTerm1 = newTerm1 == null ? c.term1() : newTerm1;
                newTerm2 = newTerm2 == null ? c.term2() : newTerm2;
                return c.withArguments(newTerm1, newTerm2);
            }

            @Override
            public IConstraint caseExists(CExists c) {
                IConstraint newConstraint = Patching.patch(c.constraint(), (IPatchCollection<Scope>)patches);
                return newConstraint == null ? null : c.withArguments((Iterable<ITermVar>)c.vars(), newConstraint);
            }

            @Override
            public IConstraint caseFalse(CFalse c) {
                return null;
            }

            @Override
            public IConstraint caseInequal(CInequal c) {
                ITerm newTerm1 = Patching.patch(c.term1(), (IPatchCollection<Scope>)patches);
                ITerm newTerm2 = Patching.patch(c.term2(), (IPatchCollection<Scope>)patches);
                if (newTerm1 == null && newTerm2 == null) {
                    return null;
                }
                newTerm1 = newTerm1 == null ? c.term1() : newTerm1;
                newTerm2 = newTerm2 == null ? c.term2() : newTerm2;
                return c.withArguments((Iterable<ITermVar>)c.universals(), newTerm1, newTerm2);
            }

            @Override
            public IConstraint caseNew(CNew c) {
                ITerm newScopeTerm = Patching.patch(c.scopeTerm(), (IPatchCollection<Scope>)patches);
                ITerm newDatumTerm = Patching.patch(c.datumTerm(), (IPatchCollection<Scope>)patches);
                if (newScopeTerm == null && newDatumTerm == null) {
                    return null;
                }
                newScopeTerm = newScopeTerm == null ? c.scopeTerm() : newScopeTerm;
                newDatumTerm = newDatumTerm == null ? c.datumTerm() : newDatumTerm;
                return c.withArguments(newScopeTerm, newDatumTerm);
            }

            @Override
            public IConstraint caseResolveQuery(IResolveQuery c) {
                ITerm scopeTerm = Patching.patch(c.scopeTerm(), (IPatchCollection<Scope>)patches);
                ITerm resultTerm = Patching.patch(c.resultTerm(), (IPatchCollection<Scope>)patches);
                Rule newDataWf = Patching.patch(c.filter().getDataWF(), (IPatchCollection<Scope>)patches);
                Rule newDataEquiv = Patching.patch(c.min().getDataEquiv(), (IPatchCollection<Scope>)patches);
                if (scopeTerm == null && resultTerm == null && newDataWf == null && newDataEquiv == null) {
                    return null;
                }
                final ITerm newScopeTerm = scopeTerm == null ? c.scopeTerm() : scopeTerm;
                final ITerm newResultTerm = resultTerm == null ? c.resultTerm() : resultTerm;
                final QueryFilter newFilter = new QueryFilter(c.filter().getLabelWF(), newDataWf == null ? c.filter().getDataWF() : newDataWf);
                final QueryMin newMin = new QueryMin(c.min().getLabelOrder(), newDataEquiv == null ? c.min().getDataEquiv() : newDataEquiv);
                final QueryProject project = c.project();
                return c.match(new IResolveQuery.Cases<IResolveQuery>(){

                    @Override
                    public IResolveQuery caseResolveQuery(CResolveQuery q) {
                        return q.withArguments(newFilter, newMin, project, newScopeTerm, newResultTerm);
                    }

                    @Override
                    public IResolveQuery caseCompiledQuery(CCompiledQuery q) {
                        return q.withArguments(newFilter, newMin, project, newScopeTerm, newResultTerm, q.stateMachine());
                    }
                });
            }

            @Override
            public IConstraint caseTellEdge(CTellEdge c) {
                ITerm newSourceTerm = Patching.patch(c.sourceTerm(), (IPatchCollection<Scope>)patches);
                ITerm newTargetTerm = Patching.patch(c.targetTerm(), (IPatchCollection<Scope>)patches);
                if (newSourceTerm == null && newTargetTerm == null) {
                    return null;
                }
                newSourceTerm = newSourceTerm == null ? c.sourceTerm() : newSourceTerm;
                newTargetTerm = newTargetTerm == null ? c.targetTerm() : newTargetTerm;
                return c.withArguments(newSourceTerm, c.label(), newTargetTerm);
            }

            @Override
            public IConstraint caseTermId(CAstId c) {
                ITerm newAstTerm = Patching.patch(c.astTerm(), (IPatchCollection<Scope>)patches);
                ITerm newIdTerm = Patching.patch(c.idTerm(), (IPatchCollection<Scope>)patches);
                if (newAstTerm == null && newIdTerm == null) {
                    return null;
                }
                newAstTerm = newAstTerm == null ? c.astTerm() : newAstTerm;
                newIdTerm = newIdTerm == null ? c.idTerm() : newIdTerm;
                return c.withArguments(newAstTerm, newIdTerm);
            }

            @Override
            public IConstraint caseTermProperty(CAstProperty c) {
                ITerm newIdTerm = Patching.patch(c.idTerm(), (IPatchCollection<Scope>)patches);
                ITerm newValue = Patching.patch(c.value(), (IPatchCollection<Scope>)patches);
                if (newIdTerm == null && newValue == null) {
                    return null;
                }
                newIdTerm = newIdTerm == null ? c.idTerm() : newIdTerm;
                newValue = newValue == null ? c.value() : newValue;
                return c.withArguments(newIdTerm, c.property(), c.op(), newValue);
            }

            @Override
            public IConstraint caseTrue(CTrue c) {
                return null;
            }

            @Override
            public IConstraint caseTry(CTry c) {
                IConstraint newConstraint = Patching.patch(c.constraint(), (IPatchCollection<Scope>)patches);
                return newConstraint == null ? null : c.withArguments(newConstraint);
            }

            @Override
            public IConstraint caseUser(CUser c) {
                List<ITerm> args = c.args();
                int size = args.size();
                ImList.Mutable<ITerm> newArgsBuilder = null;
                int i = 0;
                while (i < size) {
                    ITerm arg = args.get(i);
                    ITerm newArg = Patching.patch(arg, (IPatchCollection<Scope>)patches);
                    if (newArg != null) {
                        if (newArgsBuilder == null) {
                            newArgsBuilder = new ImList.Mutable<ITerm>(size);
                            int j = 0;
                            while (j < i) {
                                newArgsBuilder.add(args.get(j));
                                ++j;
                            }
                        }
                        newArgsBuilder.add(newArg);
                    } else if (newArgsBuilder != null) {
                        newArgsBuilder.add(arg);
                    }
                    ++i;
                }
                if (newArgsBuilder == null) {
                    return null;
                }
                return c.withArguments(c.name(), newArgsBuilder.freeze()).withOwnCriticalEdges(c.ownCriticalEdges().orElse(null));
            }
        });
    }

    public static Pattern patch(Pattern pattern, IPatchCollection<Scope> patches) {
        if (pattern instanceof ApplPattern) {
            ApplPattern appl = (ApplPattern)pattern;
            List<Pattern> args = appl.getArgs();
            int size = args.size();
            if (appl.getOp().equals(SCOPE_OP) && size == 2) {
                Pattern arg1 = appl.getArgs().get(0);
                Pattern arg2 = appl.getArgs().get(1);
                if (arg1 instanceof StringPattern && arg2 instanceof StringPattern) {
                    Scope newScope;
                    String id;
                    String resource = ((StringPattern)arg1).getValue();
                    Scope scope = Scope.of(resource, id = ((StringPattern)arg2).getValue());
                    if (scope == (newScope = patches.patch(scope))) {
                        return null;
                    }
                    ImList.Immutable<Pattern> newArgs = ImList.Immutable.of(new Pattern[]{TermPattern.P.newString(newScope.getResource(), arg1.getAttachments()), TermPattern.P.newString(newScope.getName(), arg2.getAttachments())});
                    return TermPattern.P.newAppl(SCOPE_OP, newArgs, appl.getAttachments());
                }
            }
            ImList.Mutable<Pattern> newArgsBuilder = null;
            int i = 0;
            while (i < size) {
                Pattern arg = args.get(i);
                Pattern newArg = Patching.patch(arg, patches);
                if (newArg != null) {
                    if (newArgsBuilder == null) {
                        newArgsBuilder = new ImList.Mutable<Pattern>(size);
                        int j = 0;
                        while (j < i) {
                            newArgsBuilder.add(args.get(j));
                            ++j;
                        }
                    }
                    newArgsBuilder.add(newArg);
                } else if (newArgsBuilder != null) {
                    newArgsBuilder.add(arg);
                }
                ++i;
            }
            if (newArgsBuilder == null) {
                return null;
            }
            return TermPattern.P.newAppl(appl.getOp(), newArgsBuilder.freeze(), appl.getAttachments());
        }
        if (pattern instanceof ConsPattern) {
            ConsPattern cons = (ConsPattern)pattern;
            Pattern head = Patching.patch(cons.getHead(), patches);
            Pattern tail = Patching.patch(cons.getTail(), patches);
            if (head == null && tail == null) {
                return null;
            }
            head = head == null ? cons.getHead() : head;
            tail = tail == null ? cons.getTail() : tail;
            return TermPattern.P.newCons(head, tail, cons.getAttachments());
        }
        if (pattern instanceof PatternAs) {
            PatternAs as = (PatternAs)pattern;
            Pattern sub = Patching.patch(as.getPattern(), patches);
            return sub == null ? null : TermPattern.P.newAs(as.getVar(), sub);
        }
        return null;
    }

    public static ITerm patch(ITerm term, final IPatchCollection<Scope> patches) {
        return term.match(new ITerm.Cases<ITerm>(){

            @Override
            public ITerm caseVar(ITermVar var) {
                return null;
            }

            @Override
            public ITerm caseString(IStringTerm string) {
                return null;
            }

            @Override
            public ITerm caseList(IListTerm cons) {
                return Patching.patch(cons, (IPatchCollection<Scope>)patches);
            }

            @Override
            public ITerm caseInt(IIntTerm integer) {
                return null;
            }

            @Override
            public ITerm caseBlob(IBlobTerm integer) {
                return null;
            }

            @Override
            public ITerm caseAppl(IApplTerm appl) {
                if (appl instanceof Scope) {
                    Scope newScope = patches.patch((Scope)appl);
                    return newScope == appl ? null : newScope;
                }
                if (appl.getOp().equals(Patching.SCOPE_OP) && appl.getArity() == 2) {
                    ITerm arg1 = appl.getArgs().get(0);
                    ITerm arg2 = appl.getArgs().get(1);
                    if (arg1 instanceof IStringTerm && arg2 instanceof IStringTerm) {
                        String name;
                        String resource = ((IStringTerm)arg1).getValue();
                        Scope oldScope = Scope.of(resource, name = ((IStringTerm)arg2).getValue());
                        Scope newScope = patches.patch(oldScope);
                        return newScope == appl ? null : newScope;
                    }
                } else if (appl.getArity() == 0) {
                    return null;
                }
                ImList.Immutable<ITerm> args = appl.getArgs();
                int size = args.size();
                ImList.Mutable<ITerm> newArgsBuilder = null;
                int i = 0;
                while (i < size) {
                    ITerm arg = (ITerm)args.get(i);
                    ITerm newArg = Patching.patch(arg, (IPatchCollection<Scope>)patches);
                    if (newArg != null) {
                        if (newArgsBuilder == null) {
                            newArgsBuilder = new ImList.Mutable<ITerm>(size);
                            int j = 0;
                            while (j < i) {
                                newArgsBuilder.add((ITerm)args.get(j));
                                ++j;
                            }
                        }
                        newArgsBuilder.add(newArg);
                    } else if (newArgsBuilder != null) {
                        newArgsBuilder.add(arg);
                    }
                    ++i;
                }
                if (newArgsBuilder == null) {
                    return null;
                }
                return TermBuild.B.newAppl(appl.getOp(), newArgsBuilder.freeze(), appl.getAttachments());
            }
        });
    }

    public static IListTerm patch(IListTerm term, final IPatchCollection<Scope> patches) {
        return term.match(new IListTerm.Cases<IListTerm>(){

            @Override
            public IListTerm caseCons(IConsTerm cons) {
                ITerm newHead = Patching.patch(cons.getHead(), (IPatchCollection<Scope>)patches);
                IListTerm newTail = Patching.patch(cons.getTail(), (IPatchCollection<Scope>)patches);
                if (newHead == null && newTail == null) {
                    return null;
                }
                newHead = newHead == null ? cons.getHead() : newHead;
                newTail = newTail == null ? cons.getTail() : newTail;
                return TermBuild.B.newCons(newHead, newTail, cons.getAttachments());
            }

            @Override
            public IListTerm caseNil(INilTerm nil) {
                return null;
            }

            @Override
            public IListTerm caseVar(ITermVar var) {
                return null;
            }
        });
    }

    private static final class LazyScopeSetSupplier {
        private Set.Transient<Scope> value;

        private LazyScopeSetSupplier() {
        }

        public Set.Transient<Scope> get() {
            Object result = this.value;
            if (this.value == null) {
                this.value = result = CapsuleUtil.transientSet();
            }
            return result;
        }

        public Set.Immutable<Scope> freeze() {
            Set.Transient<Scope> value = this.value;
            return value == null ? CapsuleUtil.immutableSet() : value.freeze();
        }
    }
}

