/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.statix.concurrent.AUnitResult;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.solver.tracer.SolverTracer;

public final class UnitResult<TR extends SolverTracer.IResult<TR>>
extends AUnitResult<TR>
implements Serializable {
    private final String resource;
    @Nullable
    private final SolverResult<TR> solveResult;
    @Nullable
    private final Throwable exception;
    private transient int hashCode;
    private static final long serialVersionUID = 42L;

    private UnitResult(String resource, @Nullable SolverResult<TR> solveResult, @Nullable Throwable exception) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.solveResult = solveResult;
        this.exception = exception;
    }

    private UnitResult(UnitResult<TR> original, String resource, @Nullable SolverResult<TR> solveResult, @Nullable Throwable exception) {
        this.resource = resource;
        this.solveResult = solveResult;
        this.exception = exception;
    }

    @Override
    public String resource() {
        return this.resource;
    }

    @Override
    @Nullable
    public SolverResult<TR> solveResult() {
        return this.solveResult;
    }

    @Override
    @Nullable
    public Throwable exception() {
        return this.exception;
    }

    public final UnitResult<TR> withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new UnitResult<TR>(this, newValue, this.solveResult, this.exception);
    }

    public final UnitResult<TR> withSolveResult(@Nullable SolverResult<TR> value) {
        if (this.solveResult == value) {
            return this;
        }
        return new UnitResult<TR>(this, this.resource, value, this.exception);
    }

    public final UnitResult<TR> withException(@Nullable Throwable value) {
        if (this.exception == value) {
            return this;
        }
        return new UnitResult<TR>(this, this.resource, this.solveResult, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UnitResult && this.equalTo(0, (UnitResult)another);
    }

    private boolean equalTo(int synthetic, UnitResult<?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.resource.equals(another.resource) && Objects.equals(this.solveResult, another.solveResult) && Objects.equals(this.exception, another.exception);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.resource.hashCode();
        h += (h << 5) + Objects.hashCode(this.solveResult);
        h += (h << 5) + Objects.hashCode(this.exception);
        return h;
    }

    public String toString() {
        return "UnitResult{resource=" + this.resource + ", solveResult=" + this.solveResult + ", exception=" + this.exception + "}";
    }

    public static <TR extends SolverTracer.IResult<TR>> UnitResult<TR> of(String resource, @Nullable SolverResult<TR> solveResult, @Nullable Throwable exception) {
        return new UnitResult<TR>(resource, solveResult, exception);
    }

    public static <TR extends SolverTracer.IResult<TR>> UnitResult<TR> copyOf(AUnitResult<TR> instance) {
        if (instance instanceof UnitResult) {
            return (UnitResult)instance;
        }
        return UnitResult.builder().from(instance).build();
    }

    public static <TR extends SolverTracer.IResult<TR>> Builder<TR> builder() {
        return new Builder();
    }

    /* synthetic */ UnitResult(UnitResult unitResult, String string, SolverResult solverResult, Throwable throwable, UnitResult unitResult2) {
        this(unitResult, string, solverResult, throwable);
    }

    public static final class Builder<TR extends SolverTracer.IResult<TR>> {
        private static final long INIT_BIT_RESOURCE = 1L;
        private long initBits = 1L;
        private String resource;
        private SolverResult<TR> solveResult;
        private Throwable exception;

        private Builder() {
        }

        public final Builder<TR> from(AUnitResult<TR> instance) {
            Throwable exceptionValue;
            Objects.requireNonNull(instance, "instance");
            this.resource(instance.resource());
            SolverResult<TR> solveResultValue = instance.solveResult();
            if (solveResultValue != null) {
                this.solveResult(solveResultValue);
            }
            if ((exceptionValue = instance.exception()) != null) {
                this.exception(exceptionValue);
            }
            return this;
        }

        public final Builder<TR> resource(String resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<TR> solveResult(@Nullable SolverResult<TR> solveResult) {
            this.solveResult = solveResult;
            return this;
        }

        public final Builder<TR> exception(@Nullable Throwable exception) {
            this.exception = exception;
            return this;
        }

        public UnitResult<TR> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UnitResult(null, this.resource, this.solveResult, this.exception, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resource");
            }
            return "Cannot build UnitResult, some of required attributes are not set " + attributes;
        }
    }
}

