/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import io.usethesource.capsule.Map;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import mb.statix.concurrent.AStatixGroup;
import mb.statix.concurrent.IStatixGroup;
import mb.statix.concurrent.IStatixUnit;
import mb.statix.spec.Rule;
import org.metaborg.util.collection.ImList;

public final class StatixGroup
extends AStatixGroup {
    private final String resource;
    private final ImList.Immutable<String> scopeNames;
    private final Rule rule;
    private final boolean changed;
    private final Map.Immutable<String, IStatixGroup> groups;
    private final Map.Immutable<String, IStatixUnit> units;
    private transient int hashCode;

    private StatixGroup(String resource, ImList.Immutable<String> scopeNames, Optional<? extends Rule> rule, boolean changed, Map.Immutable<String, IStatixGroup> groups, Map.Immutable<String, IStatixUnit> units) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.scopeNames = Objects.requireNonNull(scopeNames, "scopeNames");
        this.rule = rule.orElse(null);
        this.changed = changed;
        this.groups = Objects.requireNonNull(groups, "groups");
        this.units = Objects.requireNonNull(units, "units");
    }

    private StatixGroup(StatixGroup original, String resource, ImList.Immutable<String> scopeNames, Rule rule, boolean changed, Map.Immutable<String, IStatixGroup> groups, Map.Immutable<String, IStatixUnit> units) {
        this.resource = resource;
        this.scopeNames = scopeNames;
        this.rule = rule;
        this.changed = changed;
        this.groups = groups;
        this.units = units;
    }

    @Override
    public String resource() {
        return this.resource;
    }

    @Override
    public ImList.Immutable<String> scopeNames() {
        return this.scopeNames;
    }

    @Override
    public Optional<Rule> rule() {
        return Optional.ofNullable(this.rule);
    }

    @Override
    public boolean changed() {
        return this.changed;
    }

    @Override
    public Map.Immutable<String, IStatixGroup> groups() {
        return this.groups;
    }

    @Override
    public Map.Immutable<String, IStatixUnit> units() {
        return this.units;
    }

    public final StatixGroup withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new StatixGroup(this, newValue, this.scopeNames, this.rule, this.changed, this.groups, this.units);
    }

    public final StatixGroup withScopeNames(ImList.Immutable<String> value) {
        if (this.scopeNames == value) {
            return this;
        }
        ImList.Immutable<String> newValue = Objects.requireNonNull(value, "scopeNames");
        return new StatixGroup(this, this.resource, newValue, this.rule, this.changed, this.groups, this.units);
    }

    public final StatixGroup withRule(Rule value) {
        Rule newValue = Objects.requireNonNull(value, "rule");
        if (this.rule == newValue) {
            return this;
        }
        return new StatixGroup(this, this.resource, this.scopeNames, newValue, this.changed, this.groups, this.units);
    }

    public final StatixGroup withRule(Optional<? extends Rule> optional) {
        Rule value = optional.orElse(null);
        if (this.rule == value) {
            return this;
        }
        return new StatixGroup(this, this.resource, this.scopeNames, value, this.changed, this.groups, this.units);
    }

    public final StatixGroup withChanged(boolean value) {
        if (this.changed == value) {
            return this;
        }
        return new StatixGroup(this, this.resource, this.scopeNames, this.rule, value, this.groups, this.units);
    }

    public final StatixGroup withGroups(Map.Immutable<String, IStatixGroup> value) {
        if (this.groups == value) {
            return this;
        }
        Map.Immutable<String, IStatixGroup> newValue = Objects.requireNonNull(value, "groups");
        return new StatixGroup(this, this.resource, this.scopeNames, this.rule, this.changed, newValue, this.units);
    }

    public final StatixGroup withUnits(Map.Immutable<String, IStatixUnit> value) {
        if (this.units == value) {
            return this;
        }
        Map.Immutable<String, IStatixUnit> newValue = Objects.requireNonNull(value, "units");
        return new StatixGroup(this, this.resource, this.scopeNames, this.rule, this.changed, this.groups, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StatixGroup && this.equalTo(0, (StatixGroup)another);
    }

    private boolean equalTo(int synthetic, StatixGroup another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.resource.equals(another.resource) && this.scopeNames.equals(another.scopeNames) && Objects.equals(this.rule, another.rule) && this.changed == another.changed && this.groups.equals(another.groups) && this.units.equals(another.units);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.resource.hashCode();
        h += (h << 5) + this.scopeNames.hashCode();
        h += (h << 5) + Objects.hashCode(this.rule);
        h += (h << 5) + Boolean.hashCode(this.changed);
        h += (h << 5) + this.groups.hashCode();
        h += (h << 5) + this.units.hashCode();
        return h;
    }

    public static StatixGroup of(String resource, ImList.Immutable<String> scopeNames, Optional<? extends Rule> rule, boolean changed, Map.Immutable<String, IStatixGroup> groups, Map.Immutable<String, IStatixUnit> units) {
        return new StatixGroup(resource, scopeNames, rule, changed, groups, units);
    }

    public static StatixGroup copyOf(AStatixGroup instance) {
        if (instance instanceof StatixGroup) {
            return (StatixGroup)instance;
        }
        return StatixGroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ StatixGroup(StatixGroup statixGroup, String string, ImList.Immutable immutable, Rule rule, boolean bl, Map.Immutable immutable2, Map.Immutable immutable3, StatixGroup statixGroup2) {
        this(statixGroup, string, immutable, rule, bl, (Map.Immutable<String, IStatixGroup>)immutable2, (Map.Immutable<String, IStatixUnit>)immutable3);
    }

    public static final class Builder {
        private static final long INIT_BIT_RESOURCE = 1L;
        private static final long INIT_BIT_SCOPE_NAMES = 2L;
        private static final long INIT_BIT_CHANGED = 4L;
        private static final long INIT_BIT_GROUPS = 8L;
        private static final long INIT_BIT_UNITS = 16L;
        private long initBits = 31L;
        private String resource;
        private ImList.Immutable<String> scopeNames;
        private Rule rule;
        private boolean changed;
        private Map.Immutable<String, IStatixGroup> groups;
        private Map.Immutable<String, IStatixUnit> units;

        private Builder() {
        }

        public final Builder from(IStatixGroup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AStatixGroup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            IStatixGroup instance;
            if (object instanceof IStatixGroup) {
                instance = (IStatixGroup)object;
                this.resource(instance.resource());
                Optional<Rule> ruleOptional = instance.rule();
                if (ruleOptional.isPresent()) {
                    this.rule(ruleOptional);
                }
                this.changed(instance.changed());
            }
            if (object instanceof AStatixGroup) {
                instance = (AStatixGroup)object;
                this.groups(((AStatixGroup)instance).groups());
                this.units(((AStatixGroup)instance).units());
                this.scopeNames((ImList.Immutable<String>)((AStatixGroup)instance).scopeNames());
            }
        }

        public final Builder resource(String resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder scopeNames(ImList.Immutable<String> scopeNames) {
            this.scopeNames = Objects.requireNonNull(scopeNames, "scopeNames");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder rule(Rule rule) {
            this.rule = Objects.requireNonNull(rule, "rule");
            return this;
        }

        public final Builder rule(Optional<? extends Rule> rule) {
            this.rule = rule.orElse(null);
            return this;
        }

        public final Builder changed(boolean changed) {
            this.changed = changed;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder groups(Map.Immutable<String, IStatixGroup> groups) {
            this.groups = Objects.requireNonNull(groups, "groups");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder units(Map.Immutable<String, IStatixUnit> units) {
            this.units = Objects.requireNonNull(units, "units");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public StatixGroup build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new StatixGroup(null, this.resource, this.scopeNames, this.rule, this.changed, this.groups, this.units, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resource");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scopeNames");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("changed");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("groups");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("units");
            }
            return "Cannot build StatixGroup, some of required attributes are not set " + attributes;
        }
    }
}

