/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.ITermVar;
import mb.statix.concurrent.ASolverState;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.CriticalEdge;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.solver.completeness.ICompleteness;

public final class SolverState
extends ASolverState
implements Serializable {
    private final IState.Immutable state;
    private final ICompleteness.Immutable completeness;
    private final Set.Immutable<IConstraint> constraints;
    @Nullable
    private final Map.Immutable<ITermVar, ITermVar> existentials;
    private final Set.Immutable<ITermVar> updatedVars;
    private final Map.Immutable<IConstraint, IMessage> failed;
    private final Set.Immutable<CriticalEdge> delayedCloses;
    private transient int hashCode;
    private static final long serialVersionUID = 42L;

    private SolverState(IState.Immutable state, ICompleteness.Immutable completeness, Set.Immutable<IConstraint> constraints, @Nullable Map.Immutable<ITermVar, ITermVar> existentials, Set.Immutable<ITermVar> updatedVars, Map.Immutable<IConstraint, IMessage> failed, Set.Immutable<CriticalEdge> delayedCloses) {
        this.state = Objects.requireNonNull(state, "state");
        this.completeness = Objects.requireNonNull(completeness, "completeness");
        this.constraints = Objects.requireNonNull(constraints, "constraints");
        this.existentials = existentials;
        this.updatedVars = Objects.requireNonNull(updatedVars, "updatedVars");
        this.failed = Objects.requireNonNull(failed, "failed");
        this.delayedCloses = Objects.requireNonNull(delayedCloses, "delayedCloses");
    }

    private SolverState(SolverState original, IState.Immutable state, ICompleteness.Immutable completeness, Set.Immutable<IConstraint> constraints, @Nullable Map.Immutable<ITermVar, ITermVar> existentials, Set.Immutable<ITermVar> updatedVars, Map.Immutable<IConstraint, IMessage> failed, Set.Immutable<CriticalEdge> delayedCloses) {
        this.state = state;
        this.completeness = completeness;
        this.constraints = constraints;
        this.existentials = existentials;
        this.updatedVars = updatedVars;
        this.failed = failed;
        this.delayedCloses = delayedCloses;
    }

    @Override
    public IState.Immutable state() {
        return this.state;
    }

    @Override
    public ICompleteness.Immutable completeness() {
        return this.completeness;
    }

    @Override
    public Set.Immutable<IConstraint> constraints() {
        return this.constraints;
    }

    @Override
    @Nullable
    public Map.Immutable<ITermVar, ITermVar> existentials() {
        return this.existentials;
    }

    @Override
    public Set.Immutable<ITermVar> updatedVars() {
        return this.updatedVars;
    }

    @Override
    public Map.Immutable<IConstraint, IMessage> failed() {
        return this.failed;
    }

    @Override
    public Set.Immutable<CriticalEdge> delayedCloses() {
        return this.delayedCloses;
    }

    public final SolverState withState(IState.Immutable value) {
        if (this.state == value) {
            return this;
        }
        IState.Immutable newValue = Objects.requireNonNull(value, "state");
        return new SolverState(this, newValue, this.completeness, this.constraints, this.existentials, this.updatedVars, this.failed, this.delayedCloses);
    }

    public final SolverState withCompleteness(ICompleteness.Immutable value) {
        if (this.completeness == value) {
            return this;
        }
        ICompleteness.Immutable newValue = Objects.requireNonNull(value, "completeness");
        return new SolverState(this, this.state, newValue, this.constraints, this.existentials, this.updatedVars, this.failed, this.delayedCloses);
    }

    public final SolverState withConstraints(Set.Immutable<IConstraint> value) {
        if (this.constraints == value) {
            return this;
        }
        Set.Immutable<IConstraint> newValue = Objects.requireNonNull(value, "constraints");
        return new SolverState(this, this.state, this.completeness, newValue, this.existentials, this.updatedVars, this.failed, this.delayedCloses);
    }

    public final SolverState withExistentials(@Nullable Map.Immutable<ITermVar, ITermVar> value) {
        if (this.existentials == value) {
            return this;
        }
        return new SolverState(this, this.state, this.completeness, this.constraints, value, this.updatedVars, this.failed, this.delayedCloses);
    }

    public final SolverState withUpdatedVars(Set.Immutable<ITermVar> value) {
        if (this.updatedVars == value) {
            return this;
        }
        Set.Immutable<ITermVar> newValue = Objects.requireNonNull(value, "updatedVars");
        return new SolverState(this, this.state, this.completeness, this.constraints, this.existentials, newValue, this.failed, this.delayedCloses);
    }

    public final SolverState withFailed(Map.Immutable<IConstraint, IMessage> value) {
        if (this.failed == value) {
            return this;
        }
        Map.Immutable<IConstraint, IMessage> newValue = Objects.requireNonNull(value, "failed");
        return new SolverState(this, this.state, this.completeness, this.constraints, this.existentials, this.updatedVars, newValue, this.delayedCloses);
    }

    public final SolverState withDelayedCloses(Set.Immutable<CriticalEdge> value) {
        if (this.delayedCloses == value) {
            return this;
        }
        Set.Immutable<CriticalEdge> newValue = Objects.requireNonNull(value, "delayedCloses");
        return new SolverState(this, this.state, this.completeness, this.constraints, this.existentials, this.updatedVars, this.failed, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SolverState && this.equalTo(0, (SolverState)another);
    }

    private boolean equalTo(int synthetic, SolverState another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.state.equals(another.state) && this.completeness.equals(another.completeness) && this.constraints.equals(another.constraints) && Objects.equals(this.existentials, another.existentials) && this.updatedVars.equals(another.updatedVars) && this.failed.equals(another.failed) && this.delayedCloses.equals(another.delayedCloses);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + this.completeness.hashCode();
        h += (h << 5) + this.constraints.hashCode();
        h += (h << 5) + Objects.hashCode(this.existentials);
        h += (h << 5) + this.updatedVars.hashCode();
        h += (h << 5) + this.failed.hashCode();
        h += (h << 5) + this.delayedCloses.hashCode();
        return h;
    }

    public String toString() {
        return "SolverState{state=" + this.state + ", completeness=" + this.completeness + ", constraints=" + this.constraints + ", existentials=" + this.existentials + ", updatedVars=" + this.updatedVars + ", failed=" + this.failed + ", delayedCloses=" + this.delayedCloses + "}";
    }

    public static SolverState of(IState.Immutable state, ICompleteness.Immutable completeness, Set.Immutable<IConstraint> constraints, @Nullable Map.Immutable<ITermVar, ITermVar> existentials, Set.Immutable<ITermVar> updatedVars, Map.Immutable<IConstraint, IMessage> failed, Set.Immutable<CriticalEdge> delayedCloses) {
        return new SolverState(state, completeness, constraints, existentials, updatedVars, failed, delayedCloses);
    }

    public static SolverState copyOf(ASolverState instance) {
        if (instance instanceof SolverState) {
            return (SolverState)instance;
        }
        return SolverState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ SolverState(SolverState solverState, IState.Immutable immutable, ICompleteness.Immutable immutable2, Set.Immutable immutable3, Map.Immutable immutable4, Set.Immutable immutable5, Map.Immutable immutable6, Set.Immutable immutable7, SolverState solverState2) {
        this(solverState, immutable, immutable2, (Set.Immutable<IConstraint>)immutable3, (Map.Immutable<ITermVar, ITermVar>)immutable4, (Set.Immutable<ITermVar>)immutable5, (Map.Immutable<IConstraint, IMessage>)immutable6, (Set.Immutable<CriticalEdge>)immutable7);
    }

    public static final class Builder {
        private static final long INIT_BIT_STATE = 1L;
        private static final long INIT_BIT_COMPLETENESS = 2L;
        private static final long INIT_BIT_CONSTRAINTS = 4L;
        private static final long INIT_BIT_UPDATED_VARS = 8L;
        private static final long INIT_BIT_FAILED = 16L;
        private static final long INIT_BIT_DELAYED_CLOSES = 32L;
        private long initBits = 63L;
        private IState.Immutable state;
        private ICompleteness.Immutable completeness;
        private Set.Immutable<IConstraint> constraints;
        private Map.Immutable<ITermVar, ITermVar> existentials;
        private Set.Immutable<ITermVar> updatedVars;
        private Map.Immutable<IConstraint, IMessage> failed;
        private Set.Immutable<CriticalEdge> delayedCloses;

        private Builder() {
        }

        public final Builder from(ASolverState instance) {
            Objects.requireNonNull(instance, "instance");
            this.state(instance.state());
            this.completeness(instance.completeness());
            this.constraints(instance.constraints());
            Map.Immutable<ITermVar, ITermVar> existentialsValue = instance.existentials();
            if (existentialsValue != null) {
                this.existentials(existentialsValue);
            }
            this.updatedVars(instance.updatedVars());
            this.failed(instance.failed());
            this.delayedCloses(instance.delayedCloses());
            return this;
        }

        public final Builder state(IState.Immutable state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder completeness(ICompleteness.Immutable completeness) {
            this.completeness = Objects.requireNonNull(completeness, "completeness");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder constraints(Set.Immutable<IConstraint> constraints) {
            this.constraints = Objects.requireNonNull(constraints, "constraints");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder existentials(@Nullable Map.Immutable<ITermVar, ITermVar> existentials) {
            this.existentials = existentials;
            return this;
        }

        public final Builder updatedVars(Set.Immutable<ITermVar> updatedVars) {
            this.updatedVars = Objects.requireNonNull(updatedVars, "updatedVars");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder failed(Map.Immutable<IConstraint, IMessage> failed) {
            this.failed = Objects.requireNonNull(failed, "failed");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder delayedCloses(Set.Immutable<CriticalEdge> delayedCloses) {
            this.delayedCloses = Objects.requireNonNull(delayedCloses, "delayedCloses");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public SolverState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new SolverState(null, this.state, this.completeness, this.constraints, this.existentials, this.updatedVars, this.failed, this.delayedCloses, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("completeness");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("constraints");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("updatedVars");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("failed");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("delayedCloses");
            }
            return "Cannot build SolverState, some of required attributes are not set " + attributes;
        }
    }
}

