/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.schema;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mb.scopegraph.schema.SchemaDecl;
import mb.scopegraph.schema.SchemaEdge;
import org.metaborg.util.tuple.Tuple2;

public class Schema<K, L, M> {
    private final Map<K, Set<SchemaEdge<K, L, M>>> outgoingEdges;
    private final Map<K, Set<SchemaEdge<K, L, M>>> incomingEdges;
    private final Map<K, Set<SchemaDecl<K, L, M>>> decls;
    private final Map<K, Set<Tuple2<SchemaDecl<K, L, M>, Integer>>> declPositions;

    private Schema(Map<K, Set<SchemaEdge<K, L, M>>> incomingEdges, Map<K, Set<SchemaEdge<K, L, M>>> outgoingEdges, Map<K, Set<SchemaDecl<K, L, M>>> decls, Map<K, Set<Tuple2<SchemaDecl<K, L, M>, Integer>>> declPositions) {
        this.incomingEdges = incomingEdges;
        this.outgoingEdges = outgoingEdges;
        this.decls = decls;
        this.declPositions = declPositions;
    }

    public Set<SchemaEdge<K, L, M>> outgoingEdges(K kind) {
        return Collections.unmodifiableSet(this.outgoingEdges.getOrDefault(kind, Collections.emptySet()));
    }

    public Set<SchemaEdge<K, L, M>> incomingEdges(K kind) {
        return Collections.unmodifiableSet(this.incomingEdges.getOrDefault(kind, Collections.emptySet()));
    }

    public Set<SchemaDecl<K, L, M>> decls(K kind) {
        return Collections.unmodifiableSet(this.decls.getOrDefault(kind, Collections.emptySet()));
    }

    public Set<Tuple2<SchemaDecl<K, L, M>, Integer>> declPositions(K kind) {
        return Collections.unmodifiableSet(this.declPositions.getOrDefault(kind, Collections.emptySet()));
    }

    public static <K, L, M> Builder<K, L, M> newBuilder() {
        return new Builder();
    }

    /* synthetic */ Schema(Map map, Map map2, Map map3, Map map4, Schema schema) {
        this(map, map2, map3, map4);
    }

    public static class Builder<K, L, M> {
        private final Map<K, Set<SchemaEdge<K, L, M>>> outgoingEdges = new HashMap<K, Set<SchemaEdge<K, L, M>>>();
        private final Map<K, Set<SchemaEdge<K, L, M>>> incomingEdges = new HashMap<K, Set<SchemaEdge<K, L, M>>>();
        private final Map<K, Set<SchemaDecl<K, L, M>>> decls = new HashMap<K, Set<SchemaDecl<K, L, M>>>();
        private final Map<K, Set<Tuple2<SchemaDecl<K, L, M>, Integer>>> declPositions = new HashMap<K, Set<Tuple2<SchemaDecl<K, L, M>, Integer>>>();

        private Builder() {
        }

        public Builder<K, L, M> addEdge(SchemaEdge<K, L, M> edge) {
            edge.getSources().keySet().forEach(k -> {
                boolean bl = this.outgoingEdges.computeIfAbsent(k, __ -> new HashSet()).add(edge);
            });
            edge.getTargets().keySet().forEach(k -> {
                boolean bl = this.incomingEdges.computeIfAbsent(k, __ -> new HashSet()).add(edge);
            });
            return this;
        }

        public Builder<K, L, M> addDecl(SchemaDecl<K, L, M> decl) {
            decl.getSources().keySet().forEach(k -> {
                boolean bl = this.decls.computeIfAbsent(k, __ -> new HashSet()).add(decl);
            });
            decl.getValueIndices().forEach(idx -> decl.getValuesAt((int)idx).forEach((k, c) -> this.declPositions.computeIfAbsent(k, __ -> new HashSet()).add(Tuple2.of(decl, idx))));
            return this;
        }

        public Schema<K, L, M> build() {
            return new Schema(Collections.unmodifiableMap(this.incomingEdges), Collections.unmodifiableMap(this.outgoingEdges), Collections.unmodifiableMap(this.decls), Collections.unmodifiableMap(this.declPositions), null);
        }
    }
}

