/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.schema;

public abstract class Bound {
    private static final Bound INFINITE = new Infinite();

    public static Bound finite(int n) {
        return new Finite(n);
    }

    public static Bound infinite() {
        return INFINITE;
    }

    public abstract boolean lte(int var1);

    public abstract boolean gte(int var1);

    private static class Finite
    extends Bound {
        private final int value;

        public Finite(int value) {
            this.value = value;
        }

        @Override
        public boolean lte(int n) {
            return n <= this.value;
        }

        @Override
        public boolean gte(int n) {
            return n >= this.value;
        }
    }

    private static class Infinite
    extends Bound {
        private Infinite() {
        }

        @Override
        public boolean lte(int n) {
            return true;
        }

        @Override
        public boolean gte(int n) {
            return false;
        }
    }
}

