/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.resolution;

import io.usethesource.capsule.Map;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import mb.scopegraph.resolution.State;

public class StateMachine<L>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map.Immutable<String, State<L>> states;
    private final State<L> initial;

    public StateMachine(Map.Immutable<String, State<L>> states, State<L> initial) {
        this.states = states;
        this.initial = initial;
    }

    public State<L> initial() {
        return this.initial;
    }

    public State<L> state(String name) {
        State result = (State)this.states.get((Object)name);
        if (result == null) {
            throw new IllegalStateException("Unknown state '" + name + "'.");
        }
        return result;
    }

    public Set<String> stateIds() {
        return this.states.keySet();
    }

    public String toString() {
        return "StateMachine{states=" + this.states + ", initial=" + this.initial + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        StateMachine other = (StateMachine)obj;
        return Objects.equals(this.states, other.states) && Objects.equals(this.initial, other.initial);
    }

    public int hashCode() {
        return Objects.hash(this.states, this.initial);
    }
}

