/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.relations.impl;

import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import mb.scopegraph.relations.ARelationDescription;
import mb.scopegraph.relations.IRelation;
import mb.scopegraph.relations.ReflexivityException;
import mb.scopegraph.relations.RelationDescription;
import mb.scopegraph.relations.RelationException;
import mb.scopegraph.relations.SymmetryException;
import mb.scopegraph.relations.TransitivityException;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.HashTrieRelation2;
import org.metaborg.util.collection.IRelation2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.tuple.Tuple2;

public abstract class Relation<T>
implements IRelation<T> {
    private static final ILogger logger = LoggerUtils.logger(Relation.class);

    protected Relation() {
    }

    @Override
    public boolean isEmpty() {
        return this.entries().isEmpty();
    }

    @Override
    public Set.Immutable<T> smaller(T t) {
        Set.Transient ts = CapsuleUtil.transientSet();
        this.smaller(t, ts, new HashSet());
        if (this.getDescription().getSymmetry().equals((Object)ARelationDescription.Symmetry.SYMMETRIC)) {
            this.larger(t, ts, new HashSet());
        }
        if (this.getDescription().getReflexivity().equals((Object)ARelationDescription.Reflexivity.REFLEXIVE)) {
            ts.__insert(t);
        }
        return ts.freeze();
    }

    private void smaller(T current, Set.Transient<T> ts, Set<T> visited) {
        if (!visited.contains(current)) {
            visited.add(current);
            for (Object next : this.entries().inverse().get(current)) {
                ts.__insert(next);
                if (!this.getDescription().getTransitivity().equals((Object)ARelationDescription.Transitivity.TRANSITIVE)) continue;
                this.smaller(next, ts, visited);
            }
        }
    }

    @Override
    public Set.Immutable<T> larger(T t) {
        Set.Transient ts = CapsuleUtil.transientSet();
        this.larger(t, ts, new HashSet());
        if (this.getDescription().getSymmetry().equals((Object)ARelationDescription.Symmetry.SYMMETRIC)) {
            this.smaller(t, ts, new HashSet());
        }
        if (this.getDescription().getReflexivity().equals((Object)ARelationDescription.Reflexivity.REFLEXIVE)) {
            ts.__insert(t);
        }
        return ts.freeze();
    }

    private void larger(T current, Set.Transient<T> ts, Set<T> visited) {
        if (!visited.contains(current)) {
            visited.add(current);
            for (Object next : this.entries().get(current)) {
                ts.__insert(next);
                if (!this.getDescription().getTransitivity().equals((Object)ARelationDescription.Transitivity.TRANSITIVE)) continue;
                this.larger(next, ts, visited);
            }
        }
    }

    @Override
    public boolean contains(T t1, T t2) {
        boolean hit;
        if (t1.equals(t2)) {
            switch (this.getDescription().getReflexivity()) {
                case REFLEXIVE: {
                    return true;
                }
                case IRREFLEXIVE: {
                    return false;
                }
            }
        }
        if (!(hit = this.contains(t1, t2, new HashSet())) && this.getDescription().getSymmetry().equals((Object)ARelationDescription.Symmetry.SYMMETRIC)) {
            hit |= this.contains(t2, t1, new HashSet());
        }
        return hit;
    }

    private boolean contains(T current, T t, Set<T> visited) {
        if (!visited.contains(current)) {
            visited.add(current);
            return this.entries().get(current).stream().anyMatch(next -> {
                if (next.equals(t)) {
                    return true;
                }
                if (this.getDescription().getTransitivity().equals((Object)ARelationDescription.Transitivity.TRANSITIVE)) {
                    return this.contains(next, t, visited);
                }
                return false;
            });
        }
        return false;
    }

    protected void canAddOrThrow(T t1, T t2) throws RelationException {
        if (t1.equals(t2)) {
            if (this.getDescription().getReflexivity().equals((Object)ARelationDescription.Reflexivity.IRREFLEXIVE)) {
                throw new ReflexivityException("Adding <" + t1 + "," + t2 + "> violates irreflexivity");
            }
        } else {
            if (this.getDescription().getSymmetry().equals((Object)ARelationDescription.Symmetry.ANTI_SYMMETRIC) && this.contains(t2, t1)) {
                throw new SymmetryException("Adding <" + t1 + "," + t2 + "> violates anti-symmetry");
            }
            if (this.getDescription().getTransitivity().equals((Object)ARelationDescription.Transitivity.ANTI_TRANSITIVE)) {
                for (Object t : this.smaller(t2)) {
                    if (!this.contains(t1, t)) continue;
                    throw new TransitivityException("Adding <" + t1 + "," + t2 + "> violates anti-transitivity");
                }
                for (Object t : this.larger(t1)) {
                    if (!this.contains(t, t2)) continue;
                    throw new TransitivityException("Adding <" + t1 + "," + t2 + "> violates anti-transitivity");
                }
            }
        }
    }

    @Override
    public Optional<T> leastUpperBound(T t1, T t2) {
        if (!this.getDescription().equals(RelationDescription.PARTIAL_ORDER)) {
            logger.warn("Lub must be called on partial-order, ignored.");
            return Optional.empty();
        }
        HashSet<T> bounds = new HashSet<T>();
        bounds.addAll((Collection<T>)this.larger(t1));
        bounds.retainAll((Collection<?>)this.larger(t2));
        return bounds.stream().filter(l -> bounds.stream().allMatch(g -> this.contains(l, g))).findFirst();
    }

    @Override
    public Optional<T> greatestLowerBound(T t1, T t2) {
        if (!this.getDescription().equals(RelationDescription.PARTIAL_ORDER)) {
            logger.warn("Glb must be called on partial-order, ignored.");
            return Optional.empty();
        }
        HashSet<T> bounds = new HashSet<T>();
        bounds.addAll((Collection<T>)this.smaller(t1));
        bounds.retainAll((Collection<?>)this.smaller(t2));
        return bounds.stream().filter(g -> bounds.stream().allMatch(l -> this.contains(l, g))).findFirst();
    }

    @Override
    public Stream<Tuple2<T, T>> stream() {
        return this.entries().stream();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDescription()).append(" { ");
        this.stream().forEach(entry -> {
            sb.append(entry._1());
            sb.append(" < ");
            sb.append(entry._2());
            sb.append("; ");
        });
        sb.append("}");
        return sb.toString();
    }

    public static class Immutable<T>
    extends Relation<T>
    implements IRelation.Immutable<T>,
    Serializable {
        private static final long serialVersionUID = 42L;
        protected final RelationDescription description;
        protected final IRelation2.Immutable<T, T> entries;

        public Immutable(RelationDescription description, IRelation2.Immutable<T, T> entries) {
            this.description = description;
            this.entries = entries;
        }

        @Override
        public RelationDescription getDescription() {
            return this.description;
        }

        @Override
        public IRelation2<T, T> entries() {
            return this.entries;
        }

        @Override
        public IRelation.Transient<T> melt() {
            return new Transient<T>(this.description, this.entries.melt());
        }

        public static <T> Immutable<T> of(RelationDescription description) {
            return new Immutable(description, HashTrieRelation2.Immutable.of());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.description.hashCode();
            result = 31 * result + this.entries.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Immutable other = (Immutable)obj;
            if (!this.description.equals(other.description)) {
                return false;
            }
            return this.entries.equals(other.entries);
        }
    }

    public static class Transient<T>
    extends Relation<T>
    implements IRelation.Transient<T> {
        protected final RelationDescription description;
        protected final IRelation2.Transient<T, T> entries;

        public Transient(RelationDescription description, IRelation2.Transient<T, T> entries) {
            this.description = description;
            this.entries = entries;
        }

        @Override
        public RelationDescription getDescription() {
            return this.description;
        }

        @Override
        public IRelation2<T, T> entries() {
            return this.entries;
        }

        @Override
        public boolean add(T t1, T t2) throws RelationException {
            this.canAddOrThrow(t1, t2);
            return this.entries.put(t1, t2);
        }

        @Override
        public IRelation.Immutable<T> freeze() {
            return new Immutable<T>(this.description, this.entries.freeze());
        }

        public static <T> IRelation.Transient<T> of(RelationDescription description) {
            return new Transient(description, HashTrieRelation2.Transient.of());
        }
    }
}

