/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.regexp.impl;

import java.util.function.Supplier;
import mb.scopegraph.regexp.IAlphabet;
import mb.scopegraph.regexp.IRegExp;
import mb.scopegraph.regexp.IRegExpBuilder;
import mb.scopegraph.regexp.impl.RegExpBuilder;
import mb.scopegraph.regexp.impl.RegExpCases;

public final class RegExpNormalizingBuilder<S>
implements IRegExpBuilder<S> {
    private final IAlphabet<S> alphabet;
    private final IRegExpBuilder<S> builder;

    public RegExpNormalizingBuilder(IAlphabet<S> alphabet) {
        this(alphabet, new RegExpBuilder());
    }

    public RegExpNormalizingBuilder(IAlphabet<S> alphabet, IRegExpBuilder<S> builder) {
        this.alphabet = alphabet;
        this.builder = builder;
    }

    @Override
    public IRegExp<S> emptySet() {
        return (IRegExp)this.builder.emptySet();
    }

    @Override
    public IRegExp<S> emptyString() {
        return (IRegExp)this.builder.emptyString();
    }

    @Override
    public IRegExp<S> symbol(S s) {
        if (!this.alphabet.contains(s)) {
            throw new IllegalArgumentException("Encountered unknown symbol " + s);
        }
        return (IRegExp)this.builder.symbol(s);
    }

    @Override
    public IRegExp<S> concat(IRegExp<S> _left, IRegExp<S> _right) {
        IRegExp left = (IRegExp)_left.match(this);
        IRegExp right = (IRegExp)_right.match(this);
        return left.match(new RegExpCases().emptySet(() -> this.emptySet()).emptyString(() -> right).concat((innerLeft, innerRight) -> this.concat((IRegExp)innerLeft, (IRegExp)this.concat((IRegExp)innerRight, right))).otherwise(() -> right.match(new RegExpCases().emptySet(() -> this.emptySet()).emptyString(() -> left).otherwise(() -> (IRegExp)this.builder.concat(left, right)))));
    }

    @Override
    public IRegExp<S> closure(IRegExp<S> _re) {
        IRegExp re = (IRegExp)_re.match(this);
        return re.match(new RegExpCases().emptySet(() -> this.emptyString()).emptyString(() -> this.emptyString()).closure((? super IRegExp<S> innerRe) -> (IRegExp)this.builder.closure((IRegExp<S>)innerRe)).otherwise(() -> (IRegExp)this.builder.closure(re)));
    }

    @Override
    public IRegExp<S> or(IRegExp<S> _left, IRegExp<S> _right) {
        IRegExp right;
        IRegExp left = (IRegExp)_left.match(this);
        if (left.equals(right = (IRegExp)_right.match(this))) {
            return left;
        }
        Supplier<IRegExp> otherwise = () -> right.match(new RegExpCases().or((innerLeft, innerRight) -> this.compare(left, (IRegExp<S>)innerLeft) > 0 ? this.or((IRegExp)innerLeft, (IRegExp)this.or(left, (IRegExp)innerRight)) : (IRegExp)this.builder.or(left, (IRegExp)this.builder.or((IRegExp<S>)innerLeft, (IRegExp<S>)innerRight))).otherwise(() -> this.compare(left, right) > 0 ? this.or(right, left) : (IRegExp)this.builder.or(left, right)));
        return left.match(new RegExpCases().emptySet(() -> right).or((innerLeft, innerRight) -> this.or((IRegExp)innerLeft, (IRegExp)this.or((IRegExp)innerRight, right))).complement((? super IRegExp<S> innerRe) -> innerRe.match(new RegExpCases().emptySet(() -> left).otherwise(otherwise))).otherwise(otherwise));
    }

    @Override
    public IRegExp<S> and(IRegExp<S> _left, IRegExp<S> _right) {
        IRegExp right;
        IRegExp left = (IRegExp)_left.match(this);
        if (left.equals(right = (IRegExp)_right.match(this))) {
            return left;
        }
        Supplier<IRegExp> otherwise = () -> right.match(new RegExpCases().and((innerLeft, innerRight) -> this.compare(left, (IRegExp<S>)innerLeft) > 0 ? this.and((IRegExp)innerLeft, (IRegExp)this.and(left, (IRegExp)innerRight)) : (IRegExp)this.builder.and(left, (IRegExp)this.builder.and((IRegExp<S>)innerLeft, (IRegExp<S>)innerRight))).otherwise(() -> this.compare(left, right) > 0 ? this.and(right, left) : (IRegExp)this.builder.and(left, right)));
        return left.match(new RegExpCases().emptySet(() -> this.emptySet()).and((innerLeft, innerRight) -> this.and((IRegExp)innerLeft, (IRegExp)this.and((IRegExp)innerRight, right))).complement((? super IRegExp<S> innerRe) -> innerRe.match(new RegExpCases().emptySet(() -> right).otherwise(otherwise))).otherwise(otherwise));
    }

    @Override
    public IRegExp<S> complement(IRegExp<S> _re) {
        IRegExp re = (IRegExp)_re.match(this);
        return re.match(new RegExpCases().complement((? super IRegExp<S> innerRe) -> innerRe).otherwise(() -> (IRegExp)this.builder.complement(re)));
    }

    private int compare(IRegExp<S> re1, IRegExp<S> re2) {
        Supplier<Integer> defaultValue = () -> this.order(re1) - this.order(re2);
        return re1.match(new RegExpCases().concat((left1, right1) -> re2.match(new RegExpCases().concat((left2, right2) -> {
            int c = this.compare((IRegExp<S>)left1, (IRegExp<S>)left2);
            if (c == 0) {
                c = this.compare((IRegExp<S>)right1, (IRegExp<S>)right2);
            }
            return c;
        }).otherwise(defaultValue))).closure((? super IRegExp<S> innerRe1) -> re2.match(new RegExpCases().closure((? super IRegExp<S> innerRe2) -> this.compare((IRegExp<S>)innerRe1, (IRegExp<S>)innerRe2)).otherwise(defaultValue))).or((left1, right1) -> re2.match(new RegExpCases().or((left2, right2) -> {
            int c = this.compare((IRegExp<S>)left1, (IRegExp<S>)left2);
            if (c == 0) {
                c = this.compare((IRegExp<S>)right1, (IRegExp<S>)right2);
            }
            return c;
        }).otherwise(defaultValue))).and((left1, right1) -> re2.match(new RegExpCases().and((left2, right2) -> {
            int c = this.compare((IRegExp<S>)left1, (IRegExp<S>)left2);
            if (c == 0) {
                c = this.compare((IRegExp<S>)right1, (IRegExp<S>)right2);
            }
            return c;
        }).otherwise(defaultValue))).complement((? super IRegExp<S> innerRe1) -> re2.match(new RegExpCases().complement((? super IRegExp<S> innerRe2) -> this.compare((IRegExp<S>)innerRe1, (IRegExp<S>)innerRe2)).otherwise(defaultValue))).otherwise(defaultValue));
    }

    private int order(IRegExp<S> re) {
        return re.match(RegExpCases.of(() -> 1, () -> 2, s -> 8 + this.alphabet.indexOf(s), (left, right) -> 4, innerRe -> 5, (left, right) -> 6, (left, right) -> 6, innerRe -> 7));
    }
}

