/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20.reference;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import java.util.Optional;
import java.util.Set;
import mb.scopegraph.oopsla20.INameResolution;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.reference.DataLeq;
import mb.scopegraph.oopsla20.reference.DataWF;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.oopsla20.reference.Env;
import mb.scopegraph.oopsla20.reference.IncompleteException;
import mb.scopegraph.oopsla20.reference.LabelOrder;
import mb.scopegraph.oopsla20.reference.LabelWF;
import mb.scopegraph.oopsla20.reference.ResolutionException;
import mb.scopegraph.oopsla20.terms.newPath.ResolutionPath;
import mb.scopegraph.oopsla20.terms.newPath.ScopePath;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Predicate2;
import org.metaborg.util.task.ICancel;

public class NameResolution<S extends D, L, D>
implements INameResolution<S, L, D> {
    private final IScopeGraph<S, L, D> scopeGraph;
    private final EdgeOrData<L> dataLabel;
    private final Set<EdgeOrData<L>> allLabels;
    private final LabelWF<L> labelWF;
    private final LabelOrder<L> labelOrder;
    private final DataWF<D> dataWF;
    private final DataLeq<D> dataEquiv;
    private final Predicate2<S, EdgeOrData<L>> isComplete;

    public NameResolution(IScopeGraph<S, L, D> scopeGraph, Set<L> edgeLabels, LabelWF<L> labelWF, LabelOrder<L> labelOrder, DataWF<D> dataWF, DataLeq<D> dataEquiv, Predicate2<S, EdgeOrData<L>> isComplete) {
        this.scopeGraph = scopeGraph;
        this.dataLabel = EdgeOrData.data();
        this.allLabels = ((Set.Immutable)edgeLabels.stream().map(EdgeOrData::edge).collect(CapsuleCollectors.toSet())).__insert(this.dataLabel);
        this.labelWF = labelWF;
        this.labelOrder = labelOrder;
        this.dataWF = dataWF;
        this.dataEquiv = dataEquiv;
        this.isComplete = isComplete;
    }

    @Override
    public Env<S, L, D> resolve(S scope, ICancel cancel) throws ResolutionException, InterruptedException {
        return this.env(this.labelWF, new ScopePath(scope), cancel);
    }

    private Env<S, L, D> env(LabelWF<L> re, ScopePath<S, L> path, ICancel cancel) throws ResolutionException, InterruptedException {
        return this.env_L(this.allLabels, re, path, cancel);
    }

    private Env<S, L, D> env_L(Set<EdgeOrData<L>> L2, LabelWF<L> re, ScopePath<S, L> path, ICancel cancel) throws ResolutionException, InterruptedException {
        cancel.throwIfCancelled();
        Env.Builder env = Env.builder();
        Set<EdgeOrData<L>> max_L = this.max(L2);
        for (EdgeOrData<L> l : max_L) {
            Env<S, L, D> env1 = this.env_L(this.smaller(L2, l), re, path, cancel);
            env.addAll(env1);
            if (!env1.isEmpty() && this.dataEquiv.alwaysTrue()) continue;
            Env<S, L, D> env2 = this.env_l(l, re, path, cancel);
            env.addAll(this.minus(env2, env1));
        }
        return env.build();
    }

    private Set<EdgeOrData<L>> max(Set<EdgeOrData<L>> L2) throws ResolutionException, InterruptedException {
        Set.Transient max2 = CapsuleUtil.transientSet();
        block0: for (EdgeOrData<L> l1 : L2) {
            for (EdgeOrData<L> l2 : L2) {
                if (this.labelOrder.lt(l1, l2)) continue block0;
            }
            max2.__insert(l1);
        }
        return max2.freeze();
    }

    private Set<EdgeOrData<L>> smaller(Set<EdgeOrData<L>> L2, EdgeOrData<L> l1) throws ResolutionException, InterruptedException {
        Set.Transient smaller = CapsuleUtil.transientSet();
        for (EdgeOrData<L> l2 : L2) {
            if (!this.labelOrder.lt(l2, l1)) continue;
            smaller.__insert(l2);
        }
        return smaller.freeze();
    }

    private Env<S, L, D> minus(Env<S, L, D> env1, Env<S, L, D> env2) throws ResolutionException, InterruptedException {
        Env.Builder<S, L, D> env = Env.builder();
        block0: for (ResolutionPath<S, L, D> p1 : env1) {
            for (ResolutionPath<S, L, D> p2 : env2) {
                if (this.dataEquiv.leq(p2.getDatum(), p1.getDatum())) continue block0;
            }
            env.add(p1);
        }
        return env.build();
    }

    private Env<S, L, D> env_l(EdgeOrData<L> l, LabelWF<L> re, ScopePath<S, L> path, ICancel cancel) throws ResolutionException, InterruptedException {
        return l.matchInResolution(() -> this.env_data(re, path), lbl -> this.env_edges(lbl, re, path, cancel));
    }

    private Env<S, L, D> env_data(LabelWF<L> re, ScopePath<S, L> path) throws ResolutionException, InterruptedException {
        if (!re.accepting()) {
            return Env.empty();
        }
        if (!this.isComplete.test(path.getTarget(), this.dataLabel)) {
            throw new IncompleteException(path.getTarget(), this.dataLabel);
        }
        Object datum = this.getData(re, path).orElse(null);
        if (datum == null || !this.dataWF.wf(datum)) {
            return Env.empty();
        }
        return Env.of(path.resolve(datum));
    }

    private Env<S, L, D> env_edges(L l, LabelWF<L> re, ScopePath<S, L> path, ICancel cancel) throws ResolutionException, InterruptedException {
        Optional<LabelWF<L>> newRe = re.step(l);
        if (!newRe.isPresent()) {
            return Env.empty();
        }
        re = newRe.get();
        EdgeOrData<L> edgeLabel = EdgeOrData.edge(l);
        if (!this.isComplete.test(path.getTarget(), edgeLabel)) {
            throw new IncompleteException(path.getTarget(), edgeLabel);
        }
        Env.Builder env = Env.builder();
        for (S nextScope : this.getEdges(re, path, l)) {
            Optional<ScopePath<S, L>> p = path.step(l, nextScope);
            if (!p.isPresent()) continue;
            env.addAll(this.env(re, p.get(), cancel));
        }
        return env.build();
    }

    protected Optional<D> getData(LabelWF<L> re, ScopePath<S, L> path) {
        return this.scopeGraph.getData(path.getTarget());
    }

    protected Iterable<S> getEdges(LabelWF<L> re, ScopePath<S, L> path, L l) {
        return this.scopeGraph.getEdges(path.getTarget(), l);
    }

    public static <S extends D, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    public static class Builder<S extends D, L, D>
    implements INameResolution.Builder<S, L, D> {
        private LabelWF<L> labelWF = LabelWF.ANY();
        private LabelOrder<L> labelOrder = LabelOrder.NONE();
        private DataWF<D> dataWF = DataWF.ANY();
        private DataLeq<D> dataEquiv = DataLeq.ALL();
        private Predicate2<S, EdgeOrData<L>> isComplete = (s, l) -> true;

        @Override
        public Builder<S, L, D> withLabelWF(LabelWF<L> labelWF) {
            this.labelWF = labelWF;
            return this;
        }

        @Override
        public Builder<S, L, D> withLabelOrder(LabelOrder<L> labelOrder) {
            this.labelOrder = labelOrder;
            return this;
        }

        @Override
        public Builder<S, L, D> withDataWF(DataWF<D> dataWF) {
            this.dataWF = dataWF;
            return this;
        }

        @Override
        public Builder<S, L, D> withDataEquiv(DataLeq<D> dataEquiv) {
            this.dataEquiv = dataEquiv;
            return this;
        }

        @Override
        public Builder<S, L, D> withIsComplete(Predicate2<S, EdgeOrData<L>> isComplete) {
            this.isComplete = isComplete;
            return this;
        }

        @Override
        public NameResolution<S, L, D> build(IScopeGraph<S, L, D> scopeGraph, Set<L> edgeLabels) {
            return new NameResolution<S, L, D>(scopeGraph, edgeLabels, this.labelWF, this.labelOrder, this.dataWF, this.dataEquiv, this.isComplete);
        }
    }
}

