/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.match;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.match.AllResourceMatcher;
import mb.resource.hierarchical.match.AnyResourceMatcher;
import mb.resource.hierarchical.match.DirectoryResourceMatcher;
import mb.resource.hierarchical.match.FalseResourceMatcher;
import mb.resource.hierarchical.match.FileResourceMatcher;
import mb.resource.hierarchical.match.NotResourceMatcher;
import mb.resource.hierarchical.match.PathResourceMatcher;
import mb.resource.hierarchical.match.TrueResourceMatcher;
import mb.resource.hierarchical.match.path.PathMatcher;

@FunctionalInterface
public interface ResourceMatcher
extends Serializable {
    public boolean matches(HierarchicalResource var1, HierarchicalResource var2) throws IOException;

    public static TrueResourceMatcher ofTrue() {
        return new TrueResourceMatcher();
    }

    public static FalseResourceMatcher ofFalse() {
        return new FalseResourceMatcher();
    }

    public static AllResourceMatcher ofAll(ResourceMatcher ... matchers) {
        return new AllResourceMatcher(matchers);
    }

    public static AnyResourceMatcher ofAny(ResourceMatcher ... matchers) {
        return new AnyResourceMatcher(matchers);
    }

    public static NotResourceMatcher ofNot(ResourceMatcher matcher) {
        return new NotResourceMatcher(matcher);
    }

    public static PathResourceMatcher ofPath(PathMatcher matcher) {
        return new PathResourceMatcher(matcher);
    }

    public static DirectoryResourceMatcher ofDirectory() {
        return new DirectoryResourceMatcher();
    }

    public static FileResourceMatcher ofFile() {
        return new FileResourceMatcher();
    }

    default public NotResourceMatcher not() {
        return new NotResourceMatcher(this);
    }

    default public AllResourceMatcher and(ResourceMatcher ... matchers) {
        ArrayList<ResourceMatcher> allMatchers = new ArrayList<ResourceMatcher>(matchers.length + 1);
        allMatchers.add(this);
        Collections.addAll(allMatchers, matchers);
        return new AllResourceMatcher(allMatchers);
    }

    default public AnyResourceMatcher or(ResourceMatcher ... matchers) {
        ArrayList<ResourceMatcher> anyMatchers = new ArrayList<ResourceMatcher>(matchers.length + 1);
        anyMatchers.add(this);
        Collections.addAll(anyMatchers, matchers);
        return new AnyResourceMatcher(anyMatchers);
    }

    public static ResourceMatcher ofFileExtension(String extension) {
        return ResourceMatcher.ofPath(PathMatcher.ofExtension(extension)).and(ResourceMatcher.ofFile());
    }

    public static ResourceMatcher ofFileExtensions(String ... extensions) {
        return ResourceMatcher.ofPath(PathMatcher.ofExtensions(extensions)).and(ResourceMatcher.ofFile());
    }
}

