/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import mb.resource.ResourceKey;
import mb.resource.hierarchical.FilenameExtensionUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ResourcePath
extends ResourceKey,
Comparable<ResourcePath> {
    public boolean isAbsolute();

    public int getSegmentCount();

    public Iterable<String> getSegments();

    public boolean startsWith(ResourcePath var1);

    public @Nullable ResourcePath getParent();

    public @Nullable ResourcePath getRoot();

    public @Nullable String getLeaf();

    default public @Nullable String getLeafFileExtension() {
        @Nullable String leaf = this.getLeaf();
        if (leaf != null) {
            return FilenameExtensionUtil.getExtension(leaf);
        }
        return null;
    }

    default public @Nullable String getLeafWithoutFileExtension() {
        @Nullable String leaf = this.getLeaf();
        if (leaf != null) {
            return FilenameExtensionUtil.removeExtension(leaf);
        }
        return null;
    }

    public ResourcePath getNormalized();

    public String relativize(ResourcePath var1);

    public ResourcePath appendSegment(String var1);

    public ResourcePath appendSegments(Iterable<String> var1);

    public ResourcePath appendSegments(Collection<String> var1);

    public ResourcePath appendSegments(List<String> var1);

    public ResourcePath appendSegments(String ... var1);

    public ResourcePath appendAsRelativePath(String var1);

    public ResourcePath appendRelativePath(String var1);

    public ResourcePath appendOrReplaceWithPath(String var1);

    @Deprecated
    public ResourcePath appendString(String var1);

    public ResourcePath appendRelativePath(ResourcePath var1);

    public ResourcePath appendOrReplaceWithPath(ResourcePath var1);

    public ResourcePath replaceLeaf(String var1);

    public ResourcePath appendToLeaf(String var1);

    public ResourcePath applyToLeaf(Function<String, String> var1);

    public ResourcePath replaceLeafExtension(String var1);

    public ResourcePath ensureLeafExtension(String var1);

    public ResourcePath removeLeafExtension();

    public ResourcePath appendToLeafExtension(String var1);

    public ResourcePath applyToLeafExtension(Function<String, String> var1);

    @Override
    public String toString();
}

