/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import mb.pie.api.ExecContext;
import mb.pie.api.STask;
import mb.pie.api.Supplier;
import mb.pie.api.stamp.OutputStamper;
import mb.pie.api.stamp.output.OutputStampers;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SupplierWithOrigin<T extends Serializable>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private final Supplier<?> origin;

    public SupplierWithOrigin(Supplier<T> supplier, Supplier<?> origin) {
        this.supplier = supplier;
        this.origin = origin;
    }

    @Override
    public T get(ExecContext context) {
        if (this.origin instanceof STask) {
            context.require((STask)this.origin, (OutputStamper)OutputStampers.inconsequential());
        } else {
            context.require(this.origin);
        }
        return context.require(this.supplier);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupplierWithOrigin that = (SupplierWithOrigin)o;
        if (!this.supplier.equals(that.supplier)) {
            return false;
        }
        return this.origin.equals(that.origin);
    }

    public int hashCode() {
        int result = this.supplier.hashCode();
        result = 31 * result + this.origin.hashCode();
        return result;
    }

    public String toString() {
        return "SupplierWithOrigin{supplier=" + this.supplier + ", origin=" + this.origin + '}';
    }
}

