/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.nameresolution.tracing;

import io.usethesource.capsule.Set;
import java.util.Objects;
import java.util.Set;
import mb.p_raffrayi.IRecordedQuery;
import mb.p_raffrayi.impl.RecordedQuery;
import mb.p_raffrayi.nameresolution.tracing.ExtQuerySet;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.collection.CapsuleUtil;

@Value.Immutable(builder=false)
@Serial.Version(value=42L)
public abstract class AExtQuerySet<S, L, D> {
    @Value.Parameter
    public abstract Set.Immutable<IRecordedQuery<S, L, D>> transitiveQueries();

    @Value.Parameter
    public abstract Set.Immutable<IRecordedQuery<S, L, D>> predicateQueries();

    public ExtQuerySet<S, L, D> addTransitiveQueries(Set<IRecordedQuery<S, L, D>> transitiveQueries) {
        ExtQuerySet self = (ExtQuerySet)this;
        if (transitiveQueries.isEmpty()) {
            return self;
        }
        Builder<S, L, D> builder = AExtQuerySet.builder().from(self);
        builder.addAllTransitiveQueries(transitiveQueries);
        return builder.build();
    }

    public ExtQuerySet<S, L, D> addPredicateQueries(Set<IRecordedQuery<S, L, D>> predicateQueries) {
        ExtQuerySet self = (ExtQuerySet)this;
        if (predicateQueries.isEmpty()) {
            return self;
        }
        Builder<S, L, D> builder = AExtQuerySet.builder().from(self);
        builder.addAllPredicateQueries(predicateQueries);
        return builder.build();
    }

    public ExtQuerySet<S, L, D> addQueries(Set<IRecordedQuery<S, L, D>> transitiveQueries, Set<IRecordedQuery<S, L, D>> predicateQueries) {
        ExtQuerySet self = (ExtQuerySet)this;
        if (transitiveQueries.isEmpty() && predicateQueries.isEmpty()) {
            return self;
        }
        Builder<S, L, D> builder = AExtQuerySet.builder().from(self);
        builder.addAllTransitiveQueries(transitiveQueries);
        builder.addAllPredicateQueries(predicateQueries);
        return builder.build();
    }

    public static <L, S, D> Builder builder() {
        return new Builder();
    }

    public ExtQuerySet<S, L, D> addQueries(ExtQuerySet<S, L, D> queries) {
        return this.addQueries((Set<IRecordedQuery<S, L, D>>)queries.transitiveQueries(), (Set<IRecordedQuery<S, L, D>>)queries.predicateQueries());
    }

    public static final class Builder<S, L, D> {
        private Set.Transient<IRecordedQuery<S, L, D>> transitiveQueries = CapsuleUtil.transientSet();
        private Set.Transient<IRecordedQuery<S, L, D>> predicateQueries = CapsuleUtil.transientSet();
        private AExtQuerySet<S, L, D> frozen = null;

        private Builder() {
        }

        public final Builder<S, L, D> from(AExtQuerySet<S, L, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllTransitiveQueries((Set<IRecordedQuery<S, L, D>>)instance.transitiveQueries());
            this.addAllPredicateQueries((Set<IRecordedQuery<S, L, D>>)instance.predicateQueries());
            return this;
        }

        public Builder<S, L, D> addAllPredicateQueries(Set<IRecordedQuery<S, L, D>> predicateQueries) {
            this.predicateQueries.__insertAll(predicateQueries);
            return this;
        }

        public Builder<S, L, D> addAllTransitiveQueries(Set<IRecordedQuery<S, L, D>> transitiveQueries) {
            this.transitiveQueries.__insertAll(transitiveQueries);
            return this;
        }

        public final Builder<S, L, D> transitiveQueries(Set.Transient<IRecordedQuery<S, L, D>> transitiveQueries) {
            this.transitiveQueries = Objects.requireNonNull(transitiveQueries, "transitiveQueries");
            return this;
        }

        public final Builder<S, L, D> predicateQueries(Set.Transient<IRecordedQuery<S, L, D>> predicateQueries) {
            this.predicateQueries = Objects.requireNonNull(predicateQueries, "predicateQueries");
            return this;
        }

        public ExtQuerySet<S, L, D> build() {
            return ExtQuerySet.of(this.transitiveQueries.freeze(), this.predicateQueries.freeze());
        }

        public Builder<S, L, D> addTransitiveQueries(RecordedQuery<S, L, D> transitiveQuery) {
            this.transitiveQueries.__insert(transitiveQuery);
            return this;
        }
    }
}

