/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mb.p_raffrayi.IIncrementalTypeCheckerContext;
import mb.p_raffrayi.IRecordedQuery;
import mb.p_raffrayi.ITypeChecker;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.actors.IActor;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.impl.AbstractUnit;
import mb.p_raffrayi.impl.IProcess;
import mb.p_raffrayi.impl.IQueryAnswer;
import mb.p_raffrayi.impl.IUnit;
import mb.p_raffrayi.impl.IUnitContext;
import mb.p_raffrayi.impl.PhantomUnit;
import mb.p_raffrayi.impl.Release;
import mb.p_raffrayi.impl.Result;
import mb.p_raffrayi.impl.ScopeGraphLibraryUnit;
import mb.p_raffrayi.impl.StateCapture;
import mb.p_raffrayi.impl.StateSummary;
import mb.p_raffrayi.impl.UnitState;
import mb.p_raffrayi.impl.confirm.ConfirmResult;
import mb.p_raffrayi.impl.confirm.IConfirmation;
import mb.p_raffrayi.impl.confirm.IConfirmationContext;
import mb.p_raffrayi.impl.confirm.IConfirmationFactory;
import mb.p_raffrayi.impl.confirm.OptimisticConfirmation;
import mb.p_raffrayi.impl.diff.AddingDiffer;
import mb.p_raffrayi.impl.diff.IDifferContext;
import mb.p_raffrayi.impl.diff.IDifferDataOps;
import mb.p_raffrayi.impl.diff.IDifferOps;
import mb.p_raffrayi.impl.diff.IScopeGraphDiffer;
import mb.p_raffrayi.impl.diff.MatchingDiffer;
import mb.p_raffrayi.impl.diff.ScopeDiff;
import mb.p_raffrayi.impl.diff.ScopeGraphDiffer;
import mb.p_raffrayi.impl.diff.StaticDifferContext;
import mb.p_raffrayi.impl.envdiff.EnvDiffer;
import mb.p_raffrayi.impl.envdiff.IEnvDiff;
import mb.p_raffrayi.impl.envdiff.IEnvDiffer;
import mb.p_raffrayi.impl.envdiff.IEnvDifferContext;
import mb.p_raffrayi.impl.envdiff.IndexedEnvDiffer;
import mb.p_raffrayi.impl.tokens.CloseLabel;
import mb.p_raffrayi.impl.tokens.CloseScope;
import mb.p_raffrayi.impl.tokens.Confirm;
import mb.p_raffrayi.impl.tokens.DifferState;
import mb.p_raffrayi.impl.tokens.EnvDifferState;
import mb.p_raffrayi.impl.tokens.IWaitFor;
import mb.p_raffrayi.impl.tokens.InitScope;
import mb.p_raffrayi.impl.tokens.Query;
import mb.p_raffrayi.nameresolution.DataLeq;
import mb.p_raffrayi.nameresolution.DataWf;
import mb.p_raffrayi.nameresolution.IQuery;
import mb.p_raffrayi.nameresolution.NameResolutionQuery;
import mb.p_raffrayi.nameresolution.StateMachineQuery;
import mb.scopegraph.ecoop21.LabelOrder;
import mb.scopegraph.ecoop21.LabelWf;
import mb.scopegraph.library.IScopeGraphLibrary;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.path.IResolutionPath;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.oopsla20.reference.ScopeGraph;
import mb.scopegraph.oopsla20.terms.newPath.ScopePath;
import mb.scopegraph.patching.IPatchCollection;
import mb.scopegraph.patching.PatchCollection;
import mb.scopegraph.patching.Patcher;
import mb.scopegraph.resolution.StateMachine;
import org.metaborg.util.Ref;
import org.metaborg.util.collection.BiMap;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.MultiSet;
import org.metaborg.util.collection.MultiSetMap;
import org.metaborg.util.collection.SetMultimap;
import org.metaborg.util.collection.Sets;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.functions.Function2;
import org.metaborg.util.future.AggregateFuture;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.ICompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.unit.Unit;

class TypeCheckerUnit<S, L, D, R extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>>
extends AbstractUnit<S, L, D, Result<S, L, D, R, T>>
implements IIncrementalTypeCheckerContext<S, L, D, R, T> {
    private static final ILogger logger = LoggerUtils.logger(TypeCheckerUnit.class);
    private final ITypeChecker<S, L, D, R, T> typeChecker;
    private final boolean changed;
    @Nullable
    private final IUnitResult<S, L, D, Result<S, L, D, R, T>> previousResult;
    private volatile UnitState state;
    private final IPatchCollection.Transient<S> matchedBySharing = PatchCollection.Transient.of();
    private final Ref<IScopeGraph.Immutable<S, L, D>> localScopeGraph = new Ref(ScopeGraph.Immutable.of());
    private final Set.Transient<String> addedUnitIds = CapsuleUtil.transientSet();
    private final Ref<StateCapture<S, L, D, T>> localCapture = new Ref();
    private final ICompletableFuture<Unit> whenActive = new CompletableFuture<Unit>();
    private final ICompletableFuture<Unit> whenContextActivated = new CompletableFuture<Unit>();
    private IEnvDiffer<S, L, D> envDiffer;
    private final IPatchCollection.Transient<S> externalMatches = PatchCollection.Transient.of();
    private final IConfirmationFactory<S, L, D> confirmation;
    private final ICompletableFuture<Optional<IPatchCollection.Immutable<S>>> confirmationResult = new CompletableFuture<Optional<IPatchCollection.Immutable<S>>>();
    private final IPatchCollection.Transient<S> resultPatches = PatchCollection.Transient.of();
    private final IPatchCollection.Transient<S> globalPatches = PatchCollection.Transient.of();
    private final Set.Transient<IRecordedQuery<S, L, D>> addedQueries = CapsuleUtil.transientSet();
    private final Set.Transient<IRecordedQuery<S, L, D>> removedQueries = CapsuleUtil.transientSet();
    private final MultiSetMap.Transient<D, ICompletableFuture<D>> pendingExternalDatums = MultiSetMap.Transient.of();
    private final IEnvDifferContext<S, L, D> envDifferContext = new IEnvDifferContext<S, L, D>(){

        @Override
        public IFuture<ScopeDiff<S, L, D>> scopeDiff(S previousScope, L label) {
            IFuture result = TypeCheckerUnit.this.differ.scopeDiff(previousScope, label);
            if (result.isDone()) {
                return result;
            }
            CompletableFuture future = new CompletableFuture();
            DifferState state = DifferState.ofDiff(TypeCheckerUnit.this.self, previousScope, label, future);
            TypeCheckerUnit.this.waitFor(state, TypeCheckerUnit.this.self);
            result.whenComplete(future::complete);
            future.whenComplete((r, ex) -> TypeCheckerUnit.this.granted(state, TypeCheckerUnit.this.self));
            return future;
        }

        @Override
        public IFuture<Optional<S>> match(S previousScope) {
            return TypeCheckerUnit.this.differ.match(previousScope);
        }

        @Override
        public Set.Immutable<L> edgeLabels() {
            return TypeCheckerUnit.this.edgeLabels;
        }
    };

    TypeCheckerUnit(IActor<? extends IUnit<S, L, D, Result<S, L, D, R, T>>> self, @Nullable IActorRef<? extends IUnit<S, L, D, ?>> parent, IUnitContext<S, L, D> context, ITypeChecker<S, L, D, R, T> unitChecker, Iterable<L> edgeLabels, boolean inputChanged, IUnitResult<S, L, D, Result<S, L, D, R, T>> previousResult) {
        super(self, parent, context, edgeLabels);
        this.typeChecker = unitChecker;
        this.changed = inputChanged;
        this.previousResult = previousResult;
        this.state = UnitState.INIT_UNIT;
        this.confirmation = OptimisticConfirmation.factory();
    }

    TypeCheckerUnit(IActor<? extends IUnit<S, L, D, Result<S, L, D, R, T>>> self, @Nullable IActorRef<? extends IUnit<S, L, D, ?>> parent, IUnitContext<S, L, D> context, ITypeChecker<S, L, D, R, T> unitChecker, Iterable<L> edgeLabels) {
        this(self, parent, context, unitChecker, edgeLabels, true, null);
    }

    @Override
    protected IFuture<D> getExternalDatum(D datum) {
        Optional<D> datumOpt;
        if (!this.changed && this.previousResult != null && this.previousResult.result().localState() != null && (datumOpt = ((ITypeChecker.IState)this.previousResult.result().localState().typeCheckerState()).tryGetExternalDatum(datum)).isPresent()) {
            return CompletableFuture.completedFuture(datumOpt.get());
        }
        return this.whenActive.compose((u, ex) -> {
            if (this.state.equals((Object)UnitState.RELEASED) || this.state.equals((Object)UnitState.DONE) && this.stateTransitionTrace.equals((Object)IUnitResult.TransitionTrace.RELEASED)) {
                Object result = this.previousResult.result().analysis().getExternalRepresentation(datum);
                return CompletableFuture.completedFuture(this.context.substituteScopes(result, this.resultPatches.patches().invert()));
            }
            IFuture<Object> future = this.typeChecker.getExternalDatum(datum);
            if (future.isDone()) {
                return future;
            }
            CompletableFuture<Object> result = new CompletableFuture<Object>();
            this.pendingExternalDatums.put(datum, result);
            future.whenComplete(result::complete);
            return result.whenComplete((__, ex2) -> this.pendingExternalDatums.remove(datum, result));
        });
    }

    @Override
    protected D getPreviousDatum(D datum) {
        this.assertPreviousResultProvided();
        return this.previousResult.result().analysis().getExternalRepresentation(datum);
    }

    @Override
    public IFuture<IUnitResult<S, L, D, Result<S, L, D, R, T>>> _start(List<S> rootScopes) {
        IFuture<Result> result;
        this.assertInState(UnitState.INIT_UNIT);
        this.resume();
        this.doStart(rootScopes);
        if (this.isIncrementalEnabled() && this.previousResult != null) {
            if (this.previousResult.rootScopes().size() != rootScopes.size()) {
                throw new IllegalStateException("Root scope counts do not match.");
            }
            Iterables2.zip(rootScopes, this.previousResult.rootScopes(), Tuple2::of).forEach(match -> {
                this.matchedBySharing.put(match._1(), match._2());
                this.externalMatches.put(match._1(), match._2());
            });
        }
        try {
            this.state = UnitState.INIT_TC;
            result = this.typeChecker.run(this, rootScopes).whenComplete((r, ex) -> {
                if (this.state == UnitState.INIT_TC) {
                    this.stateTransitionTrace = IUnitResult.TransitionTrace.INITIALLY_STARTED;
                }
                if (this.inLocalPhase()) {
                    this.doCapture();
                }
                this.state = UnitState.DONE;
                this.resume();
                this.tryFinish();
            }).thenApply(r -> Result.of(r, this.localCapture.get(), this.localScopeGraph.get(), this.matchedBySharing.patchRange()));
        }
        catch (Exception e) {
            logger.error("Exception starting type-checker {}.", e);
            return this.doFinish(CompletableFuture.completedExceptionally(e));
        }
        if (this.isIncrementalEnabled() && this.previousResult != null) {
            for (String removedId : Sets.difference(this.previousResult.subUnitResults().keySet(), this.addedUnitIds)) {
                IUnitResult<S, L, D, ?> subResult = this.previousResult.subUnitResults().get(removedId);
                this.doAddSubUnit(removedId, (subself, subcontext) -> new PhantomUnit(subself, this.self, subcontext, this.edgeLabels, subResult), new ArrayList(), true);
            }
        }
        if (this.state == UnitState.INIT_TC) {
            this.doRestart(false);
        } else if (this.state == UnitState.DONE) {
            this.whenActive.complete(Unit.unit);
            this.confirmationResult.complete(Optional.of(PatchCollection.Immutable.of()));
        }
        return this.doFinish(result);
    }

    @Override
    public IFuture<ConfirmResult<S, L, D>> _confirm(S scope, LabelWf<L> labelWF, DataWf<S, L, D> dataWF, boolean prevEnvEmpty) {
        this.assertConfirmationEnabled();
        ++this.stats.incomingConfirmations;
        IActorRef sender = this.self.sender(this.TYPE);
        CompletableFuture<ConfirmResult<S, L, D>> result = new CompletableFuture<ConfirmResult<S, L, D>>();
        this.whenActive.whenComplete((__, ex) -> {
            if (ex != null && ex != Release.instance) {
                result.completeExceptionally((Throwable)ex);
            } else {
                this.confirmation.getConfirmation(new ConfirmationContext(sender)).confirm(scope, labelWF, dataWF, prevEnvEmpty).whenComplete(result::complete);
            }
        });
        return result;
    }

    @Override
    public IFuture<IQueryAnswer<S, L, D>> _queryPrevious(ScopePath<S, L> path, IQuery<S, L, D> query, DataWf<S, L, D> dataWF, DataLeq<S, L, D> dataEquiv) {
        this.assertPreviousResultProvided();
        return this.doQueryPrevious(this.self.sender(this.TYPE), this.previousResult.scopeGraph(), path, query, dataWF, dataEquiv);
    }

    @Override
    public IFuture<Optional<S>> _match(S previousScope) {
        this.assertOwnScope(previousScope);
        if (this.matchedBySharing.identityPatches().contains(previousScope)) {
            return CompletableFuture.completedFuture(Optional.of(previousScope));
        }
        if (this.matchedBySharing.patchDomain().contains(previousScope)) {
            return CompletableFuture.completedFuture(Optional.of(this.matchedBySharing.patch(previousScope)));
        }
        if (!this.changed && this.previousResult.result().localState() != null && this.previousResult.result().localState().scopes().contains(previousScope)) {
            return CompletableFuture.completedFuture(Optional.of(previousScope));
        }
        return super._match(previousScope);
    }

    @Override
    public IFuture<StateSummary<S, L, D>> _state() {
        if (this.state.equals((Object)UnitState.ACTIVE) || this.state == UnitState.DONE && this.stateTransitionTrace != IUnitResult.TransitionTrace.RELEASED) {
            return CompletableFuture.completedFuture(StateSummary.restart(this.process, this.dependentSet()));
        }
        if (this.state.equals((Object)UnitState.RELEASED) || this.state == UnitState.DONE && this.stateTransitionTrace == IUnitResult.TransitionTrace.RELEASED) {
            return CompletableFuture.completedFuture(StateSummary.released(this.process, this.dependentSet()));
        }
        return CompletableFuture.completedFuture(StateSummary.release(this.process, this.dependentSet()));
    }

    @Override
    public void _restart() {
        this.assertIncrementalEnabled();
        if (this.doRestart(true)) {
            this.stateTransitionTrace = IUnitResult.TransitionTrace.RESTARTED;
        }
    }

    @Override
    public void _release() {
        if (this.state == UnitState.UNKNOWN) {
            this.doRelease(CapsuleUtil.toSet(this.addedQueries), CapsuleUtil.toSet(this.removedQueries), PatchCollection.Immutable.of().putAll((IPatchCollection)this.resultPatches), PatchCollection.Immutable.of().putAll((IPatchCollection)this.globalPatches));
        }
    }

    @Override
    public String id() {
        return this.self.id();
    }

    @Override
    public <Q extends ITypeChecker.IOutput<S, L, D>, U extends ITypeChecker.IState<S, L, D>> IFuture<IUnitResult<S, L, D, Result<S, L, D, Q, U>>> add(String id, ITypeChecker<S, L, D, Q, U> unitChecker, List<S> rootScopes, boolean changed) {
        IUnitResult<S, L, D, ?> subUnitPreviousResult;
        this.assertActive();
        if (this.previousResult == null || !this.previousResult.subUnitResults().containsKey(id)) {
            this.addedUnitIds.__insert((Object)id);
            return this.ifActive(this.whenContextActive(this.doAddSubUnit(id, (subself, subcontext) -> new TypeCheckerUnit<S, L, D, R, T>(subself, this.self, subcontext, unitChecker, this.edgeLabels), rootScopes, false)._2()));
        }
        if (this.isIncrementalEnabled()) {
            subUnitPreviousResult = this.previousResult.subUnitResults().get(id);
            List<S> previousRootScopes = subUnitPreviousResult.rootScopes();
            int pSize = previousRootScopes.size();
            int cSize = rootScopes.size();
            if (cSize != pSize) {
                logger.error("Unit {} adds subunit {} with initial state but with different root scope count.");
                throw new IllegalStateException("Different root scope count.");
            }
            BiMap.Transient<S> req = BiMap.Transient.of();
            int i = 0;
            while (i < rootScopes.size()) {
                S cRoot = rootScopes.get(i);
                S pRoot = previousRootScopes.get(i);
                req.put(cRoot, pRoot);
                if (this.isOwner(cRoot)) {
                    this.matchedBySharing.put(cRoot, pRoot);
                }
                ++i;
            }
            if (this.isDifferEnabled()) {
                this.whenDifferActivated.thenAccept(__ -> {
                    if (!this.differ.matchScopes(req.freeze())) {
                        logger.error("Unit {} adds subunit {} with initial state but with different root scope count.");
                        throw new IllegalStateException("Could not match.");
                    }
                });
            }
            this.addedUnitIds.__insert((Object)id);
        } else {
            subUnitPreviousResult = null;
        }
        IFuture result = this.doAddSubUnit(id, (subself, subcontext) -> new TypeCheckerUnit<S, L, D, R, T>(subself, this.self, subcontext, unitChecker, this.edgeLabels, changed, subUnitPreviousResult), rootScopes, false)._2();
        return this.ifActive(this.whenContextActive(result));
    }

    @Override
    public IFuture<IUnitResult<S, L, D, Unit>> add(String id, IScopeGraphLibrary<S, L, D> library, List<S> rootScopes) {
        this.assertActive();
        IFuture result = this.doAddSubUnit(id, (subself, subcontext) -> {
            IUnitResult<S, L, D, ?> previousResult = this.previousResult != null ? this.previousResult.subUnitResults().get(id) : null;
            return new ScopeGraphLibraryUnit<S, L, D>(subself, this.self, subcontext, this.edgeLabels, library, previousResult);
        }, rootScopes, false)._2();
        this.addedUnitIds.__insert((Object)id);
        return this.ifActive(this.whenContextActive(result));
    }

    @Override
    public void initScope(S root, Collection<L> labels, boolean sharing) {
        this.assertActive();
        List edges = labels.stream().map(EdgeOrData::edge).collect(Collectors.toList());
        this.doInitShare(this.self, root, edges, sharing);
    }

    @Override
    public S freshScope(String baseName, Iterable<L> edgeLabels, boolean data, boolean sharing) {
        this.assertActive();
        this.doImplicitActivate();
        Object scope = this.doFreshScope(baseName, edgeLabels, data, sharing);
        return scope;
    }

    @Override
    public S stableFreshScope(String name, Iterable<L> edgeLabels, boolean data) {
        this.assertActive();
        Object scope = this.doStableFreshScope(name, edgeLabels, data);
        return scope;
    }

    @Override
    public void shareLocal(S scope) {
        this.assertActive();
        this.doAddShare(this.self, scope);
    }

    @Override
    public void setDatum(S scope, D datum) {
        this.assertActive();
        this.doSetDatum(scope, datum);
        this.localScopeGraph.set(this.localScopeGraph.get().setDatum(scope, datum));
    }

    @Override
    public void addEdge(S source, L label, S target) {
        this.assertActive();
        this.doImplicitActivate();
        this.doAddEdge(this.self, source, label, target);
        this.localScopeGraph.set(this.localScopeGraph.get().addEdge(source, label, target));
    }

    @Override
    public void closeEdge(S source, L label) {
        this.assertActive();
        this.doCloseLabel(this.self, source, EdgeOrData.edge(label));
    }

    @Override
    public void closeScope(S scope) {
        this.assertActive();
        this.doCloseScope(this.self, scope);
    }

    @Override
    public IFuture<? extends Set<IResolutionPath<S, L, D>>> query(S scope, IQuery<S, L, D> query, DataWf<S, L, D> dataWF, DataLeq<S, L, D> dataEquiv, DataWf<S, L, D> dataWfInternal, DataLeq<S, L, D> dataEquivInternal) {
        IFuture ret;
        this.assertActive();
        this.doImplicitActivate();
        ScopePath path = new ScopePath(scope);
        IFuture result = this.doQuery(this.self, this.self, true, path, query, dataWF, dataEquiv, dataWfInternal, dataEquivInternal);
        if (result.isDone()) {
            ret = result;
        } else {
            Query wf = Query.of(this.self, path, query, dataWF, dataEquiv, result);
            this.waitFor(wf, this.self);
            ret = result.whenComplete((env, ex) -> {
                this.granted(wf, this.self);
                this.resume();
            });
        }
        ++this.stats.localQueries;
        return this.ifActive(ret.thenCompose(ans -> {
            IFuture<IQueryAnswer> res = CompletableFuture.completedFuture(ans);
            if (ans.transitiveQueries().isEmpty() && ans.predicateQueries().isEmpty()) {
                return res;
            }
            return this.whenContextActive(res);
        })).thenApply(ans -> CapsuleUtil.toSet(ans.env()));
    }

    @Override
    public IFuture<? extends Set<IResolutionPath<S, L, D>>> query(S scope, LabelWf<L> labelWF, LabelOrder<L> labelOrder, DataWf<S, L, D> dataWF, DataLeq<S, L, D> dataEquiv, @Nullable DataWf<S, L, D> dataWfInternal, @Nullable DataLeq<S, L, D> dataEquivInternal) {
        return this.query(scope, new NameResolutionQuery(labelWF, labelOrder, this.edgeLabels), dataWF, dataEquiv, dataWfInternal, dataEquivInternal);
    }

    @Override
    public IFuture<? extends Set<IResolutionPath<S, L, D>>> query(S scope, StateMachine<L> stateMachine, DataWf<S, L, D> dataWF, DataLeq<S, L, D> dataEquiv, DataWf<S, L, D> dataWfInternal, DataLeq<S, L, D> dataEquivInternal) {
        return this.query(scope, new StateMachineQuery(stateMachine), dataWF, dataEquiv, dataWfInternal, dataEquivInternal);
    }

    @Override
    public <Q> IFuture<R> runIncremental(Function1<Optional<T>, IFuture<Q>> runLocalTypeChecker, Function1<R, Q> extractLocal, Function2<Q, IPatchCollection.Immutable<S>, Q> patch, Function2<Q, Throwable, IFuture<R>> combine) {
        this.assertInState(UnitState.INIT_TC);
        this.state = UnitState.UNKNOWN;
        if (!this.isIncrementalEnabled() || this.changed) {
            logger.debug("Unit changed or no previous result was available.");
            this.stateTransitionTrace = IUnitResult.TransitionTrace.INITIALLY_STARTED;
            this.doRestart(false);
            return runLocalTypeChecker.apply(Optional.empty()).compose(combine::apply);
        }
        this.assertPreviousResultProvided();
        if (this.previousResult.result().localState() != null) {
            this.doRestore(this.previousResult.result().localState());
        }
        this.doConfirmQueries();
        return this.confirmationResult.thenCompose(patches -> {
            if (patches.isPresent()) {
                Object previousLocalResult = extractLocal.apply(this.previousResult.result().analysis());
                return (IFuture)combine.apply(patch.apply(previousLocalResult, (IPatchCollection.Immutable)patches.get()), null);
            }
            Optional<ITypeChecker.IState> initialState = Optional.ofNullable(this.previousResult.result().localState()).map(StateCapture::typeCheckerState);
            return ((IFuture)runLocalTypeChecker.apply(initialState)).compose(combine::apply);
        });
    }

    private void doConfirmQueries() {
        logger.debug("Confirming queries from previous result.");
        this.assertInState(UnitState.UNKNOWN);
        this.assertIncrementalEnabled();
        this.assertPreviousResultProvided();
        this.resume();
        if (this.previousResult.queries().isEmpty()) {
            logger.debug("Releasing - no queries in previous result.");
            this.doRelease(CapsuleUtil.immutableSet(), CapsuleUtil.immutableSet(), PatchCollection.Immutable.of(), PatchCollection.Immutable.of());
            return;
        }
        IConfirmation<S, L, D> confirmaton = this.confirmation.getConfirmation(new ConfirmationContext(this.self));
        List futures = this.previousResult.queries().stream().map(confirmaton::confirm).map(intermediateFuture -> intermediateFuture.thenApply(intermediate -> intermediate.match(() -> AggregateFuture.SC.shortCircuit(false), (addedQueries, removedQueries, resultPatches, globalPatches) -> {
            this.resultPatches.putAll((IPatchCollection<S>)resultPatches);
            this.globalPatches.putAll((IPatchCollection<S>)globalPatches);
            this.addedQueries.__insertAll((Set)addedQueries);
            this.removedQueries.__insertAll((Set)removedQueries);
            return AggregateFuture.SC.of(true);
        }))).collect(Collectors.toList());
        AggregateFuture.ofShortCircuitable(patchCollections -> true, futures).whenComplete((r, ex) -> {
            if (ex == Release.instance) {
                logger.debug("Confirmation received release.");
            } else if (ex != null) {
                logger.error("Failure in confirmation.", (Throwable)ex);
                this.failures.add(ex);
            } else if (r.booleanValue()) {
                logger.debug("Queries confirmed - releasing.");
                this.doRelease(this.addedQueries.freeze(), this.removedQueries.freeze(), this.resultPatches.freeze(), this.globalPatches.freeze());
            } else {
                logger.debug("Query confirmation denied - restarting.");
                if (this.doRestart(true)) {
                    this.stateTransitionTrace = IUnitResult.TransitionTrace.RESTARTED;
                }
            }
        });
    }

    private void doRelease(Set.Immutable<IRecordedQuery<S, L, D>> addedQueries, Set.Immutable<IRecordedQuery<S, L, D>> removedQueries, IPatchCollection.Immutable<S> resultPatches, IPatchCollection.Immutable<S> globalPatches) {
        this.assertIncrementalEnabled();
        resultPatches.assertConsistent();
        globalPatches.assertConsistent();
        if (this.state == UnitState.UNKNOWN) {
            Set openScopes;
            logger.debug("{} releasing.", this);
            logger.trace("Patches: result: {}; global: {}.", resultPatches, globalPatches);
            this.assertPreviousResultProvided();
            this.scopes.__insertAll(this.previousResult.scopes());
            IPatchCollection.Immutable<S> localPatches = this.matchedBySharing.freeze();
            IScopeGraphDiffer differ = localPatches.isIdentity() && this.addedUnitIds.isEmpty() ? new MatchingDiffer(this.differOps(), this.differContext(this.typeChecker::internalData), resultPatches.allPatches()) : new ScopeGraphDiffer(this.differContext(this.typeChecker::internalData), new StaticDifferContext<S, L, D>(this.previousResult.scopeGraph(), this.previousResult.scopes(), new DifferDataOps()), this.differOps(), this.edgeLabels);
            Collection<Object> collection = openScopes = this.addedUnitIds.isEmpty() ? Collections.emptySet() : this.previousResult.rootScopes();
            if (this.isConfirmationEnabled()) {
                this.envDiffer = new IndexedEnvDiffer<S, L, D>(new EnvDiffer<S, L, D>(this.envDifferContext, this.differOps()));
            }
            this.initDiffer(differ, this.previousResult.scopeGraph(), this.previousResult.scopes(), this.previousResult.result().sharedScopes(), localPatches, openScopes, MultiSetMap.Immutable.of());
            logger.debug("Rebuilding scope graph.");
            Patcher<Object, Object, Object> patcher = new Patcher.Builder().patchSources(localPatches).patchEdgeTargets(resultPatches).patchDatumSources(localPatches).patchDatums(resultPatches, this.context::substituteScopes).build();
            IScopeGraph.Immutable<Object, Object, Object> patchedLocalScopeGraph = patcher.apply(this.previousResult.result().scopeGraph(), (oldSource, newSource) -> this.isOwner(newSource), (oldSource, newSource, lbl, oldTarget, newTarget, sourceLocal) -> {
                if (!sourceLocal.booleanValue()) {
                    this.doAddEdge(this.self, newSource, lbl, newTarget);
                }
            }, Patcher.DataPatchCallback.noop());
            this.scopeGraph.set(((IScopeGraph.Immutable)this.scopeGraph.get()).addAll(patchedLocalScopeGraph));
            this.localScopeGraph.set(this.localScopeGraph.get().addAll(patchedLocalScopeGraph));
            logger.debug("Close pending tokens.");
            HashSet initScopes = new HashSet();
            SetMultimap closeEdges = new SetMultimap();
            IWaitFor.Cases cases = IWaitFor.cases(initScope -> {
                boolean bl = initScopes.add(initScope.scope());
            }, closeScope -> {}, closeLabel -> {
                boolean bl = closeEdges.put(closeLabel.scope(), closeLabel.label());
            }, query -> {}, pQuery -> {}, confirm -> {}, match -> {}, result -> {}, typeCheckerState -> {}, differResult -> {}, differState -> {}, envDifferState -> {}, unitAdd -> {});
            for (IWaitFor wf : this.ownTokens()) {
                wf.visit(cases);
            }
            for (Object scope : initScopes) {
                this.doInitShare(this.self, scope, Collections.emptySet(), false);
            }
            closeEdges.entries().forEach(entry -> this.doCloseLabel(this.self, entry.getKey(), (EdgeOrData)entry.getValue()));
            this.pendingExternalDatums.asMap().forEach((d, futures) -> futures.elementSet().forEach(future -> {
                Object datum = this.previousResult.result().analysis().getExternalRepresentation((Object)d);
                Object result = this.context.substituteScopes(datum, resultPatches.patches().invert());
                this.self.complete(future, result, (Throwable)null);
            }));
            IPatchCollection.Immutable allPatches = resultPatches.putAll(globalPatches);
            Set newRecordedQueries = this.previousResult.queries().stream().map(q -> q.patch(allPatches)).collect(Collectors.toSet());
            Set patchedRemovedQueries = removedQueries.stream().map(q -> q.patch(allPatches)).collect(Collectors.toSet());
            newRecordedQueries.removeAll(patchedRemovedQueries);
            newRecordedQueries.addAll(addedQueries);
            this.recordedQueries.addAll(newRecordedQueries);
            this.stateTransitionTrace = IUnitResult.TransitionTrace.RELEASED;
            this.self.complete(this.confirmationResult, Optional.of(resultPatches), null);
            this.self.complete(this.whenActive, null, Release.instance);
            this.state = UnitState.RELEASED;
            this.resume();
            this.tryFinish();
            logger.debug("{} released.", this);
        }
    }

    private boolean doRestart(boolean external) {
        if (this.state == UnitState.INIT_TC || this.state == UnitState.UNKNOWN) {
            logger.debug("{} restarting.", this);
            this.state = UnitState.ACTIVE;
            this.self.complete(this.confirmationResult, Optional.empty(), null);
            this.self.complete(this.whenActive, Unit.unit, null);
            if (this.isDifferEnabled()) {
                IDifferContext context = this.differContext(this.typeChecker::internalData);
                IDifferOps differOps = this.differOps();
                if (this.previousResult != null) {
                    StaticDifferContext<S, L, D> differContext = new StaticDifferContext<S, L, D>(this.previousResult.scopeGraph(), this.previousResult.scopes(), new DifferDataOps());
                    if (this.isConfirmationEnabled()) {
                        this.envDiffer = new IndexedEnvDiffer<S, L, D>(new EnvDiffer<S, L, D>(this.envDifferContext, this.differOps()));
                    }
                    if (external) {
                        StateCapture<S, L, D, T> capture = this.previousResult.result().localState();
                        Set.Immutable openScopes = CapsuleUtil.toSet(Sets.union(capture.openScopes().elementSet(), capture.unInitializedScopes().elementSet()));
                        this.initDiffer(new ScopeGraphDiffer(context, differContext, differOps, this.edgeLabels), capture.scopeGraph(), capture.scopes(), this.previousResult.result().sharedScopes(), this.matchedBySharing.freeze(), openScopes, capture.openEdges());
                    } else {
                        this.initDiffer(new ScopeGraphDiffer(context, differContext, differOps, this.edgeLabels), this.rootScopes, this.previousResult.rootScopes());
                    }
                } else {
                    this.initDiffer(new AddingDiffer(context, differOps, this.edgeLabels), Collections.emptyList(), Collections.emptyList());
                }
            }
            this.pendingExternalDatums.asMap().forEach((d, futures) -> this.typeChecker.getExternalDatum(d).whenComplete((d2, ex) -> futures.forEach(future -> future.complete(d2, (Throwable)ex))));
            this.resume();
            this.tryFinish();
            logger.debug("{} restarted.", this);
            return true;
        }
        return false;
    }

    private void doImplicitActivate() {
        if (this.state == UnitState.INIT_TC && this.doRestart(false)) {
            logger.debug("{} implicitly activated.");
            this.stateTransitionTrace = IUnitResult.TransitionTrace.INITIALLY_STARTED;
        }
    }

    @Override
    public Set<IProcess<S, L, D>> dependentSet() {
        if (this.state.active() && this.inLocalPhase()) {
            return Collections.singleton(this.process);
        }
        return super.dependentSet();
    }

    @Override
    protected void handleDeadlock(Set<IProcess<S, L, D>> nodes) {
        if (nodes.size() == 1 && !this.whenActive.isDone()) {
            this.assertInState(UnitState.UNKNOWN);
            logger.debug("{} self-deadlocked before activation, releasing", this);
            this.doRelease(CapsuleUtil.toSet(this.addedQueries), CapsuleUtil.toSet(this.removedQueries), PatchCollection.Immutable.of().putAll((IPatchCollection)this.externalMatches), PatchCollection.Immutable.of().putAll((IPatchCollection)this.globalPatches));
        } else if (this.state.active() && this.inLocalPhase()) {
            this.doCapture();
            this.resume();
        } else {
            super.handleDeadlock(nodes);
        }
    }

    protected boolean inLocalPhase() {
        return !this.whenContextActivated.isDone();
    }

    protected <Q> IFuture<Q> whenContextActive(IFuture<Q> future) {
        if (!this.inLocalPhase()) {
            return future;
        }
        return this.whenContextActivated.thenCompose(__ -> future);
    }

    private void doCapture() {
        T snapshot = this.typeChecker.snapshot();
        StateCapture.Builder<Object, L, D, T> builder = StateCapture.builder();
        Set.Immutable scopes = CapsuleUtil.toSet(this.scopes);
        builder.scopes(scopes);
        builder.scopeGraph(this.localScopeGraph.get());
        this.localScopeGraph.set(ScopeGraph.Immutable.of());
        Set.Transient _edgeLabels = CapsuleUtil.transientSet(EdgeOrData.data());
        this.edgeLabels.forEach(lbl -> {
            boolean bl = _edgeLabels.__insert(EdgeOrData.edge(lbl));
        });
        Set.Immutable edgeLabels = _edgeLabels.freeze();
        MultiSet.Transient unInitializedScopes = MultiSet.Transient.of();
        MultiSet.Transient openScopes = MultiSet.Transient.of();
        MultiSetMap.Transient openEdges = MultiSetMap.Transient.of();
        for (Object scope : scopes) {
            int initCount = this.countWaitingFor(InitScope.of(this.self, scope), this.self);
            int i = 0;
            while (i < initCount) {
                unInitializedScopes.add(scope);
                ++i;
            }
            int closeCount = this.countWaitingFor(CloseScope.of(this.self, scope), this.self);
            int i2 = 0;
            while (i2 < closeCount) {
                openScopes.add(scope);
                ++i2;
            }
            for (EdgeOrData label : edgeLabels) {
                int closeLabelCount = this.countWaitingFor(CloseLabel.of(this.self, scope, label), this.self);
                int i3 = 0;
                while (i3 < closeLabelCount) {
                    openEdges.put(scope, label);
                    ++i3;
                }
            }
        }
        builder.unInitializedScopes(unInitializedScopes.freeze());
        builder.openScopes(openScopes.freeze());
        builder.openEdges(openEdges.freeze());
        builder.scopeNameCounters(MultiSet.Immutable.copyOf(this.scopeNameCounters));
        Set.Transient stableIdentities = CapsuleUtil.transientSet();
        stableIdentities.__insertAll((Set)this.usedStableScopes);
        builder.usedStableScopes((Set.Immutable<String>)stableIdentities.freeze());
        builder.typeCheckerState(snapshot);
        this.localCapture(builder.build());
    }

    private void doRestore(StateCapture<S, L, D, T> snapshot) {
        this.scopes.__insertAll(snapshot.scopes());
        Set.Transient currentIdentities = CapsuleUtil.transientSet();
        currentIdentities.__insertAll((Set)this.usedStableScopes);
        Set.Immutable stableScopes = Set.Immutable.intersect(snapshot.usedStableScopes(), (Set.Immutable)currentIdentities.freeze());
        this.scopeNameCounters = snapshot.scopeNameCounters().melt();
        for (Object scope : snapshot.unInitializedScopes()) {
            this.doAddShare(this.self, scope);
        }
        for (Object scope : snapshot.openScopes()) {
            this.doAddShare(this.self, scope);
            this.doInitShare(this.self, scope, Arrays.asList(new EdgeOrData[0]), true);
        }
        for (Object scope : snapshot.openEdges().keySet()) {
            this.doAddShare(this.self, scope);
            this.doInitShare(this.self, scope, snapshot.openEdges().get(scope), false);
        }
        this.scopeGraph.set(snapshot.scopeGraph());
        BiMap.Transient scopesToProcess = BiMap.Transient.of();
        stableScopes.forEach(name -> {
            Object scope = this.makeStableScope((String)name);
            scopesToProcess.put(scope, scope);
        });
        Iterator<S> pScopeIterator = this.previousResult.rootScopes().iterator();
        for (Object e : this.rootScopes) {
            S previousScope = pScopeIterator.next();
            scopesToProcess.put(e, previousScope);
        }
        for (Map.Entry entry : scopesToProcess.entrySet()) {
            Object currentScope = entry.getKey();
            Object previousScope = entry.getValue();
            boolean ownedScope = this.context.scopeId(currentScope).equals(this.self.id());
            Set edges = this.edgeLabels.stream().filter(label -> !snapshot.scopeGraph().getEdges(previousScope, label).isEmpty()).map(EdgeOrData::edge).collect(Collectors.toCollection(HashSet::new));
            this.doInitShare(this.self, currentScope, edges, false);
            for (Object label2 : this.edgeLabels) {
                for (Object target : snapshot.scopeGraph().getEdges(previousScope, label2)) {
                    if (ownedScope) continue;
                    Object newTarget = this.matchedBySharing.patch(target);
                    ((IUnit)this.self.async(this.parent))._addEdge(currentScope, label2, newTarget);
                }
                CloseLabel closeEdge = CloseLabel.of(this.self, currentScope, EdgeOrData.edge(label2));
                if (snapshot.isOpen(previousScope, EdgeOrData.edge(label2)) || !this.isWaitingFor(closeEdge, this.self)) continue;
                this.doCloseLabel(this.self, currentScope, EdgeOrData.edge(label2));
            }
        }
        this.localCapture(snapshot);
    }

    private void localCapture(StateCapture<S, L, D, T> capture) {
        if (this.localCapture.get() != null) {
            logger.error("Cannot create multiple local captures.");
            throw new IllegalStateException("Cannot create multiple local captures.");
        }
        this.localCapture.set(capture);
        this.whenContextActivated.complete(Unit.unit);
    }

    private void assertInState(UnitState s) {
        if (!this.state.equals((Object)s)) {
            logger.error("Expected state {}, was {}", new Object[]{s, this.state});
            throw new IllegalStateException("Expected state " + (Object)((Object)s) + ", was " + (Object)((Object)this.state));
        }
    }

    private void assertActive() {
        if (!this.state.active()) {
            logger.error("Expected active state, was {}", new Object[]{this.state});
            throw new IllegalStateException("Expected active state, but was " + (Object)((Object)this.state));
        }
    }

    private <Q> IFuture<Q> ifActive(IFuture<Q> result) {
        return result.compose((r, ex) -> {
            if (this.state != UnitState.DONE) {
                return CompletableFuture.completed(r, ex);
            }
            return CompletableFuture.noFuture();
        });
    }

    protected void assertIncrementalEnabled() {
        if (!this.isIncrementalEnabled()) {
            logger.error("Incremental analysis is not enabled");
            throw new IllegalStateException("Incremental analysis is not enabled");
        }
    }

    protected void assertPreviousResultProvided() {
        if (this.previousResult == null) {
            logger.error("Cannot confirm queries when no previous result is provided.");
            throw new IllegalStateException("Cannot confirm queries when no previous result is provided.");
        }
    }

    protected boolean isConfirmationEnabled() {
        return this.context.settings().confirmation();
    }

    protected void assertConfirmationEnabled() {
        if (!this.isConfirmationEnabled()) {
            logger.error("Environment differ not enabled.");
            throw new IllegalStateException("Environment differ not enabled.");
        }
    }

    public String toString() {
        return "TypeCheckerUnit{" + this.self.id() + "}";
    }

    private class ConfirmationContext
    implements IConfirmationContext<S, L, D> {
        private final IActorRef<? extends IUnit<S, L, D, ?>> sender;

        public ConfirmationContext(IActorRef<? extends IUnit<S, L, D, ?>> sender) {
            this.sender = sender;
        }

        @Override
        public IFuture<IQueryAnswer<S, L, D>> query(ScopePath<S, L> scopePath, LabelWf<L> labelWf, LabelOrder<L> labelOrder, DataWf<S, L, D> dataWf, DataLeq<S, L, D> dataEquiv) {
            logger.debug("query from env differ.");
            return TypeCheckerUnit.this.doQuery(this.sender, this.sender, false, scopePath, new NameResolutionQuery(labelWf, labelOrder, TypeCheckerUnit.this.edgeLabels), dataWf, dataEquiv, null, null);
        }

        @Override
        public IFuture<IQueryAnswer<S, L, D>> queryPrevious(ScopePath<S, L> scopePath, LabelWf<L> labelWf, DataWf<S, L, D> dataWf, LabelOrder<L> labelOrder, DataLeq<S, L, D> dataEquiv) {
            TypeCheckerUnit.this.assertPreviousResultProvided();
            logger.debug("previous query from env differ.");
            return TypeCheckerUnit.this.doQueryPrevious(this.sender, TypeCheckerUnit.this.previousResult.scopeGraph(), scopePath, new NameResolutionQuery(labelWf, labelOrder, TypeCheckerUnit.this.edgeLabels), dataWf, dataEquiv);
        }

        @Override
        public IFuture<Optional<ConfirmResult<S, L, D>>> externalConfirm(S scope, LabelWf<L> labelWF, DataWf<S, L, D> dataWF, boolean prevEnvEmpty) {
            logger.debug("{} try external confirm.", this);
            return TypeCheckerUnit.this.getOwner(scope).thenCompose(owner -> {
                if (owner.equals(TypeCheckerUnit.this.self)) {
                    logger.debug("{} local confirm.", this);
                    return CompletableFuture.completedFuture(Optional.empty());
                }
                logger.debug("{} external confirm.", this);
                CompletableFuture result = new CompletableFuture();
                Confirm confirm = Confirm.of(TypeCheckerUnit.this.self, scope, labelWF, dataWF, result);
                TypeCheckerUnit.this.waitFor(confirm, owner);
                ((IUnit)TypeCheckerUnit.this.self.async(owner))._confirm(scope, labelWF, dataWF, prevEnvEmpty).whenComplete((v, ex) -> {
                    logger.trace("{} rec external confirm: {}.", this, v);
                    TypeCheckerUnit.this.granted(confirm, owner);
                    TypeCheckerUnit.this.resume();
                    if (ex == Release.instance) {
                        logger.debug("{} got release, confirming.", this);
                        result.complete(ConfirmResult.confirm());
                    } else if (ex != null) {
                        result.completeExceptionally((Throwable)ex);
                    } else {
                        logger.trace("confirm: {}.", v);
                        result.complete(v);
                    }
                });
                return result.thenApply(Optional::of);
            });
        }

        @Override
        public IFuture<IEnvDiff<S, L, D>> envDiff(S scope, LabelWf<L> labelWf) {
            TypeCheckerUnit.this.assertConfirmationEnabled();
            logger.debug("{} local env diff: {}/{}.", this, scope, labelWf);
            return TypeCheckerUnit.this.whenDifferActivated.thenCompose(__ -> {
                IFuture result = TypeCheckerUnit.this.envDiffer.diff(scope, labelWf);
                if (result.isDone()) {
                    return result;
                }
                CompletableFuture<IEnvDiff> future = new CompletableFuture<IEnvDiff>();
                EnvDifferState state = EnvDifferState.of(this.sender, scope, labelWf, future);
                TypeCheckerUnit.this.waitFor(state, TypeCheckerUnit.this.self);
                result.whenComplete(future::complete);
                future.whenComplete((r, ex) -> {
                    logger.debug("{} granted local env diff: {}/{}: {}.", this, scope, labelWf, r);
                    TypeCheckerUnit.this.granted(state, TypeCheckerUnit.this.self);
                });
                return future;
            });
        }

        @Override
        public IFuture<Optional<S>> match(S scope) {
            return TypeCheckerUnit.this.getOwner(scope).thenCompose(owner -> {
                CompletableFuture<Optional> result = new CompletableFuture<Optional>();
                DifferState differState = DifferState.ofMatch(TypeCheckerUnit.this.self, scope, result);
                TypeCheckerUnit.this.waitFor(differState, owner);
                IFuture<Optional<Object>> future = ((IUnit)TypeCheckerUnit.this.self.async(owner))._match(scope);
                future.whenComplete(result::complete);
                result.whenComplete((__, ex) -> TypeCheckerUnit.this.granted(differState, owner));
                return result;
            });
        }
    }

    private class DifferDataOps
    implements IDifferDataOps<D> {
        private DifferDataOps() {
        }

        @Override
        public D getExternalRepresentation(D datum) {
            return ((Result)TypeCheckerUnit.this.previousResult.result()).analysis().getExternalRepresentation(datum);
        }
    }
}

