/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import io.usethesource.capsule.Set;
import java.util.Set;
import mb.p_raffrayi.impl.IProcess;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action0;
import org.metaborg.util.functions.Function0;

public class StateSummary<S, L, D> {
    private final State state;
    private final IProcess<S, L, D> self;
    private final Set.Immutable<IProcess<S, L, D>> dependencies;

    private StateSummary(State state, IProcess<S, L, D> self, Set<IProcess<S, L, D>> dependencies) {
        this.state = state;
        this.self = self;
        this.dependencies = CapsuleUtil.toSet(dependencies);
    }

    public State getState() {
        return this.state;
    }

    public IProcess<S, L, D> getSelf() {
        return this.self;
    }

    public Set.Immutable<IProcess<S, L, D>> getDependencies() {
        return this.dependencies;
    }

    public <T> T match(Function0<T> onRestart, Function0<T> onRelease, Function0<T> onReleased) {
        switch (this.state) {
            case ACTIVE: {
                return onRestart.apply();
            }
            case UNKNOWN: {
                return onRelease.apply();
            }
            case RELEASED: {
                return onReleased.apply();
            }
        }
        throw new IllegalStateException("Unknown state" + (Object)((Object)this.state) + ".");
    }

    public void accept(Action0 onRestart, Action0 onRelease, Action0 onReleased) {
        switch (this.state) {
            case ACTIVE: {
                onRestart.apply();
                break;
            }
            case UNKNOWN: {
                onRelease.apply();
                break;
            }
            case RELEASED: {
                onReleased.apply();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state" + (Object)((Object)this.state) + ".");
            }
        }
    }

    public String toString() {
        return "StateSummary{state=" + (Object)((Object)this.state) + ", self=" + this.self + ", dependencies=" + this.dependencies + "}";
    }

    public static <S, L, D> StateSummary<S, L, D> restart(IProcess<S, L, D> self, Set<IProcess<S, L, D>> dependencies) {
        return new StateSummary<S, L, D>(State.ACTIVE, self, dependencies);
    }

    public static <S, L, D> StateSummary<S, L, D> release(IProcess<S, L, D> self, Set<IProcess<S, L, D>> dependencies) {
        return new StateSummary<S, L, D>(State.UNKNOWN, self, dependencies);
    }

    public static <S, L, D> StateSummary<S, L, D> released(IProcess<S, L, D> self, Set<IProcess<S, L, D>> dependencies) {
        return new StateSummary<S, L, D>(State.RELEASED, self, dependencies);
    }

    public static enum State {
        ACTIVE,
        UNKNOWN,
        RELEASED;

    }
}

