/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import mb.p_raffrayi.collection.MultiTable;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.tuple.Tuple3;

public abstract class AMultiTable<R, C, V>
implements MultiTable<R, C, V> {
    private final Map<R, Map<C, Collection<V>>> table;

    public AMultiTable(Map<R, Map<C, Collection<V>>> table) {
        this.table = table;
    }

    protected abstract Collection<V> createCollection();

    protected abstract Collection<V> createCollection(Collection<V> var1);

    protected abstract <K> Map<K, Collection<V>> createMap();

    @Override
    public boolean contains(R rowKey, C columnKey) {
        return this.table.getOrDefault(rowKey, Collections.emptyMap()).containsKey(columnKey);
    }

    @Override
    public boolean containsRow(R rowKey) {
        return this.table.containsKey(rowKey);
    }

    @Override
    public boolean containsColumn(C columnKey) {
        return this.table.values().stream().anyMatch(m -> m.containsKey(columnKey));
    }

    @Override
    public Collection<V> get(R rowKey, C columnKey) {
        return (Collection)this.table.getOrDefault(rowKey, Collections.emptyMap()).get(columnKey);
    }

    @Override
    public void clear() {
        this.table.clear();
    }

    @Override
    public V put(R rowKey, C columnKey, V value) {
        Map column = this.table.computeIfAbsent(rowKey, rk -> this.createMap());
        Collection values = column.computeIfAbsent(columnKey, ck -> this.createCollection());
        values.add(value);
        return value;
    }

    @Override
    public Collection<V> removeAll(R rowKey, C columnKey) {
        Map<C, Collection<V>> column = this.table.get(rowKey);
        if (column == null) {
            return null;
        }
        return column.remove(columnKey);
    }

    @Override
    public Map<C, Collection<V>> row(R rowKey) {
        return this.table.get(rowKey);
    }

    @Override
    public Iterable<V> rowValues(R rowKey) {
        return Iterables2.fromConcat(this.row(rowKey).values());
    }

    @Override
    public Map<R, Collection<V>> column(C columnKey) {
        return this.table.keySet().stream().collect(Collectors.toMap(Function.identity(), k -> this.get(k, columnKey)));
    }

    @Override
    public Iterable<V> columnValues(C columnKey) {
        return Iterables2.fromConcat(this.column(columnKey).values());
    }

    @Override
    public Set<Tuple3<R, C, Collection<V>>> cellSet() {
        return this.table.entrySet().stream().flatMap(row -> ((Map)row.getValue()).entrySet().stream().map(col -> Tuple3.of(row.getKey(), col.getKey(), (Collection)col.getValue()))).collect(Collectors.toSet());
    }

    @Override
    public Set<R> rowKeySet() {
        return this.table.keySet();
    }

    @Override
    public Set<C> columnKeySet() {
        return this.table.values().stream().flatMap(m -> m.keySet().stream()).collect(Collectors.toSet());
    }

    @Override
    public Iterable<V> values() {
        return this.table.values().stream().flatMap(m -> m.values().stream().flatMap(Collection::stream)).collect(Collectors.toSet());
    }

    @Override
    public Map<R, Map<C, Collection<V>>> rowMap() {
        return this.table;
    }
}

