/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.IBlobTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.ABlobTerm;
import mb.nabl2.terms.build.AbstractTerm;

final class BlobTerm
extends ABlobTerm
implements Serializable {
    private final IAttachments attachments;
    private final Object value;
    private static final long serialVersionUID = 42L;

    private BlobTerm(Object value) {
        this.value = Objects.requireNonNull(value, "value");
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private BlobTerm(Builder builder) {
        this.value = builder.value;
        this.attachments = builder.attachments != null ? builder.attachments : Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private BlobTerm(IAttachments attachments, Object value) {
        this.attachments = attachments;
        this.value = value;
    }

    @Override
    public IAttachments getAttachments() {
        return this.attachments;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public final BlobTerm withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return new BlobTerm(newValue, this.value);
    }

    public final BlobTerm withValue(Object value) {
        if (this.value == value) {
            return this;
        }
        Object newValue = Objects.requireNonNull(value, "value");
        return new BlobTerm(this.attachments, newValue);
    }

    public static BlobTerm of(Object value) {
        return new BlobTerm(value);
    }

    public static BlobTerm copyOf(ABlobTerm instance) {
        if (instance instanceof BlobTerm) {
            return (BlobTerm)instance;
        }
        return BlobTerm.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ BlobTerm(Builder builder, BlobTerm blobTerm) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        private IAttachments attachments;
        private Object value;

        private Builder() {
        }

        public final Builder from(ITerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ABlobTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(IBlobTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ITerm instance;
            long bits = 0L;
            if (object instanceof ITerm) {
                instance = (ITerm)object;
                if ((bits & 1L) == 0L) {
                    this.attachments(instance.getAttachments());
                    bits |= 1L;
                }
            }
            if (object instanceof ABlobTerm) {
                instance = (ABlobTerm)object;
                if ((bits & 2L) == 0L) {
                    this.value(((ABlobTerm)instance).getValue());
                    bits |= 2L;
                }
            }
            if (object instanceof AbstractTerm) {
                instance = (AbstractTerm)object;
                if ((bits & 1L) == 0L) {
                    this.attachments(((AbstractTerm)instance).getAttachments());
                    bits |= 1L;
                }
            }
            if (object instanceof IBlobTerm) {
                instance = (IBlobTerm)object;
                if ((bits & 2L) == 0L) {
                    this.value(instance.getValue());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.attachments(instance.getAttachments());
                    bits |= 1L;
                }
            }
        }

        public final Builder attachments(IAttachments attachments) {
            this.attachments = Objects.requireNonNull(attachments, "attachments");
            return this;
        }

        public final Builder value(Object value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public BlobTerm build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new BlobTerm(this, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build BlobTerm, some of required attributes are not set " + attributes;
        }
    }
}

