/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.spoofax.analysis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.solver.Fresh;
import mb.nabl2.solver.ISolution;
import mb.nabl2.spoofax.analysis.AMultiInitialResult;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.scopegraph.pepm16.terms.Scope;

public final class MultiInitialResult
extends AMultiInitialResult
implements Serializable {
    private final List<IConstraint> constraints;
    private final ISolution solution;
    private final ITerm customAnalysis;
    private final Set<ITermVar> globalVars;
    private final Set<Scope> globalScopes;
    private final Fresh.Immutable fresh;
    private static final long serialVersionUID = 42L;

    private MultiInitialResult(Iterable<? extends IConstraint> constraints, ISolution solution, Optional<? extends ITerm> customAnalysis, Iterable<? extends ITermVar> globalVars, Iterable<? extends Scope> globalScopes, Fresh.Immutable fresh) {
        this.constraints = MultiInitialResult.createUnmodifiableList(false, MultiInitialResult.createSafeList(constraints, true, false));
        this.solution = Objects.requireNonNull(solution, "solution");
        this.customAnalysis = customAnalysis.orElse(null);
        this.globalVars = MultiInitialResult.createUnmodifiableSet(MultiInitialResult.createSafeList(globalVars, true, false));
        this.globalScopes = MultiInitialResult.createUnmodifiableSet(MultiInitialResult.createSafeList(globalScopes, true, false));
        this.fresh = Objects.requireNonNull(fresh, "fresh");
    }

    private MultiInitialResult(MultiInitialResult original, List<IConstraint> constraints, ISolution solution, ITerm customAnalysis, Set<ITermVar> globalVars, Set<Scope> globalScopes, Fresh.Immutable fresh) {
        this.constraints = constraints;
        this.solution = solution;
        this.customAnalysis = customAnalysis;
        this.globalVars = globalVars;
        this.globalScopes = globalScopes;
        this.fresh = fresh;
    }

    @Override
    public List<IConstraint> constraints() {
        return this.constraints;
    }

    @Override
    public ISolution solution() {
        return this.solution;
    }

    @Override
    public Optional<ITerm> customAnalysis() {
        return Optional.ofNullable(this.customAnalysis);
    }

    @Override
    public Set<ITermVar> globalVars() {
        return this.globalVars;
    }

    @Override
    public Set<Scope> globalScopes() {
        return this.globalScopes;
    }

    @Override
    public Fresh.Immutable fresh() {
        return this.fresh;
    }

    public final MultiInitialResult withConstraints(IConstraint ... elements) {
        List<IConstraint> newValue = MultiInitialResult.createUnmodifiableList(false, MultiInitialResult.createSafeList(Arrays.asList(elements), true, false));
        return new MultiInitialResult(this, newValue, this.solution, this.customAnalysis, this.globalVars, this.globalScopes, this.fresh);
    }

    public final MultiInitialResult withConstraints(Iterable<? extends IConstraint> elements) {
        if (this.constraints == elements) {
            return this;
        }
        List<IConstraint> newValue = MultiInitialResult.createUnmodifiableList(false, MultiInitialResult.createSafeList(elements, true, false));
        return new MultiInitialResult(this, newValue, this.solution, this.customAnalysis, this.globalVars, this.globalScopes, this.fresh);
    }

    @Override
    public final MultiInitialResult withSolution(ISolution value) {
        if (this.solution == value) {
            return this;
        }
        ISolution newValue = Objects.requireNonNull(value, "solution");
        return new MultiInitialResult(this, this.constraints, newValue, this.customAnalysis, this.globalVars, this.globalScopes, this.fresh);
    }

    @Override
    public final MultiInitialResult withCustomAnalysis(ITerm value) {
        ITerm newValue = Objects.requireNonNull(value, "customAnalysis");
        if (this.customAnalysis == newValue) {
            return this;
        }
        return new MultiInitialResult(this, this.constraints, this.solution, newValue, this.globalVars, this.globalScopes, this.fresh);
    }

    public final MultiInitialResult withCustomAnalysis(Optional<? extends ITerm> optional) {
        ITerm value = optional.orElse(null);
        if (this.customAnalysis == value) {
            return this;
        }
        return new MultiInitialResult(this, this.constraints, this.solution, value, this.globalVars, this.globalScopes, this.fresh);
    }

    public final MultiInitialResult withGlobalVars(ITermVar ... elements) {
        Set<ITermVar> newValue = MultiInitialResult.createUnmodifiableSet(MultiInitialResult.createSafeList(Arrays.asList(elements), true, false));
        return new MultiInitialResult(this, this.constraints, this.solution, this.customAnalysis, newValue, this.globalScopes, this.fresh);
    }

    public final MultiInitialResult withGlobalVars(Iterable<? extends ITermVar> elements) {
        if (this.globalVars == elements) {
            return this;
        }
        Set<ITermVar> newValue = MultiInitialResult.createUnmodifiableSet(MultiInitialResult.createSafeList(elements, true, false));
        return new MultiInitialResult(this, this.constraints, this.solution, this.customAnalysis, newValue, this.globalScopes, this.fresh);
    }

    public final MultiInitialResult withGlobalScopes(Scope ... elements) {
        Set<Scope> newValue = MultiInitialResult.createUnmodifiableSet(MultiInitialResult.createSafeList(Arrays.asList(elements), true, false));
        return new MultiInitialResult(this, this.constraints, this.solution, this.customAnalysis, this.globalVars, newValue, this.fresh);
    }

    public final MultiInitialResult withGlobalScopes(Iterable<? extends Scope> elements) {
        if (this.globalScopes == elements) {
            return this;
        }
        Set<Scope> newValue = MultiInitialResult.createUnmodifiableSet(MultiInitialResult.createSafeList(elements, true, false));
        return new MultiInitialResult(this, this.constraints, this.solution, this.customAnalysis, this.globalVars, newValue, this.fresh);
    }

    @Override
    public final MultiInitialResult withFresh(Fresh.Immutable value) {
        if (this.fresh == value) {
            return this;
        }
        Fresh.Immutable newValue = Objects.requireNonNull(value, "fresh");
        return new MultiInitialResult(this, this.constraints, this.solution, this.customAnalysis, this.globalVars, this.globalScopes, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MultiInitialResult && this.equalTo(0, (MultiInitialResult)another);
    }

    private boolean equalTo(int synthetic, MultiInitialResult another) {
        return this.constraints.equals(another.constraints) && this.solution.equals(another.solution) && Objects.equals(this.customAnalysis, another.customAnalysis) && this.globalVars.equals(another.globalVars) && this.globalScopes.equals(another.globalScopes) && this.fresh.equals(another.fresh);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.constraints.hashCode();
        h += (h << 5) + this.solution.hashCode();
        h += (h << 5) + Objects.hashCode(this.customAnalysis);
        h += (h << 5) + this.globalVars.hashCode();
        h += (h << 5) + this.globalScopes.hashCode();
        h += (h << 5) + this.fresh.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MultiInitialResult{");
        builder.append("constraints=").append(this.constraints);
        builder.append(", ");
        builder.append("solution=").append(this.solution);
        if (this.customAnalysis != null) {
            builder.append(", ");
            builder.append("customAnalysis=").append(this.customAnalysis);
        }
        builder.append(", ");
        builder.append("globalVars=").append(this.globalVars);
        builder.append(", ");
        builder.append("globalScopes=").append(this.globalScopes);
        builder.append(", ");
        builder.append("fresh=").append(this.fresh);
        return builder.append("}").toString();
    }

    public static MultiInitialResult of(List<IConstraint> constraints, ISolution solution, Optional<ITerm> customAnalysis, Set<ITermVar> globalVars, Set<Scope> globalScopes, Fresh.Immutable fresh) {
        return MultiInitialResult.of(constraints, solution, customAnalysis, globalVars, globalScopes, fresh);
    }

    public static MultiInitialResult of(Iterable<? extends IConstraint> constraints, ISolution solution, Optional<? extends ITerm> customAnalysis, Iterable<? extends ITermVar> globalVars, Iterable<? extends Scope> globalScopes, Fresh.Immutable fresh) {
        return new MultiInitialResult(constraints, solution, customAnalysis, globalVars, globalScopes, fresh);
    }

    public static MultiInitialResult copyOf(AMultiInitialResult instance) {
        if (instance instanceof MultiInitialResult) {
            return (MultiInitialResult)instance;
        }
        return MultiInitialResult.of(instance.constraints(), instance.solution(), instance.customAnalysis(), instance.globalVars(), instance.globalScopes(), instance.fresh());
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }
}

