/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver.solvers;

import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.solver.SolverConfig;
import mb.nabl2.solver.solvers.BaseSolver;
import mb.nabl2.terms.unification.u.IUnifier;

public final class BaseSolution
extends BaseSolver.ABaseSolution
implements Serializable {
    private final SolverConfig config;
    private final Set.Immutable<IConstraint> constraints;
    private final IUnifier.Immutable unifier;
    private static final long serialVersionUID = 42L;

    private BaseSolution(SolverConfig config, Set.Immutable<IConstraint> constraints, IUnifier.Immutable unifier) {
        this.config = Objects.requireNonNull(config, "config");
        this.constraints = Objects.requireNonNull(constraints, "constraints");
        this.unifier = Objects.requireNonNull(unifier, "unifier");
    }

    private BaseSolution(BaseSolution original, SolverConfig config, Set.Immutable<IConstraint> constraints, IUnifier.Immutable unifier) {
        this.config = config;
        this.constraints = constraints;
        this.unifier = unifier;
    }

    @Override
    public SolverConfig config() {
        return this.config;
    }

    @Override
    public Set.Immutable<IConstraint> constraints() {
        return this.constraints;
    }

    @Override
    public IUnifier.Immutable unifier() {
        return this.unifier;
    }

    public final BaseSolution withConfig(SolverConfig value) {
        if (this.config == value) {
            return this;
        }
        SolverConfig newValue = Objects.requireNonNull(value, "config");
        return new BaseSolution(this, newValue, this.constraints, this.unifier);
    }

    public final BaseSolution withConstraints(Set.Immutable<IConstraint> value) {
        if (this.constraints == value) {
            return this;
        }
        Set.Immutable<IConstraint> newValue = Objects.requireNonNull(value, "constraints");
        return new BaseSolution(this, this.config, newValue, this.unifier);
    }

    public final BaseSolution withUnifier(IUnifier.Immutable value) {
        if (this.unifier == value) {
            return this;
        }
        IUnifier.Immutable newValue = Objects.requireNonNull(value, "unifier");
        return new BaseSolution(this, this.config, this.constraints, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BaseSolution && this.equalTo(0, (BaseSolution)another);
    }

    private boolean equalTo(int synthetic, BaseSolution another) {
        return this.config.equals(another.config) && this.constraints.equals(another.constraints) && this.unifier.equals(another.unifier);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.config.hashCode();
        h += (h << 5) + this.constraints.hashCode();
        h += (h << 5) + this.unifier.hashCode();
        return h;
    }

    public String toString() {
        return "BaseSolution{config=" + this.config + ", constraints=" + this.constraints + ", unifier=" + this.unifier + "}";
    }

    public static BaseSolution of(SolverConfig config, Set.Immutable<IConstraint> constraints, IUnifier.Immutable unifier) {
        return new BaseSolution(config, constraints, unifier);
    }

    public static BaseSolution copyOf(BaseSolver.ABaseSolution instance) {
        if (instance instanceof BaseSolution) {
            return (BaseSolution)instance;
        }
        return BaseSolution.of(instance.config(), instance.constraints(), instance.unifier());
    }
}

