/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.relations.variants;

import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import mb.nabl2.relations.variants.IVariance;
import mb.nabl2.relations.variants.IVariantMatcher;
import mb.nabl2.relations.variants.IVariantRelation;
import mb.nabl2.relations.variants.InstantiatedVariantsException;
import mb.nabl2.relations.variants.VariantRelationDescription;
import mb.scopegraph.relations.IRelation;
import mb.scopegraph.relations.RelationDescription;
import mb.scopegraph.relations.RelationException;
import mb.scopegraph.relations.impl.Relation;
import org.metaborg.util.collection.IRelation2;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.optionals.Optionals;
import org.metaborg.util.tuple.Tuple2;

public abstract class VariantRelation<T>
implements IVariantRelation<T> {
    protected VariantRelation() {
    }

    protected abstract IRelation<T> baseRelation();

    @Override
    public boolean isEmpty() {
        return this.baseRelation().isEmpty();
    }

    @Override
    public Set.Immutable<T> smaller(T t) {
        return this.baseRelation().smaller(t);
    }

    @Override
    public Set.Immutable<T> larger(T t) {
        return this.baseRelation().larger(t);
    }

    @Override
    public boolean contains(T t1, T t2) {
        for (IVariantMatcher<T> matcher : this.getVariantMatchers()) {
            Optional<Boolean> contains = Optionals.lift(matcher.match(t1), matcher.match(t2), (args1, args2) -> {
                if (args1.size() == args2.size() && Iterables2.stream(Iterables2.zip(args1, args2, (arg1, arg2) -> {
                    Object argt1 = arg1.getValue();
                    Object argt2 = arg2.getValue();
                    return arg1.getVariance().match(IVariance.cases(() -> argt1.equals(argt2), r -> this.contains(argt1, argt2), r -> this.contains(argt2, argt1)));
                })).allMatch(c -> c)) {
                    return true;
                }
                return false;
            });
            if (!contains.isPresent()) continue;
            return contains.get();
        }
        return this.baseRelation().contains(t1, t2);
    }

    protected void canAddOrThrow(T t1, T t2) throws RelationException {
        for (IVariantMatcher<T> matcher : this.getVariantMatchers()) {
            if (!Optionals.lift(matcher.match(t1), matcher.match(t2), (a1, a2) -> true).isPresent()) continue;
            throw new InstantiatedVariantsException("Cannot add instantiated pair of variant constructors to the relation: " + t1 + " and " + t2);
        }
    }

    @Override
    public Optional<T> leastUpperBound(T t1, T t2) {
        for (IVariantMatcher matcher : this.getVariantMatchers()) {
            Optional<Optional> contains = Optionals.lift(matcher.match(t1), matcher.match(t2), (args1, args2) -> Optionals.when(args1.size() == args2.size()).flatMap(eq -> Optionals.sequence(Iterables2.zip(args1, args2, (arg1, arg2) -> {
                Object argt1 = arg1.getValue();
                Object argt2 = arg2.getValue();
                return arg1.getVariance().match(IVariance.cases(() -> argt1.equals(argt2) ? Optional.of(argt1) : Optional.empty(), r -> this.leastUpperBound(argt1, argt2), r -> this.greatestLowerBound(argt1, argt2)));
            })).map(args -> matcher.build(new ArrayList(args)))));
            if (!contains.isPresent()) continue;
            return contains.get();
        }
        return this.baseRelation().leastUpperBound(t1, t2);
    }

    @Override
    public Optional<T> greatestLowerBound(T t1, T t2) {
        for (IVariantMatcher matcher : this.getVariantMatchers()) {
            Optional<Optional> contains = Optionals.lift(matcher.match(t1), matcher.match(t2), (args1, args2) -> Optionals.when(args1.size() == args2.size()).flatMap(eq -> Optionals.sequence(Iterables2.zip(args1, args2, (arg1, arg2) -> {
                Object argt1 = arg1.getValue();
                Object argt2 = arg2.getValue();
                return arg1.getVariance().match(IVariance.cases(() -> argt1.equals(argt2) ? Optional.of(argt1) : Optional.empty(), r -> this.greatestLowerBound(argt1, argt2), r -> this.leastUpperBound(argt1, argt2)));
            })).map(args -> matcher.build(new ArrayList(args)))));
            if (!contains.isPresent()) continue;
            return contains.get();
        }
        return this.baseRelation().greatestLowerBound(t1, t2);
    }

    @Override
    public Stream<Tuple2<T, T>> stream() {
        return this.entries().stream();
    }

    public static class Immutable<T>
    extends VariantRelation<T>
    implements IVariantRelation.Immutable<T>,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final VariantRelationDescription<T> description;
        private final IRelation.Immutable<T> baseRelation;

        protected Immutable(VariantRelationDescription<T> description, IRelation.Immutable<T> baseRelation) {
            this.description = description;
            this.baseRelation = baseRelation;
        }

        @Override
        protected IRelation.Immutable<T> baseRelation() {
            return this.baseRelation;
        }

        @Override
        public RelationDescription getDescription() {
            return this.description.relationDescription();
        }

        @Override
        public Iterable<IVariantMatcher<T>> getVariantMatchers() {
            return this.description.variantMatchers();
        }

        @Override
        public IRelation2<T, T> entries() {
            return this.baseRelation.entries();
        }

        @Override
        public IVariantRelation.Transient<T> melt() {
            return new Transient<T>(this.description, this.baseRelation.melt());
        }

        public static <T> IVariantRelation.Immutable<T> of(VariantRelationDescription<T> description) {
            return new Immutable<T>(description, Relation.Immutable.of(description.relationDescription()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Immutable immutable = (Immutable)o;
            return Objects.equals(this.description, immutable.description) && Objects.equals(this.baseRelation, immutable.baseRelation);
        }

        public int hashCode() {
            return Objects.hash(this.description, this.baseRelation);
        }
    }

    public static class Transient<T>
    extends VariantRelation<T>
    implements IVariantRelation.Transient<T> {
        private final VariantRelationDescription<T> description;
        private final IRelation.Transient<T> baseRelation;

        protected Transient(VariantRelationDescription<T> description, IRelation.Transient<T> baseRelation) {
            this.description = description;
            this.baseRelation = baseRelation;
        }

        @Override
        protected IRelation<T> baseRelation() {
            return this.baseRelation;
        }

        @Override
        public RelationDescription getDescription() {
            return this.description.relationDescription();
        }

        @Override
        public Iterable<IVariantMatcher<T>> getVariantMatchers() {
            return this.description.variantMatchers();
        }

        @Override
        public IRelation2<T, T> entries() {
            return this.baseRelation.entries();
        }

        @Override
        public boolean add(T t1, T t2) throws RelationException {
            this.canAddOrThrow(t1, t2);
            return this.baseRelation.add(t1, t2);
        }

        @Override
        public IVariantRelation.Immutable<T> freeze() {
            return new Immutable<T>(this.description, this.baseRelation.freeze());
        }

        public static <T> IVariantRelation.Transient<T> of(VariantRelationDescription<T> description) {
            return new Transient<T>(description, Relation.Transient.of(description.relationDescription()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Transient that = (Transient)o;
            return Objects.equals(this.description, that.description) && Objects.equals(this.baseRelation, that.baseRelation);
        }

        public int hashCode() {
            return Objects.hash(this.description, this.baseRelation);
        }
    }
}

