/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.scopegraph;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.scopegraph.ACGRef;
import mb.nabl2.terms.ITerm;

public final class CGRef
extends ACGRef
implements Serializable {
    private final ITerm reference;
    private final ITerm scope;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CGRef(ITerm reference, ITerm scope, IMessageInfo messageInfo) {
        this.reference = Objects.requireNonNull(reference, "reference");
        this.scope = Objects.requireNonNull(scope, "scope");
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CGRef(CGRef original, ITerm reference, ITerm scope, IMessageInfo messageInfo) {
        this.reference = reference;
        this.scope = scope;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public ITerm getReference() {
        return this.reference;
    }

    @Override
    public ITerm getScope() {
        return this.scope;
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CGRef withReference(ITerm value) {
        if (this.reference == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "reference");
        return new CGRef(this, newValue, this.scope, this.messageInfo);
    }

    public final CGRef withScope(ITerm value) {
        if (this.scope == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "scope");
        return new CGRef(this, this.reference, newValue, this.messageInfo);
    }

    public final CGRef withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return new CGRef(this, this.reference, this.scope, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CGRef && this.equalTo(0, (CGRef)another);
    }

    private boolean equalTo(int synthetic, CGRef another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.reference.equals(another.reference) && this.scope.equals(another.scope) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.reference.hashCode();
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CGRef of(ITerm reference, ITerm scope, IMessageInfo messageInfo) {
        return new CGRef(reference, scope, messageInfo);
    }

    public static CGRef copyOf(ACGRef instance) {
        if (instance instanceof CGRef) {
            return (CGRef)instance;
        }
        return CGRef.of(instance.getReference(), instance.getScope(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CGRef(this, this.reference, this.scope, this.messageInfo);
    }
}

