/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.scopegraph;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.scopegraph.ACGDecl;
import mb.nabl2.terms.ITerm;

public final class CGDecl
extends ACGDecl
implements Serializable {
    private final ITerm scope;
    private final ITerm declaration;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CGDecl(ITerm scope, ITerm declaration, IMessageInfo messageInfo) {
        this.scope = Objects.requireNonNull(scope, "scope");
        this.declaration = Objects.requireNonNull(declaration, "declaration");
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CGDecl(CGDecl original, ITerm scope, ITerm declaration, IMessageInfo messageInfo) {
        this.scope = scope;
        this.declaration = declaration;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public ITerm getScope() {
        return this.scope;
    }

    @Override
    public ITerm getDeclaration() {
        return this.declaration;
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CGDecl withScope(ITerm value) {
        if (this.scope == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "scope");
        return new CGDecl(this, newValue, this.declaration, this.messageInfo);
    }

    public final CGDecl withDeclaration(ITerm value) {
        if (this.declaration == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "declaration");
        return new CGDecl(this, this.scope, newValue, this.messageInfo);
    }

    public final CGDecl withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return new CGDecl(this, this.scope, this.declaration, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CGDecl && this.equalTo(0, (CGDecl)another);
    }

    private boolean equalTo(int synthetic, CGDecl another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.scope.equals(another.scope) && this.declaration.equals(another.declaration) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + this.declaration.hashCode();
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CGDecl of(ITerm scope, ITerm declaration, IMessageInfo messageInfo) {
        return new CGDecl(scope, declaration, messageInfo);
    }

    public static CGDecl copyOf(ACGDecl instance) {
        if (instance instanceof CGDecl) {
            return (CGDecl)instance;
        }
        return CGDecl.of(instance.getScope(), instance.getDeclaration(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CGDecl(this, this.scope, this.declaration, this.messageInfo);
    }
}

