/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.nameresolution;

import mb.nabl2.constraints.IConstraint;
import mb.nabl2.constraints.messages.IMessageContent;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.messages.MessageContent;
import mb.nabl2.constraints.namebinding.DeclProperties;
import mb.nabl2.constraints.nameresolution.CDeclProperty;
import mb.nabl2.constraints.nameresolution.INameResolutionConstraint;
import mb.nabl2.terms.ITerm;
import org.immutables.serial.Serial;
import org.immutables.value.Value;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class ACDeclProperty
implements INameResolutionConstraint {
    @Value.Parameter
    public abstract ITerm getDeclaration();

    @Value.Parameter
    public abstract ITerm getKey();

    @Value.Parameter
    public abstract ITerm getValue();

    @Value.Parameter
    public abstract int getPriority();

    @Override
    @Value.Parameter
    public abstract IMessageInfo getMessageInfo();

    @Value.Check
    public void check() {
        if (!this.getKey().isGround()) {
            throw new IllegalArgumentException("Key is not ground");
        }
    }

    @Override
    public <T> T match(INameResolutionConstraint.Cases<T> cases) {
        return cases.caseProperty((CDeclProperty)this);
    }

    @Override
    public <T> T match(IConstraint.Cases<T> cases) {
        return cases.caseNameResolution(this);
    }

    @Override
    public <T, E extends Throwable> T matchOrThrow(INameResolutionConstraint.CheckedCases<T, E> cases) throws E {
        return cases.caseProperty((CDeclProperty)this);
    }

    @Override
    public <T, E extends Throwable> T matchOrThrow(IConstraint.CheckedCases<T, E> cases) throws E {
        return cases.caseNameResolution(this);
    }

    @Override
    public IMessageContent pp() {
        if (this.getKey().equals(DeclProperties.TYPE_KEY)) {
            return MessageContent.builder().append(this.getDeclaration()).append(" : ").append(this.getValue()).build();
        }
        return MessageContent.builder().append(this.getDeclaration()).append(".").append(this.getKey()).append(" := ").append(this.getValue()).build();
    }

    public String toString() {
        return this.pp().toString();
    }
}

