/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.messages;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.messages.AMessageInfo;
import mb.nabl2.constraints.messages.IMessageContent;
import mb.nabl2.constraints.messages.MessageKind;
import mb.nabl2.terms.ITerm;

public final class MessageInfo
extends AMessageInfo
implements Serializable {
    private final MessageKind kind;
    private final IMessageContent content;
    private final ITerm originTerm;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private MessageInfo(MessageKind kind, IMessageContent content, ITerm originTerm) {
        this.kind = Objects.requireNonNull(kind, "kind");
        this.content = Objects.requireNonNull(content, "content");
        this.originTerm = Objects.requireNonNull(originTerm, "originTerm");
        this.hashCode = this.computeHashCode();
    }

    private MessageInfo(MessageInfo original, MessageKind kind, IMessageContent content, ITerm originTerm) {
        this.kind = kind;
        this.content = content;
        this.originTerm = originTerm;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public MessageKind getKind() {
        return this.kind;
    }

    @Override
    public IMessageContent getContent() {
        return this.content;
    }

    @Override
    public ITerm getOriginTerm() {
        return this.originTerm;
    }

    public final MessageInfo withKind(MessageKind value) {
        MessageKind newValue = Objects.requireNonNull(value, "kind");
        if (this.kind == newValue) {
            return this;
        }
        return new MessageInfo(this, newValue, this.content, this.originTerm);
    }

    @Override
    public final MessageInfo withContent(IMessageContent value) {
        if (this.content == value) {
            return this;
        }
        IMessageContent newValue = Objects.requireNonNull(value, "content");
        return new MessageInfo(this, this.kind, newValue, this.originTerm);
    }

    public final MessageInfo withOriginTerm(ITerm value) {
        if (this.originTerm == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "originTerm");
        return new MessageInfo(this, this.kind, this.content, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MessageInfo && this.equalTo(0, (MessageInfo)another);
    }

    private boolean equalTo(int synthetic, MessageInfo another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.kind.equals((Object)another.kind) && this.content.equals(another.content) && this.originTerm.equals(another.originTerm);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.kind.hashCode();
        h += (h << 5) + this.content.hashCode();
        h += (h << 5) + this.originTerm.hashCode();
        return h;
    }

    public static MessageInfo of(MessageKind kind, IMessageContent content, ITerm originTerm) {
        return new MessageInfo(kind, content, originTerm);
    }

    public static MessageInfo copyOf(AMessageInfo instance) {
        if (instance instanceof MessageInfo) {
            return (MessageInfo)instance;
        }
        return MessageInfo.of(instance.getKind(), instance.getContent(), instance.getOriginTerm());
    }

    private Object readResolve() throws ObjectStreamException {
        return new MessageInfo(this, this.kind, this.content, this.originTerm);
    }
}

